/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.Prerequisites;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import org.apache.maven.repository.internal.DefaultModelCache;
import org.apache.maven.repository.internal.DefaultModelResolver;
import org.apache.maven.repository.internal.RelocatedArtifact;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.aether.RepositoryEvent;
import org.sonatype.aether.RepositoryException;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.RequestTrace;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.artifact.ArtifactType;
import org.sonatype.aether.artifact.ArtifactTypeRegistry;
import org.sonatype.aether.graph.Exclusion;
import org.sonatype.aether.impl.ArtifactDescriptorReader;
import org.sonatype.aether.impl.ArtifactResolver;
import org.sonatype.aether.impl.RemoteRepositoryManager;
import org.sonatype.aether.impl.RepositoryEventDispatcher;
import org.sonatype.aether.impl.VersionResolver;
import org.sonatype.aether.repository.WorkspaceRepository;
import org.sonatype.aether.resolution.ArtifactDescriptorException;
import org.sonatype.aether.resolution.ArtifactDescriptorRequest;
import org.sonatype.aether.resolution.ArtifactDescriptorResult;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.VersionRequest;
import org.sonatype.aether.resolution.VersionResolutionException;
import org.sonatype.aether.resolution.VersionResult;
import org.sonatype.aether.spi.locator.Service;
import org.sonatype.aether.spi.locator.ServiceLocator;
import org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.spi.log.NullLogger;
import org.sonatype.aether.transfer.ArtifactNotFoundException;
import org.sonatype.aether.util.DefaultRequestTrace;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.artifact.DefaultArtifactType;
import org.sonatype.aether.util.listener.DefaultRepositoryEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ArtifactDescriptorReader.class)
public class DefaultArtifactDescriptorReader
implements ArtifactDescriptorReader,
Service {
    @Requirement
    private Logger logger = NullLogger.INSTANCE;
    @Requirement
    private RemoteRepositoryManager remoteRepositoryManager;
    @Requirement
    private VersionResolver versionResolver;
    @Requirement
    private ArtifactResolver artifactResolver;
    @Requirement
    private RepositoryEventDispatcher repositoryEventDispatcher;
    @Requirement
    private ModelBuilder modelBuilder;

    public void initService(ServiceLocator locator) {
        this.setLogger((Logger)locator.getService(Logger.class));
        this.setRemoteRepositoryManager((RemoteRepositoryManager)locator.getService(RemoteRepositoryManager.class));
        this.setVersionResolver((VersionResolver)locator.getService(VersionResolver.class));
        this.setArtifactResolver((ArtifactResolver)locator.getService(ArtifactResolver.class));
        this.setRepositoryEventDispatcher((RepositoryEventDispatcher)locator.getService(RepositoryEventDispatcher.class));
        this.modelBuilder = (ModelBuilder)locator.getService(ModelBuilder.class);
        if (this.modelBuilder == null) {
            this.setModelBuilder((ModelBuilder)new DefaultModelBuilderFactory().newInstance());
        }
    }

    public DefaultArtifactDescriptorReader setLogger(Logger logger) {
        this.logger = logger != null ? logger : NullLogger.INSTANCE;
        return this;
    }

    public DefaultArtifactDescriptorReader setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        if (remoteRepositoryManager == null) {
            throw new IllegalArgumentException("remote repository manager has not been specified");
        }
        this.remoteRepositoryManager = remoteRepositoryManager;
        return this;
    }

    public DefaultArtifactDescriptorReader setVersionResolver(VersionResolver versionResolver) {
        if (versionResolver == null) {
            throw new IllegalArgumentException("version resolver has not been specified");
        }
        this.versionResolver = versionResolver;
        return this;
    }

    public DefaultArtifactDescriptorReader setArtifactResolver(ArtifactResolver artifactResolver) {
        if (artifactResolver == null) {
            throw new IllegalArgumentException("artifact resolver has not been specified");
        }
        this.artifactResolver = artifactResolver;
        return this;
    }

    public DefaultArtifactDescriptorReader setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        if (repositoryEventDispatcher == null) {
            throw new IllegalArgumentException("repository event dispatcher has not been specified");
        }
        this.repositoryEventDispatcher = repositoryEventDispatcher;
        return this;
    }

    public DefaultArtifactDescriptorReader setModelBuilder(ModelBuilder modelBuilder) {
        if (modelBuilder == null) {
            throw new IllegalArgumentException("model builder has not been specified");
        }
        this.modelBuilder = modelBuilder;
        return this;
    }

    public ArtifactDescriptorResult readArtifactDescriptor(RepositorySystemSession session, ArtifactDescriptorRequest request) throws ArtifactDescriptorException {
        ArtifactDescriptorResult result = new ArtifactDescriptorResult(request);
        Model model = this.loadPom(session, request, result);
        if (model != null) {
            ArtifactTypeRegistry stereotypes = session.getArtifactTypeRegistry();
            for (Repository r : model.getRepositories()) {
                result.addRepository(ArtifactDescriptorUtils.toRemoteRepository(r));
            }
            for (Dependency dependency : model.getDependencies()) {
                result.addDependency(this.convert(dependency, stereotypes));
            }
            DependencyManagement mngt = model.getDependencyManagement();
            if (mngt != null) {
                for (Dependency dependency : mngt.getDependencies()) {
                    result.addManagedDependency(this.convert(dependency, stereotypes));
                }
            }
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            Prerequisites prerequisites = model.getPrerequisites();
            if (prerequisites != null) {
                properties.put("prerequisites.maven", prerequisites.getMaven());
            }
            List licenses = model.getLicenses();
            properties.put("license.count", licenses.size());
            for (int i = 0; i < licenses.size(); ++i) {
                License license = (License)licenses.get(i);
                properties.put("license." + i + ".name", license.getName());
                properties.put("license." + i + ".url", license.getUrl());
                properties.put("license." + i + ".comments", license.getComments());
                properties.put("license." + i + ".distribution", license.getDistribution());
            }
            result.setProperties(properties);
        }
        return result;
    }

    private Model loadPom(RepositorySystemSession session, ArtifactDescriptorRequest request, ArtifactDescriptorResult result) throws ArtifactDescriptorException {
        Model model;
        RequestTrace trace = DefaultRequestTrace.newChild((RequestTrace)request.getTrace(), (Object)request);
        LinkedHashSet<String> visited = new LinkedHashSet<String>();
        Object artifact = request.getArtifact();
        while (true) {
            ArtifactResult resolveResult;
            try {
                VersionRequest versionRequest = new VersionRequest(artifact, request.getRepositories(), request.getRequestContext());
                versionRequest.setTrace(trace);
                VersionResult versionResult = this.versionResolver.resolveVersion(session, versionRequest);
                artifact = artifact.setVersion(versionResult.getVersion());
            }
            catch (VersionResolutionException e) {
                result.addException((Exception)((Object)e));
                throw new ArtifactDescriptorException(result);
            }
            if (!visited.add(artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + artifact.getBaseVersion())) {
                RepositoryException exception = new RepositoryException("Artifact relocations form a cycle: " + visited);
                this.invalidDescriptor(session, trace, (Artifact)artifact, (Exception)exception);
                if (session.isIgnoreInvalidArtifactDescriptor()) {
                    return null;
                }
                result.addException((Exception)exception);
                throw new ArtifactDescriptorException(result);
            }
            Artifact pomArtifact = ArtifactDescriptorUtils.toPomArtifact(artifact);
            try {
                ArtifactRequest resolveRequest = new ArtifactRequest(pomArtifact, request.getRepositories(), request.getRequestContext());
                resolveRequest.setTrace(trace);
                resolveResult = this.artifactResolver.resolveArtifact(session, resolveRequest);
                pomArtifact = resolveResult.getArtifact();
                result.setRepository(resolveResult.getRepository());
            }
            catch (ArtifactResolutionException e) {
                if (e.getCause() instanceof ArtifactNotFoundException) {
                    this.missingDescriptor(session, trace, (Artifact)artifact, (Exception)e.getCause());
                    if (session.isIgnoreMissingArtifactDescriptor()) {
                        return null;
                    }
                }
                result.addException((Exception)((Object)e));
                throw new ArtifactDescriptorException(result);
            }
            try {
                DefaultModelBuildingRequest modelRequest = new DefaultModelBuildingRequest();
                modelRequest.setValidationLevel(0);
                modelRequest.setProcessPlugins(false);
                modelRequest.setTwoPhaseBuilding(false);
                modelRequest.setSystemProperties(this.toProperties(session.getUserProperties(), session.getSystemProperties()));
                modelRequest.setModelCache(DefaultModelCache.newInstance(session));
                modelRequest.setModelResolver((ModelResolver)new DefaultModelResolver(session, trace.newChild((Object)modelRequest), request.getRequestContext(), this.artifactResolver, this.remoteRepositoryManager, request.getRepositories()));
                if (resolveResult.getRepository() instanceof WorkspaceRepository) {
                    modelRequest.setPomFile(pomArtifact.getFile());
                } else {
                    modelRequest.setModelSource((ModelSource)new FileModelSource(pomArtifact.getFile()));
                }
                model = this.modelBuilder.build((ModelBuildingRequest)modelRequest).getEffectiveModel();
            }
            catch (ModelBuildingException e) {
                for (ModelProblem problem : e.getProblems()) {
                    if (!(problem.getException() instanceof UnresolvableModelException)) continue;
                    result.addException(problem.getException());
                    throw new ArtifactDescriptorException(result);
                }
                this.invalidDescriptor(session, trace, (Artifact)artifact, (Exception)((Object)e));
                if (session.isIgnoreInvalidArtifactDescriptor()) {
                    return null;
                }
                result.addException((Exception)((Object)e));
                throw new ArtifactDescriptorException(result);
            }
            Relocation relocation = this.getRelocation(model);
            if (relocation == null) break;
            result.addRelocation(artifact);
            artifact = new RelocatedArtifact((Artifact)artifact, relocation.getGroupId(), relocation.getArtifactId(), relocation.getVersion());
            result.setArtifact(artifact);
        }
        return model;
    }

    private Properties toProperties(Map<String, String> dominant, Map<String, String> recessive) {
        Properties props = new Properties();
        if (recessive != null) {
            props.putAll(recessive);
        }
        if (dominant != null) {
            props.putAll(dominant);
        }
        return props;
    }

    private Relocation getRelocation(Model model) {
        Relocation relocation = null;
        DistributionManagement distMngt = model.getDistributionManagement();
        if (distMngt != null) {
            relocation = distMngt.getRelocation();
        }
        return relocation;
    }

    private org.sonatype.aether.graph.Dependency convert(Dependency dependency, ArtifactTypeRegistry stereotypes) {
        ArtifactType stereotype = stereotypes.get(dependency.getType());
        if (stereotype == null) {
            stereotype = new DefaultArtifactType(dependency.getType());
        }
        boolean system = dependency.getSystemPath() != null && dependency.getSystemPath().length() > 0;
        Map<String, String> props = null;
        if (system) {
            props = Collections.singletonMap("localPath", dependency.getSystemPath());
        }
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), null, dependency.getVersion(), props, stereotype);
        ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>(dependency.getExclusions().size());
        for (org.apache.maven.model.Exclusion exclusion : dependency.getExclusions()) {
            exclusions.add(this.convert(exclusion));
        }
        org.sonatype.aether.graph.Dependency result = new org.sonatype.aether.graph.Dependency((Artifact)artifact, dependency.getScope(), dependency.isOptional(), exclusions);
        return result;
    }

    private Exclusion convert(org.apache.maven.model.Exclusion exclusion) {
        return new Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), "*", "*");
    }

    private void missingDescriptor(RepositorySystemSession session, RequestTrace trace, Artifact artifact, Exception exception) {
        DefaultRepositoryEvent event = new DefaultRepositoryEvent(RepositoryEvent.EventType.ARTIFACT_DESCRIPTOR_MISSING, session, trace);
        event.setArtifact(artifact);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch((RepositoryEvent)event);
    }

    private void invalidDescriptor(RepositorySystemSession session, RequestTrace trace, Artifact artifact, Exception exception) {
        DefaultRepositoryEvent event = new DefaultRepositoryEvent(RepositoryEvent.EventType.ARTIFACT_DESCRIPTOR_INVALID, session, trace);
        event.setArtifact(artifact);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch((RepositoryEvent)event);
    }
}

