/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.jvm;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Task;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.internal.AbstractBuildableComponentSpec;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.jvm.ClassDirectoryBinarySpecInternal;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.jvm.ClassDirectoryBinarySpec;
import org.gradle.jvm.internal.toolchain.JavaToolChainInternal;
import org.gradle.jvm.platform.JavaPlatform;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.model.ModelMap;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.BinaryTasksCollection;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.Platform;
import org.gradle.platform.base.internal.BinaryBuildAbility;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.platform.base.internal.ComponentSpecIdentifier;
import org.gradle.platform.base.internal.DefaultBinaryTasksCollection;
import org.gradle.platform.base.internal.FixedBuildAbility;
import org.gradle.platform.base.internal.ToolSearchBuildAbility;
import org.gradle.platform.base.internal.toolchain.ToolSearchResult;

public class DefaultClassDirectoryBinarySpec
extends AbstractBuildableComponentSpec
implements ClassDirectoryBinarySpecInternal {
    private final DomainObjectSet<LanguageSourceSet> sourceSets;
    private final SourceSet sourceSet;
    private final JavaToolChain toolChain;
    private final JavaPlatform platform;
    private final BinaryTasksCollection tasks;
    private boolean buildable = true;

    public DefaultClassDirectoryBinarySpec(ComponentSpecIdentifier componentIdentifier, SourceSet sourceSet, JavaToolChain toolChain, JavaPlatform platform, Instantiator instantiator, NamedEntityInstantiator<Task> taskInstantiator, CollectionCallbackActionDecorator collectionCallbackActionDecorator, DomainObjectCollectionFactory domainObjectCollectionFactory) {
        super(componentIdentifier, ClassDirectoryBinarySpec.class);
        this.sourceSet = sourceSet;
        this.toolChain = toolChain;
        this.platform = platform;
        this.sourceSets = domainObjectCollectionFactory.newDomainObjectSet(LanguageSourceSet.class);
        this.tasks = (BinaryTasksCollection)instantiator.newInstance(DefaultBinaryTasksCollection.class, new Object[]{this, taskInstantiator, collectionCallbackActionDecorator});
    }

    public LibraryBinaryIdentifier getId() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public ComponentSpec getComponent() {
        return null;
    }

    public String getProjectScopedName() {
        return this.getName();
    }

    public Class<? extends BinarySpec> getPublicType() {
        return ClassDirectoryBinarySpec.class;
    }

    public BinaryTasksCollection getTasks() {
        return this.tasks;
    }

    public JavaToolChain getToolChain() {
        return this.toolChain;
    }

    public JavaPlatform getTargetPlatform() {
        return this.platform;
    }

    public void setTargetPlatform(JavaPlatform platform) {
        throw new UnsupportedOperationException();
    }

    public void setToolChain(JavaToolChain toolChain) {
        throw new UnsupportedOperationException();
    }

    public boolean isBuildable() {
        return this.getBuildAbility().isBuildable();
    }

    public void setBuildable(boolean buildable) {
        this.buildable = buildable;
    }

    public boolean isLegacyBinary() {
        return true;
    }

    public File getClassesDir() {
        return (File)this.sourceSet.getJava().getDestinationDirectory().getAsFile().get();
    }

    public void setClassesDir(File classesDir) {
        this.sourceSet.getJava().getDestinationDirectory().set(classesDir);
    }

    public File getResourcesDir() {
        return this.sourceSet.getOutput().getResourcesDir();
    }

    public void setResourcesDir(File resourcesDir) {
        this.sourceSet.getOutput().setResourcesDir(resourcesDir);
    }

    public ModelMap<LanguageSourceSet> getSources() {
        throw new UnsupportedOperationException();
    }

    public BinaryNamingScheme getNamingScheme() {
        throw new UnsupportedOperationException();
    }

    public void setNamingScheme(BinaryNamingScheme namingScheme) {
        throw new UnsupportedOperationException();
    }

    public boolean hasCodependentSources() {
        throw new UnsupportedOperationException();
    }

    public DomainObjectSet<LanguageSourceSet> getInputs() {
        return this.sourceSets;
    }

    @Override
    public void addSourceSet(LanguageSourceSet sourceSet) {
        this.sourceSets.add((Object)sourceSet);
    }

    protected String getTypeName() {
        return "Classes";
    }

    public BinaryBuildAbility getBuildAbility() {
        if (!this.buildable) {
            return new FixedBuildAbility(false);
        }
        return new ToolSearchBuildAbility((ToolSearchResult)((JavaToolChainInternal)this.getToolChain()).select((Platform)this.getTargetPlatform()));
    }
}

