/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemNode;
import org.gradle.internal.snapshot.SnapshotHierarchy;

class SnapshotCollectingDiffListener
implements SnapshotHierarchy.NodeDiffListener {
    private final List<CompleteFileSystemLocationSnapshot> removedSnapshots;
    private final List<CompleteFileSystemLocationSnapshot> addedSnapshots;
    private final Predicate<String> watchFilter;

    public SnapshotCollectingDiffListener(Predicate<String> watchFilter) {
        this.watchFilter = watchFilter;
        this.removedSnapshots = new ArrayList<CompleteFileSystemLocationSnapshot>();
        this.addedSnapshots = new ArrayList<CompleteFileSystemLocationSnapshot>();
    }

    public void publishSnapshotDiff(SnapshotHierarchy.SnapshotDiffListener snapshotDiffListener) {
        if (!this.removedSnapshots.isEmpty() || !this.addedSnapshots.isEmpty()) {
            snapshotDiffListener.changed(this.removedSnapshots, this.addedSnapshots);
        }
    }

    private void extractRootSnapshots(FileSystemNode rootNode, Consumer<CompleteFileSystemLocationSnapshot> consumer) {
        rootNode.accept(snapshot -> {
            if (this.watchFilter.test(snapshot.getAbsolutePath())) {
                consumer.accept(snapshot);
            }
        });
    }

    @Override
    public void nodeRemoved(FileSystemNode node) {
        this.extractRootSnapshots(node, this.removedSnapshots::add);
    }

    @Override
    public void nodeAdded(FileSystemNode node) {
        this.extractRootSnapshots(node, this.addedSnapshots::add);
    }
}

