/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.io.Serializable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.collection.Collections;
import javaslang.collection.LinearSeq;
import javaslang.collection.Stack;

public interface List<T>
extends LinearSeq<T>,
Stack<T> {
    public static final long serialVersionUID = 1L;

    public static <T> List<T> empty() {
        return Nil.instance();
    }

    @Override
    public boolean isEmpty();

    public static <T> List<T> of(T element) {
        return new Cons(element, Nil.instance());
    }

    public static <T> List<T> ofAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (elements instanceof List) {
            return (List)elements;
        }
        if (elements instanceof java.util.List) {
            List result2 = Nil.instance();
            java.util.List list2 = (java.util.List)elements;
            ListIterator iterator2 = list2.listIterator(list2.size());
            while (iterator2.hasPrevious()) {
                result2 = result2.prepend(iterator2.previous());
            }
            return result2;
        }
        if (elements instanceof NavigableSet) {
            List result3 = Nil.instance();
            Iterator iterator3 = ((NavigableSet)elements).descendingIterator();
            while (iterator3.hasNext()) {
                result3 = result3.prepend(iterator3.next());
            }
            return result3;
        }
        List<T> result4 = Nil.instance();
        for (T element : elements) {
            result4 = result4.prepend(element);
        }
        return result4.reverse();
    }

    default public List<T> dropRight(long n) {
        if (n <= 0L) {
            return this;
        }
        if (n >= (long)this.length()) {
            return List.empty();
        }
        return List.ofAll(this.iterator().dropRight(n));
    }

    default public List<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        List filtered = this.foldLeft(List.empty(), (xs, x) -> predicate.test(x) ? xs.prepend(x) : xs);
        return this.length() == filtered.length() ? this : filtered.reverse();
    }

    @Override
    default public T get(int index2) {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("get(" + index2 + ") on Nil");
        }
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("get(" + index2 + ")");
        }
        LinearSeq<T> list2 = this;
        for (int i = index2 - 1; i >= 0; --i) {
            if (!(list2 = list2.tail()).isEmpty()) continue;
            throw new IndexOutOfBoundsException(String.format("get(%s) on List of length %s", index2, index2 - i));
        }
        return list2.head();
    }

    default public List<T> init() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("init of empty list");
        }
        return this.dropRight(1L);
    }

    @Override
    public int length();

    @Override
    default public boolean isTraversableAgain() {
        return true;
    }

    @Override
    default public <U> List<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        List<U> list2 = List.empty();
        for (Object t : this) {
            list2 = list2.prepend(mapper.apply(t));
        }
        return list2.reverse();
    }

    @Override
    default public Tuple2<T, List<T>> pop2() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("pop2 of empty list");
        }
        return Tuple.of(this.head(), this.tail());
    }

    default public List<T> prepend(T element) {
        return new Cons(element, this);
    }

    @Override
    default public List<T> push(T element) {
        return new Cons(element, this);
    }

    default public List<T> pushAll(Iterable<T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        List<T> result2 = this;
        for (T element : elements) {
            result2 = result2.prepend(element);
        }
        return result2;
    }

    default public List<T> remove(T element) {
        List preceding = Nil.instance();
        LinearSeq<Object> tail = this;
        boolean found2 = false;
        while (!found2 && !tail.isEmpty()) {
            Object head = tail.head();
            if (Objects.equals(head, element)) {
                found2 = true;
            } else {
                preceding = preceding.prepend(head);
            }
            tail = tail.tail();
        }
        if (!found2) {
            return this;
        }
        List result2 = tail;
        for (Object next : preceding) {
            result2 = result2.prepend(next);
        }
        return result2;
    }

    default public List<T> removeFirst(Predicate<T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        List<Object> init = List.empty();
        LinearSeq<T> tail = this;
        while (!tail.isEmpty() && !predicate.test(tail.head())) {
            init = init.prepend(tail.head());
            tail = tail.tail();
        }
        if (tail.isEmpty()) {
            return this;
        }
        return init.foldLeft(tail.tail(), List::prepend);
    }

    default public List<T> replace(T currentElement, T newElement) {
        List preceding = Nil.instance();
        LinearSeq<T> tail = this;
        while (!tail.isEmpty() && !Objects.equals(tail.head(), currentElement)) {
            preceding = preceding.prepend(tail.head());
            tail = tail.tail();
        }
        if (tail.isEmpty()) {
            return this;
        }
        List result2 = tail.tail().prepend(newElement);
        for (Object next : preceding) {
            result2 = result2.prepend(next);
        }
        return result2;
    }

    default public List<T> reverse() {
        return this.isEmpty() ? this : this.foldLeft(List.empty(), List::prepend);
    }

    @Override
    default public Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.length(), 1040);
    }

    @Override
    default public String stringPrefix() {
        return "List";
    }

    @Override
    public List<T> tail();

    public static final class Cons<T>
    implements Serializable,
    List<T> {
        private static final long serialVersionUID = 1L;
        private final T head;
        private final List<T> tail;
        private final int length;

        private Cons(T head, List<T> tail) {
            this.head = head;
            this.tail = tail;
            this.length = 1 + tail.length();
        }

        @Override
        public T head() {
            return this.head;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public List<T> tail() {
            return this.tail;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof List) {
                LinearSeq<T> list1 = this;
                LinearSeq list2 = (List)o;
                while (!list1.isEmpty() && !list2.isEmpty()) {
                    boolean isEqual = Objects.equals(list1.head(), list2.head());
                    if (!isEqual) {
                        return false;
                    }
                    list1 = list1.tail();
                    list2 = list2.tail();
                }
                return list1.isEmpty() && list2.isEmpty();
            }
            return false;
        }

        public int hashCode() {
            return Collections.hash(this);
        }

        @Override
        public String toString() {
            return this.mkString(this.stringPrefix() + "(", ", ", ")");
        }
    }

    public static final class Nil<T>
    implements Serializable,
    List<T> {
        private static final long serialVersionUID = 1L;
        private static final Nil<?> INSTANCE = new Nil();

        private Nil() {
        }

        public static <T> Nil<T> instance() {
            return INSTANCE;
        }

        @Override
        public T head() {
            throw new NoSuchElementException("head of empty list");
        }

        @Override
        public int length() {
            return 0;
        }

        @Override
        public List<T> tail() {
            throw new UnsupportedOperationException("tail of empty list");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public int hashCode() {
            return 1;
        }

        @Override
        public String toString() {
            return this.stringPrefix() + "()";
        }
    }
}

