/*
 * Copyright 2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.api.internal.lambdas;

import org.gradle.api.Action;
import org.gradle.api.specs.Spec;

import java.io.Serializable;

/**
 * Provides a mechanism for creating Java lambdas that can be stored to the instant execution cache.
 *
 * The methods on this class are meant to be statically imported.
 */
public class SerializableLambdas {

    public static <T> Spec<T> spec(SerializableSpec<T> spec) {
        return spec;
    }

    public static <T> Action<T> action(SerializableAction<T> action) {
        return action;
    }

    /**
     * A {@link Serializable} version of {@link Spec}.
     */
    public interface SerializableSpec<T> extends Spec<T>, Serializable {
    }

    /**
     * A {@link Serializable} version of {@link Action}.
     */
    public interface SerializableAction<T> extends Action<T>, Serializable {
    }

    private SerializableLambdas() {
    }
}
