/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirConstKind;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0013\u001a\u0004\u0018\u0001H\u0014\"\n\b\u0000\u0010\u0014\u0018\u0001*\u00020\u0015*\u00020\u0004H\u0086\b\u00a2\u0006\u0002\u0010\u0016\u001a\u001e\u0010\u0017\u001a\u0002H\u0014\"\n\b\u0000\u0010\u0014\u0018\u0001*\u00020\u0015*\u00020\u0004H\u0086\b\u00a2\u0006\u0002\u0010\u0016\u001a\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0019*\b\u0012\u0004\u0012\u00020\b0\u0019\u001a\u001c\u0010\u001a\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002\u001a\n\u0010\u001e\u001a\u00020\u0003*\u00020\u0004\u001a\u0010\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010 *\u00020!\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0005\"\u0015\u0010\u0006\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0005\"\u0015\u0010\u0007\u001a\u00020\u0003*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\"\u0015\u0010\n\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0005\"\u0015\u0010\u000b\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0005\"\u0015\u0010\f\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0005\"\u0015\u0010\r\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0005\"\u0015\u0010\u000e\u001a\u00020\u000f*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"EXTENSION_FUNCTION_ANNOTATION", "", "isAny", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)Z", "isBoolean", "isExtensionFunctionAnnotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;)Z", "isNothing", "isNullableAny", "isNullableNothing", "isUnit", "parametersCount", "", "Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeRef;", "getParametersCount", "(Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeRef;)I", "coneTypeSafe", "T", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "coneTypeUnsafe", "dropExtensionFunctionAnnotation", "", "isBuiltinType", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "isNullable", "isExtensionFunctionType", "toConstKind", "Lorg/jetbrains/kotlin/fir/expressions/FirConstKind;", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "tree"})
public final class FirTypeUtilsKt {
    @NotNull
    public static final String EXTENSION_FUNCTION_ANNOTATION = "kotlin/ExtensionFunctionType";

    @NotNull
    public static final /* synthetic */ <T extends ConeKotlinType> T coneTypeUnsafe(@NotNull FirTypeRef $this$coneTypeUnsafe) {
        int $i$f$coneTypeUnsafe = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$coneTypeUnsafe, (String)"$this$coneTypeUnsafe");
        ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$coneTypeUnsafe).getType();
        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
        return (T)coneKotlinType;
    }

    @Nullable
    public static final /* synthetic */ <T extends ConeKotlinType> T coneTypeSafe(@NotNull FirTypeRef $this$coneTypeSafe) {
        int $i$f$coneTypeSafe = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$coneTypeSafe, (String)"$this$coneTypeSafe");
        FirTypeRef firTypeRef = $this$coneTypeSafe;
        if (!(firTypeRef instanceof FirResolvedTypeRef)) {
            firTypeRef = null;
        }
        FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)coneKotlinType;
    }

    public static final boolean isAny(@NotNull FirTypeRef $this$isAny) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isAny, (String)"$this$isAny");
        return FirTypeUtilsKt.isBuiltinType($this$isAny, StandardClassIds.INSTANCE.getAny(), false);
    }

    public static final boolean isNullableAny(@NotNull FirTypeRef $this$isNullableAny) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isNullableAny, (String)"$this$isNullableAny");
        return FirTypeUtilsKt.isBuiltinType($this$isNullableAny, StandardClassIds.INSTANCE.getAny(), true);
    }

    public static final boolean isNothing(@NotNull FirTypeRef $this$isNothing) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isNothing, (String)"$this$isNothing");
        return FirTypeUtilsKt.isBuiltinType($this$isNothing, StandardClassIds.INSTANCE.getNothing(), false);
    }

    public static final boolean isNullableNothing(@NotNull FirTypeRef $this$isNullableNothing) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isNullableNothing, (String)"$this$isNullableNothing");
        return FirTypeUtilsKt.isBuiltinType($this$isNullableNothing, StandardClassIds.INSTANCE.getNothing(), true);
    }

    public static final boolean isUnit(@NotNull FirTypeRef $this$isUnit) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isUnit, (String)"$this$isUnit");
        return FirTypeUtilsKt.isBuiltinType($this$isUnit, StandardClassIds.INSTANCE.getUnit(), false);
    }

    public static final boolean isBoolean(@NotNull FirTypeRef $this$isBoolean) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isBoolean, (String)"$this$isBoolean");
        return FirTypeUtilsKt.isBuiltinType($this$isBoolean, StandardClassIds.INSTANCE.getBoolean(), false);
    }

    private static final boolean isBuiltinType(@NotNull FirTypeRef $this$isBuiltinType, ClassId classId, boolean isNullable2) {
        ConeClassLikeType coneClassLikeType;
        FirTypeRef firTypeRef = $this$isBuiltinType;
        if (firTypeRef instanceof FirImplicitBuiltinTypeRef) {
            coneClassLikeType = ((FirImplicitBuiltinTypeRef)$this$isBuiltinType).getType();
        } else if (firTypeRef instanceof FirResolvedTypeRef) {
            ConeKotlinType coneKotlinType = ((FirResolvedTypeRef)$this$isBuiltinType).getType();
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((coneClassLikeType = (ConeClassLikeType)coneKotlinType) == null) {
                return false;
            }
        } else {
            return false;
        }
        ConeClassLikeType type2 = coneClassLikeType;
        return Intrinsics.areEqual((Object)type2.getLookupTag().getClassId(), (Object)classId) && ConeTypeUtilsKt.isNullable(type2) == isNullable2;
    }

    public static final int getParametersCount(@NotNull FirFunctionTypeRef $this$parametersCount) {
        Intrinsics.checkParameterIsNotNull((Object)$this$parametersCount, (String)"$this$parametersCount");
        return $this$parametersCount.getReceiverTypeRef() != null ? $this$parametersCount.getValueParameters().size() + 1 : $this$parametersCount.getValueParameters().size();
    }

    public static final boolean isExtensionFunctionType(@NotNull FirTypeRef $this$isExtensionFunctionType) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)$this$isExtensionFunctionType, (String)"$this$isExtensionFunctionType");
            Iterable $this$any$iv = $this$isExtensionFunctionType.getAnnotations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirAnnotationCall it = (FirAnnotationCall)element$iv;
                    boolean bl2 = false;
                    if (!FirTypeUtilsKt.isExtensionFunctionAnnotationCall(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isExtensionFunctionAnnotationCall(@NotNull FirAnnotationCall $this$isExtensionFunctionAnnotationCall) {
        Boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$this$isExtensionFunctionAnnotationCall, (String)"$this$isExtensionFunctionAnnotationCall");
        FirAnnotationCall firAnnotationCall = $this$isExtensionFunctionAnnotationCall;
        if (firAnnotationCall != null) {
            FirAnnotationCall firAnnotationCall2 = firAnnotationCall;
            boolean bl2 = false;
            boolean bl3 = false;
            FirAnnotationCall it = firAnnotationCall2;
            boolean bl4 = false;
            FirTypeRef firTypeRef = it.getAnnotationTypeRef();
            if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                firTypeRef = null;
            }
            FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
            if (firResolvedTypeRef != null) {
                FirResolvedTypeRef firResolvedTypeRef2 = firResolvedTypeRef;
                boolean bl5 = false;
                boolean bl6 = false;
                FirResolvedTypeRef it2 = firResolvedTypeRef2;
                boolean bl7 = false;
                ConeKotlinType coneKotlinType = it2.getType();
                if (!(coneKotlinType instanceof ConeClassLikeType)) {
                    coneKotlinType = null;
                }
                ConeClassLikeType coneClassLikeType = (ConeClassLikeType)coneKotlinType;
                if (coneClassLikeType != null) {
                    ConeClassLikeType coneClassLikeType2 = coneClassLikeType;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    ConeClassLikeType it3 = coneClassLikeType2;
                    boolean bl10 = false;
                    bl = Intrinsics.areEqual((Object)it3.getLookupTag().getClassId().asString(), (Object)EXTENSION_FUNCTION_ANNOTATION);
                } else {
                    bl = null;
                }
            } else {
                bl = null;
            }
        } else {
            bl = null;
        }
        return Intrinsics.areEqual(bl, (Object)true);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirAnnotationCall> dropExtensionFunctionAnnotation(@NotNull List<? extends FirAnnotationCall> $this$dropExtensionFunctionAnnotation) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkParameterIsNotNull($this$dropExtensionFunctionAnnotation, (String)"$this$dropExtensionFunctionAnnotation");
        Iterable $this$filterNot$iv = $this$dropExtensionFunctionAnnotation;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            FirAnnotationCall it = (FirAnnotationCall)element$iv$iv;
            boolean bl = false;
            if (FirTypeUtilsKt.isExtensionFunctionAnnotationCall(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final FirConstKind<?> toConstKind(@NotNull ConeClassLikeType $this$toConstKind) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toConstKind, (String)"$this$toConstKind");
        ClassId classId = $this$toConstKind.getLookupTag().getClassId();
        return Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getByte()) ? (FirConstKind)FirConstKind.Byte.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getShort()) ? (FirConstKind)FirConstKind.Short.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getInt()) ? (FirConstKind)FirConstKind.Int.INSTANCE : (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getLong()) ? (FirConstKind)FirConstKind.Long.INSTANCE : null)));
    }
}

