/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class JvmPackageName {
    private static final char DELIMITER = '.';
    private static final Splitter PACKAGE_FRAGMENT_SPLITTER = Splitter.on((char)'.');
    private static final String UNNAMED_PACKAGE = "";
    private static final Set<String> INVALID_PACKAGE_KEYWORDS = ImmutableSet.of((Object)"abstract", (Object)"assert", (Object)"boolean", (Object)"break", (Object)"byte", (Object)"case", (Object[])new String[]{"catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "_", "true", "false", "null", ""});

    private JvmPackageName() {
    }

    public static boolean isValid(String value) {
        if (UNNAMED_PACKAGE.equals(value)) {
            return true;
        }
        if (value == null) {
            return false;
        }
        return JvmPackageName.fragmentsAreValid(value);
    }

    private static boolean fragmentsAreValid(String value) {
        for (String packageFragment : PACKAGE_FRAGMENT_SPLITTER.split((CharSequence)value)) {
            if (JvmPackageName.isIdentifier(packageFragment)) continue;
            return false;
        }
        return true;
    }

    private static boolean isIdentifier(String token) {
        return !INVALID_PACKAGE_KEYWORDS.contains(token) && JvmPackageName.isValidJavaIdentifier(token);
    }

    private static boolean isValidJavaIdentifier(String token) {
        if (!Character.isJavaIdentifierStart(token.charAt(0))) {
            return false;
        }
        for (int i = 1; i < token.length(); ++i) {
            if (Character.isJavaIdentifierPart(token.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

