/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.ConfigurableNormalizer;
import org.gradle.api.internal.changedetection.state.ResourceEntryFilter;
import org.gradle.api.internal.changedetection.state.ZipEntryContext;
import org.gradle.api.internal.changedetection.state.ZipEntryHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;

public class ManifestFileZipEntryHasher
implements ZipEntryHasher,
ConfigurableNormalizer {
    private final ResourceEntryFilter attributeResourceFilter;

    public ManifestFileZipEntryHasher(ResourceEntryFilter attributeResourceFilter) {
        this.attributeResourceFilter = attributeResourceFilter;
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        this.attributeResourceFilter.appendConfigurationToHasher(hasher);
    }

    @Override
    @Nullable
    public HashCode hash(ZipEntryContext zipEntryContext) throws IOException {
        return this.hashManifest(ByteStreams.toByteArray((InputStream)zipEntryContext.getEntry().getInputStream()));
    }

    private HashCode hashManifest(byte[] entryBytes) throws IOException {
        Manifest manifest = new Manifest(new ByteArrayInputStream(entryBytes));
        Hasher hasher = Hashing.newHasher();
        Attributes mainAttributes = manifest.getMainAttributes();
        this.hashManifestAttributes(mainAttributes, "main", hasher);
        Map<String, Attributes> entries = manifest.getEntries();
        TreeSet<String> names = new TreeSet<String>(manifest.getEntries().keySet());
        for (String name : names) {
            this.hashManifestAttributes(entries.get(name), name, hasher);
        }
        return hasher.hash();
    }

    private void hashManifestAttributes(Attributes attributes, String name, Hasher hasher) {
        Map<String, String> entries = attributes.entrySet().stream().collect(Collectors.toMap(entry -> entry.getKey().toString().toLowerCase(Locale.ROOT), entry -> (String)entry.getValue()));
        List normalizedEntries = entries.entrySet().stream().filter(entry -> !this.attributeResourceFilter.shouldBeIgnored((String)entry.getKey())).sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
        if (!normalizedEntries.isEmpty()) {
            hasher.putString((CharSequence)name);
            for (Map.Entry entry2 : normalizedEntries) {
                hasher.putString((CharSequence)entry2.getKey());
                hasher.putString((CharSequence)entry2.getValue());
            }
        }
    }
}

