/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.pico;

import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.FList;
import org.jetbrains.kotlin.com.intellij.util.pico.AssignableToComponentAdapter;
import org.jetbrains.kotlin.com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import org.jetbrains.kotlin.org.picocontainer.ComponentAdapter;
import org.jetbrains.kotlin.org.picocontainer.MutablePicoContainer;
import org.jetbrains.kotlin.org.picocontainer.Parameter;
import org.jetbrains.kotlin.org.picocontainer.PicoContainer;
import org.jetbrains.kotlin.org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.jetbrains.kotlin.org.picocontainer.defaults.DefaultLifecycleStrategy;
import org.jetbrains.kotlin.org.picocontainer.defaults.DelegatingComponentMonitor;
import org.jetbrains.kotlin.org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;
import org.jetbrains.kotlin.org.picocontainer.defaults.InstanceComponentAdapter;

public class DefaultPicoContainer
implements MutablePicoContainer {
    public static final DelegatingComponentMonitor DEFAULT_DELEGATING_COMPONENT_MONITOR = new DelegatingComponentMonitor();
    public static final DefaultLifecycleStrategy DEFAULT_LIFECYCLE_STRATEGY = new DefaultLifecycleStrategy(DEFAULT_DELEGATING_COMPONENT_MONITOR);
    private final PicoContainer parent;
    private final Set<PicoContainer> children = new THashSet();
    private final Map<Object, ComponentAdapter> componentKeyToAdapterCache = ContainerUtil.newConcurrentMap();
    private final LinkedHashSetWrapper<ComponentAdapter> componentAdapters = new LinkedHashSetWrapper();
    private final Map<String, ComponentAdapter> classNameToAdapter = ContainerUtil.newConcurrentMap();
    private final AtomicReference<FList<ComponentAdapter>> nonAssignableComponentAdapters = new AtomicReference(FList.emptyList());

    public DefaultPicoContainer(@Nullable PicoContainer parent2) {
        this.parent = parent2;
    }

    @Override
    public Collection<ComponentAdapter> getComponentAdapters() {
        return this.componentAdapters.getImmutableSet();
    }

    private void appendNonAssignableAdaptersOfType(@NotNull Class<?> componentType, @NotNull List<? super ComponentAdapter> result2) {
        if (componentType == null) {
            DefaultPicoContainer.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            DefaultPicoContainer.$$$reportNull$$$0(1);
        }
        ArrayList<ComponentAdapter> comp2 = new ArrayList<ComponentAdapter>();
        for (ComponentAdapter componentAdapter : this.nonAssignableComponentAdapters.get()) {
            if (!ReflectionUtil.isAssignable(componentType, componentAdapter.getComponentImplementation())) continue;
            comp2.add(componentAdapter);
        }
        for (int i = comp2.size() - 1; i >= 0; --i) {
            result2.add((ComponentAdapter)comp2.get(i));
        }
    }

    @Override
    @Nullable
    public final ComponentAdapter getComponentAdapter(Object componentKey) {
        ComponentAdapter adapter = this.getFromCache(componentKey);
        if (adapter == null && this.parent != null) {
            return this.parent.getComponentAdapter(componentKey);
        }
        return adapter;
    }

    @Nullable
    private ComponentAdapter getFromCache(Object componentKey) {
        ComponentAdapter adapter = this.componentKeyToAdapterCache.get(componentKey);
        if (adapter != null) {
            return adapter;
        }
        if (componentKey instanceof Class) {
            return this.componentKeyToAdapterCache.get(((Class)componentKey).getName());
        }
        return null;
    }

    @Override
    @Nullable
    public ComponentAdapter getComponentAdapterOfType(@NotNull Class componentType) {
        ComponentAdapter adapterByKey;
        if (componentType == null) {
            DefaultPicoContainer.$$$reportNull$$$0(2);
        }
        if ((adapterByKey = this.getComponentAdapter(componentType)) != null) {
            return adapterByKey;
        }
        List<ComponentAdapter> found2 = this.getComponentAdaptersOfType(componentType);
        if (found2.size() == 1) {
            return found2.get(0);
        }
        if (found2.isEmpty()) {
            return this.parent == null ? null : this.parent.getComponentAdapterOfType(componentType);
        }
        Object[] foundClasses = new Class[found2.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            foundClasses[i] = found2.get(i).getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(componentType, foundClasses);
    }

    @Override
    public List<ComponentAdapter> getComponentAdaptersOfType(@Nullable Class componentType) {
        if (componentType == null || componentType == String.class) {
            return Collections.emptyList();
        }
        SmartList<ComponentAdapter> result2 = new SmartList<ComponentAdapter>();
        ComponentAdapter cacheHit = this.classNameToAdapter.get(componentType.getName());
        if (cacheHit != null) {
            result2.add(cacheHit);
        }
        this.appendNonAssignableAdaptersOfType(componentType, result2);
        return result2;
    }

    public ComponentAdapter registerComponent(@NotNull ComponentAdapter componentAdapter) {
        Object componentKey;
        if (componentAdapter == null) {
            DefaultPicoContainer.$$$reportNull$$$0(3);
        }
        if (this.componentKeyToAdapterCache.containsKey(componentKey = componentAdapter.getComponentKey())) {
            throw new DuplicateComponentKeyRegistrationException(componentKey);
        }
        if (componentAdapter instanceof AssignableToComponentAdapter) {
            String classKey = ((AssignableToComponentAdapter)componentAdapter).getAssignableToClassName();
            this.classNameToAdapter.put(classKey, componentAdapter);
        } else {
            FList<ComponentAdapter> newList;
            FList<ComponentAdapter> oldList;
            while (!this.nonAssignableComponentAdapters.compareAndSet(oldList = this.nonAssignableComponentAdapters.get(), newList = oldList.prepend(componentAdapter))) {
            }
        }
        this.componentAdapters.add(componentAdapter);
        this.componentKeyToAdapterCache.put(componentKey, componentAdapter);
        return componentAdapter;
    }

    @Override
    @Nullable
    public ComponentAdapter unregisterComponent(@NotNull Object componentKey) {
        ComponentAdapter adapter;
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(4);
        }
        if ((adapter = this.componentKeyToAdapterCache.remove(componentKey)) == null) {
            return null;
        }
        this.componentAdapters.remove(adapter);
        if (adapter instanceof AssignableToComponentAdapter) {
            this.classNameToAdapter.remove(((AssignableToComponentAdapter)adapter).getAssignableToClassName());
        } else {
            FList<ComponentAdapter> newList;
            FList<ComponentAdapter> oldList;
            while (!this.nonAssignableComponentAdapters.compareAndSet(oldList = this.nonAssignableComponentAdapters.get(), newList = oldList.without(adapter))) {
            }
        }
        return adapter;
    }

    @Override
    @Nullable
    public Object getComponentInstance(Object componentKey) {
        ComponentAdapter adapter = this.getFromCache(componentKey);
        if (adapter != null) {
            return adapter.getComponentInstance(this);
        }
        if (this.parent != null && (adapter = this.parent.getComponentAdapter(componentKey)) != null) {
            return this.parent.getComponentInstance(adapter.getComponentKey());
        }
        return null;
    }

    @Nullable
    public <T> T getService(@NotNull Class<T> serviceClass) {
        ComponentAdapter adapter;
        if (serviceClass == null) {
            DefaultPicoContainer.$$$reportNull$$$0(5);
        }
        if ((adapter = this.componentKeyToAdapterCache.get(serviceClass.getName())) == null) {
            return null;
        }
        return (T)adapter.getComponentInstance(this);
    }

    @Override
    public void start() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stop() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dispose() {
        throw new UnsupportedOperationException();
    }

    public ComponentAdapter registerComponentInstance(@NotNull Object component) {
        if (component == null) {
            DefaultPicoContainer.$$$reportNull$$$0(12);
        }
        return this.registerComponentInstance(component.getClass(), component);
    }

    @Override
    public ComponentAdapter registerComponentInstance(@NotNull Object componentKey, @NotNull Object componentInstance) {
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(13);
        }
        if (componentInstance == null) {
            DefaultPicoContainer.$$$reportNull$$$0(14);
        }
        return this.registerComponent(new InstanceComponentAdapter(componentKey, componentInstance, DEFAULT_LIFECYCLE_STRATEGY));
    }

    @Override
    public ComponentAdapter registerComponentImplementation(@NotNull Object componentKey, @NotNull Class componentImplementation) {
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(16);
        }
        if (componentImplementation == null) {
            DefaultPicoContainer.$$$reportNull$$$0(17);
        }
        return this.registerComponentImplementation(componentKey, componentImplementation, null);
    }

    public ComponentAdapter registerComponentImplementation(@NotNull Object componentKey, @NotNull Class componentImplementation, Parameter[] parameters2) {
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(18);
        }
        if (componentImplementation == null) {
            DefaultPicoContainer.$$$reportNull$$$0(19);
        }
        CachingConstructorInjectionComponentAdapter componentAdapter = new CachingConstructorInjectionComponentAdapter(componentKey, componentImplementation, parameters2, true);
        return this.registerComponent(componentAdapter);
    }

    @Override
    public PicoContainer getParent() {
        return this.parent;
    }

    public String toString() {
        return "DefaultPicoContainer" + (this.getParent() == null ? " (root)" : " (parent=" + this.getParent() + ")");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentAdapter";
                break;
            }
            case 4: 
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentKey";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentInstance";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/pico/DefaultPicoContainer";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentImplementation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/pico/DefaultPicoContainer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "makeChildContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendNonAssignableAdaptersOfType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getComponentAdapterOfType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerComponent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unregisterComponent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getServiceAdapter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "unregisterComponentByInstance";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addChildContainer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeChildContainer";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerComponentInstance";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "registerComponentImplementation";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class LinkedHashSetWrapper<T> {
        private final Object lock = new Object();
        private volatile Set<T> immutableSet;
        private LinkedHashSet<T> synchronizedSet = new LinkedHashSet();

        private LinkedHashSetWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(@NotNull T element) {
            if (element == null) {
                LinkedHashSetWrapper.$$$reportNull$$$0(0);
            }
            Object object = this.lock;
            synchronized (object) {
                if (!this.synchronizedSet.contains(element)) {
                    this.copySyncSetIfExposedAsImmutable().add(element);
                }
            }
        }

        private LinkedHashSet<T> copySyncSetIfExposedAsImmutable() {
            if (this.immutableSet != null) {
                this.immutableSet = null;
                this.synchronizedSet = new LinkedHashSet<T>(this.synchronizedSet);
            }
            return this.synchronizedSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(@Nullable T element) {
            Object object = this.lock;
            synchronized (object) {
                this.copySyncSetIfExposedAsImmutable().remove(element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Set<T> getImmutableSet() {
            Set<T> res2 = this.immutableSet;
            if (res2 == null) {
                Object object = this.lock;
                synchronized (object) {
                    res2 = this.immutableSet;
                    if (res2 == null) {
                        this.immutableSet = res2 = Collections.unmodifiableSet(this.synchronizedSet);
                    }
                }
            }
            Set<T> set = res2;
            if (set == null) {
                LinkedHashSetWrapper.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/pico/DefaultPicoContainer$LinkedHashSetWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/pico/DefaultPicoContainer$LinkedHashSetWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImmutableSet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

