/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import java.util.Optional;
import javax.inject.Inject;
import org.gradle.api.internal.file.FileFactory;
import org.gradle.jvm.toolchain.internal.JavaCompilerFactory;
import org.gradle.jvm.toolchain.internal.JavaInstallationProbe;
import org.gradle.jvm.toolchain.internal.JavaToolchain;
import org.gradle.jvm.toolchain.internal.ToolchainToolFactory;

public class JavaToolchainFactory {
    private final JavaInstallationProbe probeService;
    private final JavaCompilerFactory compilerFactory;
    private final ToolchainToolFactory toolFactory;
    private final FileFactory fileFactory;

    @Inject
    public JavaToolchainFactory(JavaInstallationProbe probeService, JavaCompilerFactory compilerFactory, ToolchainToolFactory toolFactory, FileFactory fileFactory) {
        this.probeService = probeService;
        this.compilerFactory = compilerFactory;
        this.toolFactory = toolFactory;
        this.fileFactory = fileFactory;
    }

    public Optional<JavaToolchain> newInstance(File javaHome) {
        JavaInstallationProbe.ProbeResult probeResult = this.probeService.checkJdk(javaHome);
        JavaInstallationProbe.InstallType type = probeResult.getInstallType();
        if (type == JavaInstallationProbe.InstallType.IS_JRE || type == JavaInstallationProbe.InstallType.IS_JDK) {
            JavaToolchain toolchain = new JavaToolchain(probeResult, this.compilerFactory, this.toolFactory, this.fileFactory);
            return Optional.of(toolchain);
        }
        return Optional.empty();
    }
}

