/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.io.File;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshot;
import org.gradle.api.internal.tasks.compile.incremental.classpath.DefaultClasspathEntrySnapshotter;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysis;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviousCompilationOutputAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(PreviousCompilationOutputAnalyzer.class);
    private final DefaultClasspathEntrySnapshotter snapshotter;

    public PreviousCompilationOutputAnalyzer(FileHasher fileHasher, StreamHasher streamHasher, ClassDependenciesAnalyzer analyzer, FileOperations fileOperations) {
        this.snapshotter = new DefaultClasspathEntrySnapshotter(fileHasher, streamHasher, analyzer, fileOperations);
    }

    public ClassSetAnalysis getAnalysis(File classesDirectory) {
        Timer clock = Time.startTimer();
        HashCode unusedHashCode = HashCode.fromInt((int)0);
        ClasspathEntrySnapshot snapshot = this.snapshotter.createSnapshot(unusedHashCode, classesDirectory);
        LOG.info("Class dependency analysis for incremental compilation took {}.", (Object)clock.getElapsed());
        return snapshot.getClassAnalysis();
    }
}

