/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import com.google.common.base.Optional;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.Category;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.LocalConfigurationMetadataBuilder;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.VirtualComponentIdentifier;
import org.gradle.internal.component.local.model.BuildableLocalComponentMetadata;
import org.gradle.internal.component.local.model.BuildableLocalConfigurationMetadata;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalComponentMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.local.model.MissingLocalArtifactMetadata;
import org.gradle.internal.component.local.model.PublishArtifactLocalArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DefaultVariantMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.ImmutableModuleSources;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.VariantResolveMetadata;

public class DefaultLocalComponentMetadata
implements LocalComponentMetadata,
BuildableLocalComponentMetadata {
    private final Map<String, DefaultLocalConfigurationMetadata> allConfigurations = Maps.newLinkedHashMap();
    private final Multimap<String, LocalComponentArtifactMetadata> allArtifacts = ArrayListMultimap.create();
    private final SetMultimap<String, DefaultVariantMetadata> allVariants = LinkedHashMultimap.create();
    private final ComponentIdentifier componentId;
    private final ModuleVersionIdentifier moduleVersionId;
    private final String status;
    private final AttributesSchemaInternal attributesSchema;
    private final ModuleSources moduleSources = ImmutableModuleSources.of();
    private Optional<ImmutableList<? extends ConfigurationMetadata>> consumableConfigurations;

    public DefaultLocalComponentMetadata(ModuleVersionIdentifier moduleVersionId, ComponentIdentifier componentId, String status, AttributesSchemaInternal attributesSchema) {
        this.moduleVersionId = moduleVersionId;
        this.componentId = componentId;
        this.status = status;
        this.attributesSchema = attributesSchema;
    }

    @Override
    public ComponentIdentifier getId() {
        return this.componentId;
    }

    @Override
    public ModuleVersionIdentifier getModuleVersionId() {
        return this.moduleVersionId;
    }

    public DefaultLocalComponentMetadata copy(ComponentIdentifier componentIdentifier, Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> artifacts) {
        DefaultLocalComponentMetadata copy = new DefaultLocalComponentMetadata(this.moduleVersionId, componentIdentifier, this.status, this.attributesSchema);
        for (DefaultLocalConfigurationMetadata configuration : this.allConfigurations.values()) {
            copy.addConfiguration(configuration.getName(), configuration.description, configuration.extendsFrom, (ImmutableSet<String>)configuration.hierarchy, configuration.visible, configuration.transitive, configuration.attributes, configuration.canBeConsumed, configuration.consumptionAlternatives, configuration.canBeResolved, configuration.capabilities, Collections::emptyList);
        }
        HashMap<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> transformedArtifacts = new HashMap<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata>();
        for (Map.Entry entry : this.allArtifacts.entries()) {
            LocalComponentArtifactMetadata oldArtifact = (LocalComponentArtifactMetadata)entry.getValue();
            LocalComponentArtifactMetadata newArtifact = this.copyArtifact(oldArtifact, artifacts, transformedArtifacts);
            copy.allArtifacts.put((Object)((String)entry.getKey()), (Object)newArtifact);
        }
        for (Map.Entry entry : this.allVariants.entries()) {
            DefaultVariantMetadata oldVariant = (DefaultVariantMetadata)entry.getValue();
            ImmutableList.Builder newArtifacts = new ImmutableList.Builder();
            for (ComponentArtifactMetadata oldArtifact : oldVariant.getArtifacts()) {
                newArtifacts.add((Object)this.copyArtifact((LocalComponentArtifactMetadata)oldArtifact, artifacts, transformedArtifacts));
            }
            copy.allVariants.put((Object)((String)entry.getKey()), (Object)new DefaultVariantMetadata(oldVariant.getName(), oldVariant.getIdentifier(), oldVariant.asDescribable(), oldVariant.getAttributes(), (ImmutableList<? extends ComponentArtifactMetadata>)newArtifacts.build(), oldVariant.getCapabilities()));
        }
        for (DefaultLocalConfigurationMetadata configuration : this.allConfigurations.values()) {
            configuration.realizeDependencies();
            DefaultLocalConfigurationMetadata configurationCopy = copy.allConfigurations.get(configuration.getName());
            configurationCopy.definedDependencies.addAll(configuration.definedDependencies);
            configurationCopy.definedFiles.addAll(configuration.definedFiles);
            configurationCopy.definedExcludes.addAll(configuration.definedExcludes);
        }
        return copy;
    }

    private LocalComponentArtifactMetadata copyArtifact(LocalComponentArtifactMetadata oldArtifact, Transformer<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> transformer, Map<LocalComponentArtifactMetadata, LocalComponentArtifactMetadata> transformedArtifacts) {
        LocalComponentArtifactMetadata newArtifact = transformedArtifacts.get(oldArtifact);
        if (newArtifact == null) {
            newArtifact = (LocalComponentArtifactMetadata)transformer.transform((Object)oldArtifact);
            transformedArtifacts.put(oldArtifact, newArtifact);
        }
        return newArtifact;
    }

    @Override
    public void addArtifacts(String configuration, Collection<? extends PublishArtifact> artifacts) {
        for (PublishArtifact publishArtifact : artifacts) {
            PublishArtifactLocalArtifactMetadata artifactMetadata = new PublishArtifactLocalArtifactMetadata(this.componentId, publishArtifact);
            this.allArtifacts.put((Object)configuration, (Object)artifactMetadata);
        }
    }

    @Override
    public void addVariant(String configuration, String name, VariantResolveMetadata.Identifier identifier, DisplayName displayName, ImmutableAttributes attributes, Collection<? extends PublishArtifact> publishArtifacts) {
        ImmutableList artifacts;
        if (publishArtifacts.isEmpty()) {
            artifacts = ImmutableList.of();
        } else {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (PublishArtifact publishArtifact : publishArtifacts) {
                builder.add((Object)new PublishArtifactLocalArtifactMetadata(this.componentId, publishArtifact));
            }
            artifacts = builder.build();
        }
        this.allVariants.put((Object)configuration, (Object)new DefaultVariantMetadata(name, identifier, displayName, (AttributeContainerInternal)attributes, (ImmutableList<? extends ComponentArtifactMetadata>)artifacts, null));
    }

    @Override
    public BuildableLocalConfigurationMetadata addConfiguration(String name, String description, Set<String> extendsFrom, ImmutableSet<String> hierarchy, boolean visible, boolean transitive, ImmutableAttributes attributes, boolean canBeConsumed, List<String> consumptionAlternatives, boolean canBeResolved, ImmutableCapabilities capabilities, Supplier<List<DependencyConstraint>> consistentResolutionConstraints) {
        assert (hierarchy.contains((Object)name));
        DefaultLocalConfigurationMetadata conf = new DefaultLocalConfigurationMetadata(name, description, visible, transitive, extendsFrom, hierarchy, attributes, canBeConsumed, consumptionAlternatives, canBeResolved, capabilities);
        this.addToConfigurations(name, conf);
        return conf;
    }

    protected void addToConfigurations(String name, DefaultLocalConfigurationMetadata conf) {
        this.allConfigurations.put(name, conf);
    }

    @Override
    public void addDependenciesAndExcludesForConfiguration(ConfigurationInternal configuration, LocalConfigurationMetadataBuilder localConfigurationMetadataBuilder) {
        DefaultLocalConfigurationMetadata configurationMetadata = this.allConfigurations.get(configuration.getName());
        configurationMetadata.configurationMetadataBuilder = localConfigurationMetadataBuilder;
        configurationMetadata.backingConfiguration = configuration;
    }

    public String toString() {
        return this.componentId.getDisplayName();
    }

    @Override
    public ModuleSources getSources() {
        return this.moduleSources;
    }

    @Override
    public ComponentResolveMetadata withSources(ModuleSources source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMissing() {
        return false;
    }

    @Override
    public boolean isChanging() {
        return false;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public List<String> getStatusScheme() {
        return DEFAULT_STATUS_SCHEME;
    }

    @Override
    public ImmutableList<? extends VirtualComponentIdentifier> getPlatformOwners() {
        return ImmutableList.of();
    }

    @Override
    public Set<String> getConfigurationNames() {
        return this.allConfigurations.keySet();
    }

    @Override
    public synchronized Optional<ImmutableList<? extends ConfigurationMetadata>> getVariantsForGraphTraversal() {
        if (this.consumableConfigurations == null) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            boolean hasAtLeastOneConsumableConfiguration = false;
            for (DefaultLocalConfigurationMetadata configuration : this.allConfigurations.values()) {
                if (!configuration.isCanBeConsumed() || configuration.getAttributes().isEmpty()) continue;
                hasAtLeastOneConsumableConfiguration = true;
                builder.add((Object)configuration);
            }
            this.consumableConfigurations = hasAtLeastOneConsumableConfiguration ? Optional.of((Object)builder.build()) : Optional.absent();
        }
        return this.consumableConfigurations;
    }

    @Override
    public DefaultLocalConfigurationMetadata getConfiguration(String name) {
        return this.allConfigurations.get(name);
    }

    @Override
    public AttributesSchemaInternal getAttributesSchema() {
        return this.attributesSchema;
    }

    @Override
    public ImmutableAttributes getAttributes() {
        return ImmutableAttributes.EMPTY;
    }

    protected class DefaultLocalConfigurationMetadata
    implements LocalConfigurationMetadata,
    BuildableLocalConfigurationMetadata {
        private final String name;
        private final String description;
        private final boolean transitive;
        private final boolean visible;
        private final ImmutableSet<String> hierarchy;
        private final Set<String> extendsFrom;
        private final ImmutableAttributes attributes;
        private final boolean canBeConsumed;
        private final List<String> consumptionAlternatives;
        private final boolean canBeResolved;
        private final ImmutableCapabilities capabilities;
        private ConfigurationInternal backingConfiguration;
        private LocalConfigurationMetadataBuilder configurationMetadataBuilder;
        private final List<LocalOriginDependencyMetadata> definedDependencies = Lists.newArrayList();
        private final List<ExcludeMetadata> definedExcludes = Lists.newArrayList();
        private final List<LocalFileDependencyMetadata> definedFiles = Lists.newArrayList();
        private ImmutableList<LocalOriginDependencyMetadata> configurationDependencies;
        private ImmutableSet<LocalFileDependencyMetadata> configurationFileDependencies;
        private ImmutableList<ExcludeMetadata> configurationExcludes;
        private ImmutableList<LocalComponentArtifactMetadata> configurationArtifacts;

        protected DefaultLocalConfigurationMetadata(String name, String description, boolean visible, boolean transitive, Set<String> extendsFrom, ImmutableSet<String> hierarchy, ImmutableAttributes attributes, boolean canBeConsumed, List<String> consumptionAlternatives, boolean canBeResolved, ImmutableCapabilities capabilities) {
            this.name = name;
            this.description = description;
            this.transitive = transitive;
            this.visible = visible;
            this.hierarchy = hierarchy;
            this.extendsFrom = extendsFrom;
            this.attributes = attributes;
            this.canBeConsumed = canBeConsumed;
            this.consumptionAlternatives = consumptionAlternatives;
            this.canBeResolved = canBeResolved;
            this.capabilities = capabilities;
        }

        @Override
        public ComponentIdentifier getComponentId() {
            return DefaultLocalComponentMetadata.this.componentId;
        }

        @Override
        public void addDependency(LocalOriginDependencyMetadata dependency) {
            this.definedDependencies.add(dependency);
        }

        @Override
        public void addExclude(ExcludeMetadata exclude) {
            this.definedExcludes.add(exclude);
        }

        @Override
        public void addFiles(LocalFileDependencyMetadata files) {
            this.definedFiles.add(files);
        }

        @Override
        public void enableLocking() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.asDescribable().getDisplayName();
        }

        @Override
        public DisplayName asDescribable() {
            return Describables.of((Object)DefaultLocalComponentMetadata.this.componentId, (Object)"configuration", (Object)this.name);
        }

        public ComponentResolveMetadata getComponent() {
            return DefaultLocalComponentMetadata.this;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Set<String> getExtendsFrom() {
            return this.extendsFrom;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ImmutableSet<String> getHierarchy() {
            return this.hierarchy;
        }

        @Override
        public boolean isTransitive() {
            return this.transitive;
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.attributes;
        }

        @Override
        public Set<? extends VariantResolveMetadata> getVariants() {
            return DefaultLocalComponentMetadata.this.allVariants.get((Object)this.name);
        }

        @Override
        public boolean isCanBeConsumed() {
            return this.canBeConsumed;
        }

        @Override
        public List<String> getConsumptionAlternatives() {
            return this.consumptionAlternatives;
        }

        @Override
        public boolean isCanBeResolved() {
            return this.canBeResolved;
        }

        @Override
        public List<? extends LocalOriginDependencyMetadata> getDependencies() {
            if (this.configurationDependencies == null) {
                ImmutableList.Builder result = ImmutableList.builder();
                for (DefaultLocalConfigurationMetadata configuration : DefaultLocalComponentMetadata.this.allConfigurations.values()) {
                    if (!this.include(configuration)) continue;
                    configuration.addDefinedDependencies((ImmutableList.Builder<LocalOriginDependencyMetadata>)result);
                }
                AttributeValue attributeValue = this.getAttributes().findEntry(Category.CATEGORY_ATTRIBUTE);
                if (attributeValue.isPresent() && ((Category)attributeValue.get()).getName().equals("enforced-platform")) {
                    ImmutableList rawDependencies = result.build();
                    result = ImmutableList.builder();
                    for (LocalOriginDependencyMetadata rawDependency : rawDependencies) {
                        result.add((Object)rawDependency.forced());
                    }
                }
                this.configurationDependencies = result.build();
            }
            return this.configurationDependencies;
        }

        List<LocalOriginDependencyMetadata> getSyntheticDependencies() {
            return Collections.emptyList();
        }

        void addDefinedDependencies(ImmutableList.Builder<LocalOriginDependencyMetadata> result) {
            this.realizeDependencies();
            result.addAll(this.definedDependencies);
        }

        @Override
        public Set<LocalFileDependencyMetadata> getFiles() {
            if (this.configurationFileDependencies == null) {
                ImmutableSet.Builder result = ImmutableSet.builder();
                for (DefaultLocalConfigurationMetadata configuration : DefaultLocalComponentMetadata.this.allConfigurations.values()) {
                    if (!this.include(configuration)) continue;
                    configuration.addDefinedFiles((ImmutableSet.Builder<LocalFileDependencyMetadata>)result);
                }
                this.configurationFileDependencies = result.build();
            }
            return this.configurationFileDependencies;
        }

        void addDefinedFiles(ImmutableSet.Builder<LocalFileDependencyMetadata> result) {
            this.realizeDependencies();
            result.addAll(this.definedFiles);
        }

        @Override
        public ImmutableList<ExcludeMetadata> getExcludes() {
            if (this.configurationExcludes == null) {
                ImmutableList.Builder result = ImmutableList.builder();
                for (DefaultLocalConfigurationMetadata configuration : DefaultLocalComponentMetadata.this.allConfigurations.values()) {
                    if (!this.include(configuration)) continue;
                    configuration.addDefinedExcludes((ImmutableList.Builder<ExcludeMetadata>)result);
                }
                this.configurationExcludes = result.build();
            }
            return this.configurationExcludes;
        }

        void addDefinedExcludes(ImmutableList.Builder<ExcludeMetadata> result) {
            this.realizeDependencies();
            result.addAll(this.definedExcludes);
        }

        @Override
        public ImmutableList<? extends LocalComponentArtifactMetadata> getArtifacts() {
            if (this.configurationArtifacts == null) {
                if (DefaultLocalComponentMetadata.this.allArtifacts.isEmpty()) {
                    this.configurationArtifacts = ImmutableList.of();
                } else {
                    ImmutableList.Builder result = ImmutableList.builder();
                    for (String config : this.hierarchy) {
                        result.addAll((Iterable)DefaultLocalComponentMetadata.this.allArtifacts.get((Object)config));
                    }
                    this.configurationArtifacts = result.build();
                }
            }
            return this.configurationArtifacts;
        }

        @Override
        public ComponentArtifactMetadata artifact(IvyArtifactName ivyArtifactName) {
            for (ComponentArtifactMetadata candidate : this.getArtifacts()) {
                if (!candidate.getName().equals(ivyArtifactName)) continue;
                return candidate;
            }
            return new MissingLocalArtifactMetadata(DefaultLocalComponentMetadata.this.componentId, ivyArtifactName);
        }

        @Override
        public CapabilitiesMetadata getCapabilities() {
            return this.capabilities;
        }

        @Override
        public boolean requiresMavenArtifactDiscovery() {
            return false;
        }

        @Override
        public boolean isExternalVariant() {
            return false;
        }

        private boolean include(DefaultLocalConfigurationMetadata configuration) {
            return this.hierarchy.contains((Object)configuration.getName());
        }

        synchronized void realizeDependencies() {
            if (this.backingConfiguration != null) {
                this.backingConfiguration.runDependencyActions();
                this.configurationMetadataBuilder.addDependenciesAndExcludes(this, this.backingConfiguration);
                this.backingConfiguration = null;
            }
        }
    }
}

