/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.JsToStringGenerationVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.FunctionWithWrapper;
import org.jetbrains.kotlin.js.inline.util.collectors.InstanceCollector;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000z\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0002\u001a \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u001a\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0001\u001a\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u0010\u001a,\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0003\"\b\b\u0000\u0010\u0017*\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u00192\u0006\u0010\u000f\u001a\u00020\u0010\u001a \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u001a\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u000f\u001a\u00020\u0010\u001a \u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001d0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u001a\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001d0\t2\u0006\u0010\u000f\u001a\u00020\u0010\u001a&\u0010\u001e\u001a\u001a\u0012\u0004\u0012\u00020\u0013\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\u001f0\t2\u0006\u0010\u000f\u001a\u00020\u0010\u001a \u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003\u001a\u001a\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0010\u0010$\u001a\u0004\u0018\u00010\u000b2\u0006\u0010%\u001a\u00020\u0004\u001a\u0010\u0010&\u001a\u0004\u0018\u00010\n2\u0006\u0010'\u001a\u00020(\u001a\u001c\u0010)\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u0002\u001a\u0010\u0010*\u001a\u0004\u0018\u00010\n2\u0006\u0010+\u001a\u00020,\u001a\u0016\u0010-\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0\t*\u00020\u0010\u001a\u0010\u00100\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\u001d\u001a\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\u001d2\b\b\u0002\u0010\u0014\u001a\u00020\u0001\u00a8\u00062"}, d2={"appendArguments", "", "arguments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "collectAccessors", "", "", "Lorg/jetbrains/kotlin/js/inline/util/FunctionWithWrapper;", "fragments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsProgramFragment;", "scope", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "collectDefinedNames", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "skipLabelsAndCatches", "collectDefinedNamesInAllScopes", "collectInstances", "T", "klass", "Ljava/lang/Class;", "collectLocalFunctions", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "collectNamedFunctions", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "collectNamedFunctionsAndMetadata", "Lkotlin/Pair;", "collectNamedFunctionsAndWrappers", "collectNamedFunctionsOrMetadata", "collectReferencedNames", "collectUsedNames", "extractFunction", "expression", "extractImportTag", "jsVar", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars$JsVar;", "extractImportTagImpl", "getImportTag", "jsVars", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "collectBreakContinueTargets", "Lorg/jetbrains/kotlin/js/backend/ast/JsContinue;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "collectFreeVariables", "collectLocalVariables", "js.translator"})
public final class CollectUtilsKt {
    @NotNull
    public static final Set<JsName> collectReferencedNames(@NotNull JsNode scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        boolean bl = false;
        Set references = new LinkedHashSet();
        new RecursiveJsVisitor(references){
            final /* synthetic */ Set $references;

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsExpression initializer2 = x.getInitExpression();
                if (initializer2 != null) {
                    this.accept((JsNode)initializer2);
                }
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
                super.visitNameRef(nameRef);
                JsName name = nameRef.getName();
                if (name != null) {
                    Collection collection = this.$references;
                    boolean bl = false;
                    collection.add(name);
                }
            }
            {
                this.$references = $captured_local_variable$0;
            }
        }.accept(scope2);
        return references;
    }

    @NotNull
    public static final Set<JsName> collectUsedNames(@NotNull JsNode scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        boolean bl = false;
        Set references = new LinkedHashSet();
        new RecursiveJsVisitor(references){
            final /* synthetic */ Set $references;

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsExpression initializer2 = x.getInitExpression();
                if (initializer2 != null) {
                    this.accept((JsNode)initializer2);
                }
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
                super.visitNameRef(nameRef);
                JsName name = nameRef.getName();
                if (name != null && nameRef.getQualifier() == null) {
                    this.$references.add(name);
                }
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Collection collection = this.$references;
                Iterable iterable = CollectUtilsKt.collectFreeVariables(x);
                boolean bl = false;
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
            }
            {
                this.$references = $captured_local_variable$0;
            }
        }.accept(scope2);
        return references;
    }

    @NotNull
    public static final Set<JsName> collectDefinedNames(@NotNull JsNode scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        return CollectUtilsKt.collectDefinedNames(scope2, false);
    }

    @NotNull
    public static final Set<JsName> collectDefinedNames(@NotNull JsNode scope2, boolean skipLabelsAndCatches) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        boolean bl = false;
        Set names2 = new LinkedHashSet();
        new RecursiveJsVisitor(names2, skipLabelsAndCatches){
            final /* synthetic */ Set $names;
            final /* synthetic */ boolean $skipLabelsAndCatches;

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsExpression initializer2 = x.getInitExpression();
                if (initializer2 != null) {
                    this.accept((JsNode)initializer2);
                }
                Collection collection = this.$names;
                JsName jsName = x.getName();
                boolean bl = false;
                collection.add(jsName);
            }

            public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
                JsName name;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"x.expression");
                JsExpression expression2 = jsExpression;
                if (expression2 instanceof JsFunction && (name = ((JsFunction)expression2).getName()) != null) {
                    Collection collection = this.$names;
                    boolean bl = false;
                    collection.add(name);
                }
                super.visitExpressionStatement(x);
            }

            public void visitLabel(@NotNull JsLabel x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                if (!this.$skipLabelsAndCatches) {
                    JsName jsName = x.getName();
                    if (jsName != null) {
                        JsName jsName2 = jsName;
                        boolean bl = false;
                        boolean bl2 = false;
                        JsName it = jsName2;
                        boolean bl3 = false;
                        Collection collection = this.$names;
                        boolean bl4 = false;
                        collection.add(it);
                    }
                }
                super.visitLabel(x);
            }

            public void visitCatch(@NotNull JsCatch x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                if (!this.$skipLabelsAndCatches) {
                    Collection collection = this.$names;
                    JsParameter jsParameter = x.getParameter();
                    Intrinsics.checkNotNullExpressionValue((Object)jsParameter, (String)"x.parameter");
                    JsName jsName = jsParameter.getName();
                    boolean bl = false;
                    collection.add(jsName);
                }
                super.visitCatch(x);
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }
            {
                this.$names = $captured_local_variable$0;
                this.$skipLabelsAndCatches = $captured_local_variable$1;
            }
        }.accept(scope2);
        return names2;
    }

    @NotNull
    public static final Set<JsName> collectDefinedNamesInAllScopes(@NotNull JsNode scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        boolean bl = false;
        Set names2 = new LinkedHashSet();
        new RecursiveJsVisitor(names2){
            final /* synthetic */ Set $names;

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                super.visit(x);
                Collection collection = this.$names;
                JsName jsName = x.getName();
                boolean bl = false;
                collection.add(jsName);
            }

            /*
             * WARNING - void declaration
             */
            public void visitFunction(@NotNull JsFunction x) {
                block1: {
                    void $this$mapTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                    super.visitFunction(x);
                    Object object = this.$names;
                    List<JsParameter> list2 = x.getParameters();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"x.parameters");
                    Iterable $this$map$iv = list2;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        JsName jsName;
                        void it;
                        JsParameter jsParameter = (JsParameter)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        void v1 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                        Intrinsics.checkNotNullExpressionValue((Object)v1.getName(), (String)"it.name");
                        collection.add(jsName);
                    }
                    Iterable iterable2 = (List)destination$iv$iv;
                    boolean bl = false;
                    CollectionsKt.addAll((Collection)object, (Iterable)iterable2);
                    JsName jsName = x.getName();
                    if (jsName == null) break block1;
                    object = jsName;
                    boolean bl2 = false;
                    bl = false;
                    Object it = object;
                    boolean bl3 = false;
                    Collection collection = this.$names;
                    boolean bl4 = false;
                    collection.add(it);
                }
            }

            public void visitLabel(@NotNull JsLabel x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsName jsName = x.getName();
                if (jsName != null) {
                    JsName jsName2 = jsName;
                    boolean bl = false;
                    boolean bl2 = false;
                    JsName it = jsName2;
                    boolean bl3 = false;
                    Collection collection = this.$names;
                    boolean bl4 = false;
                    collection.add(it);
                }
                super.visitLabel(x);
            }

            public void visitCatch(@NotNull JsCatch x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Collection collection = this.$names;
                JsParameter jsParameter = x.getParameter();
                Intrinsics.checkNotNullExpressionValue((Object)jsParameter, (String)"x.parameter");
                JsName jsName = jsParameter.getName();
                boolean bl = false;
                collection.add(jsName);
                super.visitCatch(x);
            }
            {
                this.$names = $captured_local_variable$0;
            }
        }.accept(scope2);
        return names2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<JsName> collectFreeVariables(@NotNull JsFunction $this$collectFreeVariables) {
        Collection<JsName> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$collectFreeVariables, (String)"$this$collectFreeVariables");
        JsBlock jsBlock = $this$collectFreeVariables.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"body");
        Set<JsName> set = CollectUtilsKt.collectUsedNames(jsBlock);
        JsBlock jsBlock2 = $this$collectFreeVariables.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock2, (String)"body");
        Set set2 = SetsKt.minus(set, (Iterable)CollectUtilsKt.collectDefinedNames(jsBlock2));
        List<JsParameter> list2 = $this$collectFreeVariables.getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"parameters");
        Iterable iterable = list2;
        Set set3 = set2;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JsName jsName;
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v5 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"it");
            Intrinsics.checkNotNullExpressionValue((Object)v5.getName(), (String)"it.name");
            collection.add(jsName);
        }
        collection = (List)destination$iv$iv;
        return SetsKt.minus((Set)set3, (Iterable)collection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<JsName> collectLocalVariables(@NotNull JsFunction $this$collectLocalVariables, boolean skipLabelsAndCatches) {
        Collection<JsName> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$collectLocalVariables, (String)"$this$collectLocalVariables");
        JsBlock jsBlock = $this$collectLocalVariables.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"body");
        Set<JsName> set = CollectUtilsKt.collectDefinedNames(jsBlock, skipLabelsAndCatches);
        List<JsParameter> list2 = $this$collectLocalVariables.getParameters();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"parameters");
        Iterable iterable = list2;
        Set<JsName> set2 = set;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            JsName jsName;
            void it;
            JsParameter jsParameter = (JsParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
            Intrinsics.checkNotNullExpressionValue((Object)v3.getName(), (String)"it.name");
            collection.add(jsName);
        }
        collection = (List)destination$iv$iv;
        return SetsKt.plus(set2, (Iterable)collection);
    }

    public static /* synthetic */ Set collectLocalVariables$default(JsFunction jsFunction, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return CollectUtilsKt.collectLocalVariables(jsFunction, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<JsName, JsFunction> collectNamedFunctions(@NotNull JsNode scope2) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Map<JsName, Pair<FunctionWithWrapper, JsExpression>> $this$mapValues$iv = CollectUtilsKt.collectNamedFunctionsAndMetadata(scope2);
        boolean $i$f$mapValues = false;
        Map<JsName, Pair<FunctionWithWrapper, JsExpression>> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map4 = map3;
            boolean bl2 = false;
            JsFunction jsFunction = ((FunctionWithWrapper)((Pair)it.getValue()).getFirst()).getFunction();
            map4.put(k2, jsFunction);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<JsName, JsExpression> collectNamedFunctionsOrMetadata(@NotNull JsNode scope2) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Map<JsName, Pair<FunctionWithWrapper, JsExpression>> $this$mapValues$iv = CollectUtilsKt.collectNamedFunctionsAndMetadata(scope2);
        boolean $i$f$mapValues = false;
        Map<JsName, Pair<FunctionWithWrapper, JsExpression>> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map4 = map3;
            boolean bl2 = false;
            JsExpression jsExpression = (JsExpression)((Pair)it.getValue()).getSecond();
            map4.put(k2, jsExpression);
        }
        return destination$iv$iv;
    }

    @NotNull
    public static final Map<JsName, JsFunction> collectNamedFunctions(@NotNull List<JsProgramFragment> fragments2) {
        Intrinsics.checkNotNullParameter(fragments2, (String)"fragments");
        boolean bl = false;
        Map result2 = new LinkedHashMap();
        for (JsProgramFragment fragment : fragments2) {
            Map map2 = result2;
            Map<JsName, JsFunction> map3 = CollectUtilsKt.collectNamedFunctions(fragment.getDeclarationBlock());
            boolean bl2 = false;
            map2.putAll(map3);
            map2 = result2;
            map3 = CollectUtilsKt.collectNamedFunctions(fragment.getInitializerBlock());
            bl2 = false;
            map2.putAll(map3);
        }
        return result2;
    }

    @NotNull
    public static final Map<JsName, FunctionWithWrapper> collectNamedFunctionsAndWrappers(@NotNull List<JsProgramFragment> fragments2) {
        Intrinsics.checkNotNullParameter(fragments2, (String)"fragments");
        boolean bl = false;
        Map result2 = new LinkedHashMap();
        for (JsProgramFragment fragment : fragments2) {
            FunctionWithWrapper functionWithWrapper;
            Map.Entry it;
            Map map2;
            Object k;
            Object k2;
            Map.Entry it$iv$iv;
            boolean bl2;
            Map map3;
            Map $this$mapValuesTo$iv$iv;
            Map map4 = result2;
            Map $this$mapValues$iv = CollectUtilsKt.collectNamedFunctionsAndMetadata(fragment.getDeclarationBlock());
            boolean $i$f$mapValues = false;
            Map map5 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                map3 = destination$iv$iv;
                bl2 = false;
                k2 = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                k = k2;
                map2 = map3;
                boolean bl3 = false;
                functionWithWrapper = (FunctionWithWrapper)((Pair)it.getValue()).getFirst();
                map2.put(k, functionWithWrapper);
            }
            $this$mapValues$iv = destination$iv$iv;
            $i$f$mapValues = false;
            map4.putAll($this$mapValues$iv);
            map4 = result2;
            $this$mapValues$iv = CollectUtilsKt.collectNamedFunctionsAndMetadata(fragment.getInitializerBlock());
            $i$f$mapValues = false;
            $this$mapValuesTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            $i$f$mapValuesTo = false;
            $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                it$iv$iv = (Map.Entry)element$iv$iv$iv;
                map3 = destination$iv$iv;
                bl2 = false;
                k2 = it$iv$iv.getKey();
                it = (Map.Entry)element$iv$iv$iv;
                k = k2;
                map2 = map3;
                boolean bl4 = false;
                functionWithWrapper = (FunctionWithWrapper)((Pair)it.getValue()).getFirst();
                map2.put(k, functionWithWrapper);
            }
            Map map6 = destination$iv$iv;
            boolean bl5 = false;
            map4.putAll(map6);
        }
        return result2;
    }

    @NotNull
    public static final Map<JsName, Pair<FunctionWithWrapper, JsExpression>> collectNamedFunctionsAndMetadata(@NotNull JsNode scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        boolean bl = false;
        Map namedFunctions = new LinkedHashMap();
        scope2.accept(new RecursiveJsVisitor(namedFunctions){
            final /* synthetic */ Map $namedFunctions;

            /*
             * WARNING - void declaration
             */
            public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Pair<JsExpression, JsExpression> assignment = JsAstUtils.decomposeAssignment(x);
                if (assignment != null) {
                    JsName name;
                    void left;
                    Pair<JsExpression, JsExpression> pair = assignment;
                    JsExpression jsExpression = (JsExpression)pair.component1();
                    JsExpression right = (JsExpression)pair.component2();
                    if (left instanceof JsNameRef && (name = ((JsNameRef)left).getName()) != null) {
                        JsExpression jsExpression2 = right;
                        Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"right");
                        FunctionWithWrapper functionWithWrapper = CollectUtilsKt.extractFunction(jsExpression2);
                        if (functionWithWrapper != null) {
                            void function2;
                            FunctionWithWrapper functionWithWrapper2 = functionWithWrapper;
                            boolean bl = false;
                            boolean bl2 = false;
                            FunctionWithWrapper $dstr$function$wrapper = functionWithWrapper2;
                            boolean bl3 = false;
                            JsFunction jsFunction = $dstr$function$wrapper.component1();
                            JsBlock wrapper = $dstr$function$wrapper.component2();
                            this.$namedFunctions.put(name, new Pair((Object)new FunctionWithWrapper((JsFunction)function2, wrapper), (Object)right));
                        }
                    }
                }
                super.visitBinaryExpression(x);
            }

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsExpression initializer2 = x.getInitExpression();
                JsName name = x.getName();
                if (initializer2 != null && name != null) {
                    FunctionWithWrapper functionWithWrapper = CollectUtilsKt.extractFunction(initializer2);
                    if (functionWithWrapper != null) {
                        FunctionWithWrapper functionWithWrapper2 = functionWithWrapper;
                        boolean bl = false;
                        boolean bl2 = false;
                        FunctionWithWrapper function2 = functionWithWrapper2;
                        boolean bl3 = false;
                        this.$namedFunctions.put(name, new Pair((Object)function2, (Object)initializer2));
                    }
                }
                super.visit(x);
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsName name = x.getName();
                if (name != null) {
                    this.$namedFunctions.put(name, new Pair((Object)new FunctionWithWrapper(x, null), (Object)x));
                }
                super.visitFunction(x);
            }
            {
                this.$namedFunctions = $captured_local_variable$0;
            }
        });
        return namedFunctions;
    }

    @NotNull
    public static final Map<String, FunctionWithWrapper> collectAccessors(@NotNull JsNode scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        boolean bl = false;
        HashMap accessors = new HashMap();
        scope2.accept(new RecursiveJsVisitor(accessors){
            final /* synthetic */ HashMap $accessors;

            public void visitInvocation(@NotNull JsInvocation invocation) {
                Intrinsics.checkNotNullParameter((Object)invocation, (String)"invocation");
                InlineMetadata inlineMetadata = InlineMetadata.Companion.decompose(invocation);
                if (inlineMetadata != null) {
                    InlineMetadata inlineMetadata2 = inlineMetadata;
                    boolean bl = false;
                    boolean bl2 = false;
                    InlineMetadata it = inlineMetadata2;
                    boolean bl3 = false;
                    Map map2 = this.$accessors;
                    String string2 = it.getTag().getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.tag.value");
                    map2.put(string2, it.getFunction());
                }
                super.visitInvocation(invocation);
            }
            {
                this.$accessors = $captured_local_variable$0;
            }
        });
        return accessors;
    }

    @NotNull
    public static final Map<String, FunctionWithWrapper> collectAccessors(@NotNull Iterable<JsProgramFragment> fragments2) {
        Intrinsics.checkNotNullParameter(fragments2, (String)"fragments");
        boolean bl = false;
        Map result2 = new LinkedHashMap();
        for (JsProgramFragment fragment : fragments2) {
            Map map2 = result2;
            Map<String, FunctionWithWrapper> map3 = CollectUtilsKt.collectAccessors(fragment.getDeclarationBlock());
            boolean bl2 = false;
            map2.putAll(map3);
        }
        return result2;
    }

    @NotNull
    public static final Map<CallableDescriptor, FunctionWithWrapper> collectLocalFunctions(@NotNull JsNode scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        boolean bl = false;
        HashMap localFunctions = new HashMap();
        scope2.accept(new RecursiveJsVisitor(localFunctions){
            final /* synthetic */ HashMap $localFunctions;

            public void visitInvocation(@NotNull JsInvocation invocation) {
                Intrinsics.checkNotNullParameter((Object)invocation, (String)"invocation");
                FunctionWithWrapper functionWithWrapper = InlineMetadata.Companion.tryExtractFunction(invocation);
                if (functionWithWrapper != null) {
                    FunctionWithWrapper functionWithWrapper2 = functionWithWrapper;
                    boolean bl = false;
                    boolean bl2 = false;
                    FunctionWithWrapper it = functionWithWrapper2;
                    boolean bl3 = false;
                    FunctionDescriptor functionDescriptor = MetadataProperties.getFunctionDescriptor(it.getFunction());
                    if (functionDescriptor != null) {
                        FunctionDescriptor functionDescriptor2 = functionDescriptor;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        FunctionDescriptor fd = functionDescriptor2;
                        boolean bl6 = false;
                        ((Map)this.$localFunctions).put(fd, it);
                    }
                }
                super.visitInvocation(invocation);
            }
            {
                this.$localFunctions = $captured_local_variable$0;
            }
        });
        return localFunctions;
    }

    @NotNull
    public static final Map<CallableDescriptor, FunctionWithWrapper> collectLocalFunctions(@NotNull List<JsProgramFragment> fragments2) {
        Intrinsics.checkNotNullParameter(fragments2, (String)"fragments");
        boolean bl = false;
        Map result2 = new LinkedHashMap();
        for (JsProgramFragment fragment : fragments2) {
            Map map2 = result2;
            Map<CallableDescriptor, FunctionWithWrapper> map3 = CollectUtilsKt.collectLocalFunctions(fragment.getDeclarationBlock());
            boolean bl2 = false;
            map2.putAll(map3);
        }
        return result2;
    }

    @Nullable
    public static final FunctionWithWrapper extractFunction(@NotNull JsExpression expression2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        JsExpression jsExpression = expression2;
        if (jsExpression instanceof JsFunction) {
            object = new FunctionWithWrapper((JsFunction)expression2, null);
        } else {
            object = InlineMetadata.Companion.decompose(expression2);
            if (object == null || (object = ((InlineMetadata)object).getFunction()) == null) {
                object = InlineMetadata.Companion.tryExtractFunction(expression2);
            }
        }
        return object;
    }

    @NotNull
    public static final <T extends JsNode> List<T> collectInstances(@NotNull Class<T> klass, @NotNull JsNode scope2) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        InstanceCollector<JsNode> instanceCollector = new InstanceCollector<JsNode>(klass, false);
        boolean bl = false;
        boolean bl2 = false;
        InstanceCollector<JsNode> $this$with = instanceCollector;
        boolean bl3 = false;
        $this$with.accept(scope2);
        return $this$with.getCollected();
    }

    @NotNull
    public static final Map<JsContinue, JsStatement> collectBreakContinueTargets(@NotNull JsNode $this$collectBreakContinueTargets) {
        Intrinsics.checkNotNullParameter((Object)$this$collectBreakContinueTargets, (String)"$this$collectBreakContinueTargets");
        boolean bl = false;
        Map targets = new LinkedHashMap();
        $this$collectBreakContinueTargets.accept(new RecursiveJsVisitor(targets){
            private JsStatement defaultBreakTarget;
            private Map<JsName, JsStatement> breakTargets;
            private JsStatement defaultContinueTarget;
            private Map<JsName, JsStatement> continueTargets;
            final /* synthetic */ Map $targets;

            @Nullable
            public final JsStatement getDefaultBreakTarget() {
                return this.defaultBreakTarget;
            }

            public final void setDefaultBreakTarget(@Nullable JsStatement jsStatement) {
                this.defaultBreakTarget = jsStatement;
            }

            @NotNull
            public final Map<JsName, JsStatement> getBreakTargets() {
                return this.breakTargets;
            }

            public final void setBreakTargets(@NotNull Map<JsName, JsStatement> map2) {
                Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
                this.breakTargets = map2;
            }

            @Nullable
            public final JsStatement getDefaultContinueTarget() {
                return this.defaultContinueTarget;
            }

            public final void setDefaultContinueTarget(@Nullable JsStatement jsStatement) {
                this.defaultContinueTarget = jsStatement;
            }

            @NotNull
            public final Map<JsName, JsStatement> getContinueTargets() {
                return this.continueTargets;
            }

            public final void setContinueTargets(@NotNull Map<JsName, JsStatement> map2) {
                Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
                this.continueTargets = map2;
            }

            public void visitLabel(@NotNull JsLabel x) {
                JsStatement inner;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsStatement jsStatement = inner = x.getStatement();
                if (jsStatement instanceof JsDoWhile) {
                    JsStatement jsStatement2 = ((JsDoWhile)inner).getBody();
                    Intrinsics.checkNotNullExpressionValue((Object)jsStatement2, (String)"inner.body");
                    this.handleLoop(inner, jsStatement2, x.getName());
                } else if (jsStatement instanceof JsWhile) {
                    JsStatement jsStatement3 = ((JsWhile)inner).getBody();
                    Intrinsics.checkNotNullExpressionValue((Object)jsStatement3, (String)"inner.body");
                    this.handleLoop(inner, jsStatement3, x.getName());
                } else if (jsStatement instanceof JsFor) {
                    JsStatement jsStatement4 = ((JsFor)inner).getBody();
                    Intrinsics.checkNotNullExpressionValue((Object)jsStatement4, (String)"inner.body");
                    this.handleLoop(inner, jsStatement4, x.getName());
                } else if (jsStatement instanceof JsSwitch) {
                    this.handleSwitch((JsSwitch)inner, x.getName());
                } else {
                    JsName jsName = x.getName();
                    JsStatement jsStatement5 = x.getStatement();
                    Intrinsics.checkNotNullExpressionValue((Object)jsStatement5, (String)"x.statement");
                    this.withBreakAndContinue(jsName, jsStatement5, null, (Function0<Unit>)((Function0)new Function0<Unit>(this, inner){
                        final /* synthetic */ collectBreakContinueTargets.1 this$0;
                        final /* synthetic */ JsStatement $inner;

                        public final void invoke() {
                            this.this$0.accept((JsNode)this.$inner);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$inner = jsStatement;
                            super(0);
                        }
                    }));
                }
            }

            public void visitWhile(@NotNull JsWhile x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsStatement jsStatement = x;
                JsStatement jsStatement2 = x.getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement2, (String)"x.body");
                this.handleLoop(jsStatement, jsStatement2, null);
            }

            public void visitDoWhile(@NotNull JsDoWhile x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsStatement jsStatement = x;
                JsStatement jsStatement2 = x.getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement2, (String)"x.body");
                this.handleLoop(jsStatement, jsStatement2, null);
            }

            public void visitFor(@NotNull JsFor x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsStatement jsStatement = x;
                JsStatement jsStatement2 = x.getBody();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement2, (String)"x.body");
                this.handleLoop(jsStatement, jsStatement2, null);
            }

            public void visit(@NotNull JsSwitch x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.handleSwitch(x, null);
            }

            private final void handleSwitch(JsSwitch statement2, JsName label) {
                collectBreakContinueTargets.1.withBreakAndContinue$default(this, label, statement2, null, (Function0)new Function0<Unit>(this, statement2){
                    final /* synthetic */ collectBreakContinueTargets.1 this$0;
                    final /* synthetic */ JsSwitch $statement;

                    public final void invoke() {
                        List<JsSwitchMember> list2 = this.$statement.getCases();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"statement.cases");
                        Iterable $this$forEach$iv = list2;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            JsSwitchMember it = (JsSwitchMember)element$iv;
                            boolean bl = false;
                            this.this$0.accept((JsNode)it);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$statement = jsSwitch;
                        super(0);
                    }
                }, 4, null);
            }

            private final void handleLoop(JsStatement loop2, JsStatement body2, JsName label) {
                this.withBreakAndContinue(label, loop2, loop2, (Function0<Unit>)((Function0)new Function0<Unit>(this, body2){
                    final /* synthetic */ collectBreakContinueTargets.1 this$0;
                    final /* synthetic */ JsStatement $body;

                    public final void invoke() {
                        this.$body.accept(this.this$0);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$body = jsStatement;
                        super(0);
                    }
                }));
            }

            public void visitBreak(@NotNull JsBreak x) {
                JsStatement jsStatement;
                JsName targetLabel;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsNameRef jsNameRef = x.getLabel();
                JsName jsName = targetLabel = jsNameRef != null ? jsNameRef.getName() : null;
                if (targetLabel == null) {
                    JsStatement jsStatement2 = this.defaultBreakTarget;
                    jsStatement = jsStatement2;
                    Intrinsics.checkNotNull((Object)jsStatement2);
                } else {
                    JsStatement jsStatement3 = this.breakTargets.get(targetLabel);
                    Intrinsics.checkNotNull((Object)jsStatement3);
                    jsStatement = jsStatement3;
                }
                this.$targets.put(x, jsStatement);
            }

            public void visitContinue(@NotNull JsContinue x) {
                JsStatement jsStatement;
                JsName targetLabel;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsNameRef jsNameRef = x.getLabel();
                JsName jsName = targetLabel = jsNameRef != null ? jsNameRef.getName() : null;
                if (targetLabel == null) {
                    JsStatement jsStatement2 = this.defaultContinueTarget;
                    jsStatement = jsStatement2;
                    Intrinsics.checkNotNull((Object)jsStatement2);
                } else {
                    JsStatement jsStatement3 = this.continueTargets.get(targetLabel);
                    Intrinsics.checkNotNull((Object)jsStatement3);
                    jsStatement = jsStatement3;
                }
                this.$targets.put(x, jsStatement);
            }

            /*
             * WARNING - void declaration
             */
            private final void withBreakAndContinue(JsName label, JsStatement breakTargetStatement, JsStatement continueTargetStatement, Function0<Unit> action) {
                JsStatement oldDefaultBreakTarget = this.defaultBreakTarget;
                JsStatement oldDefaultContinueTarget = this.defaultContinueTarget;
                Pair pair = label != null ? new Pair((Object)this.breakTargets.get(label), (Object)this.continueTargets.get(label)) : new Pair(null, null);
                JsStatement jsStatement = (JsStatement)pair.component1();
                JsStatement oldContinueTarget = (JsStatement)pair.component2();
                this.defaultBreakTarget = breakTargetStatement;
                if (label != null) {
                    this.breakTargets.put(label, breakTargetStatement);
                    this.continueTargets.put(label, continueTargetStatement);
                }
                if (continueTargetStatement != null) {
                    this.defaultContinueTarget = continueTargetStatement;
                }
                action.invoke();
                this.defaultBreakTarget = oldDefaultBreakTarget;
                this.defaultContinueTarget = oldDefaultContinueTarget;
                if (label != null) {
                    void oldBreakTarget;
                    this.breakTargets.put(label, (JsStatement)oldBreakTarget);
                    this.continueTargets.put(label, oldContinueTarget);
                }
            }

            static /* synthetic */ void withBreakAndContinue$default(collectBreakContinueTargets.1 var0, JsName jsName, JsStatement jsStatement, JsStatement jsStatement2, Function0 function0, int n, Object object) {
                if ((n & 4) != 0) {
                    jsStatement2 = null;
                }
                var0.withBreakAndContinue(jsName, jsStatement, jsStatement2, (Function0<Unit>)function0);
            }
            {
                this.$targets = $captured_local_variable$0;
                boolean bl = false;
                this.breakTargets = new LinkedHashMap<K, V>();
                bl = false;
                this.continueTargets = new LinkedHashMap<K, V>();
            }
        });
        return targets;
    }

    @Nullable
    public static final String getImportTag(@NotNull JsVars jsVars) {
        Intrinsics.checkNotNullParameter((Object)jsVars, (String)"jsVars");
        if (jsVars.getVars().size() == 1) {
            JsVars.JsVar jsVar;
            JsVars.JsVar jsVar2 = jsVar = jsVars.getVars().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)jsVar2, (String)"jsVar");
            JsName jsName = jsVar2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"jsVar.name");
            if (MetadataProperties.getImported(jsName)) {
                return CollectUtilsKt.extractImportTag(jsVar);
            }
        }
        return null;
    }

    @Nullable
    public static final String extractImportTag(@NotNull JsVars.JsVar jsVar) {
        Intrinsics.checkNotNullParameter((Object)jsVar, (String)"jsVar");
        JsExpression jsExpression = jsVar.getInitExpression();
        if (jsExpression == null) {
            return null;
        }
        JsExpression initExpression = jsExpression;
        StringBuilder sb = new StringBuilder();
        if (initExpression instanceof JsInvocation || initExpression instanceof JsNew) {
            sb.append(jsVar.getName().toString()).append(":");
        }
        return CollectUtilsKt.extractImportTagImpl(initExpression, sb) ? sb.toString() : null;
    }

    private static final boolean extractImportTagImpl(JsExpression expression2, StringBuilder sb) {
        JsExpression jsExpression = expression2;
        if (jsExpression instanceof JsNameRef) {
            JsExpression nameRef = expression2;
            if (((JsNameRef)nameRef).getQualifier() != null) {
                JsExpression jsExpression2 = ((JsNameRef)nameRef).getQualifier();
                Intrinsics.checkNotNull((Object)jsExpression2);
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"nameRef.qualifier!!");
                if (!CollectUtilsKt.extractImportTagImpl(jsExpression2, sb)) {
                    return false;
                }
                sb.append('.');
            }
            sb.append(JsToStringGenerationVisitor.javaScriptString(((JsNameRef)nameRef).getIdent()));
            return true;
        }
        if (jsExpression instanceof JsArrayAccess) {
            JsExpression arrayAccess = expression2;
            JsExpression jsExpression3 = ((JsArrayAccess)arrayAccess).getArrayExpression();
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression3, (String)"arrayAccess.arrayExpression");
            if (!CollectUtilsKt.extractImportTagImpl(jsExpression3, sb)) {
                return false;
            }
            sb.append(".");
            JsExpression jsExpression4 = ((JsArrayAccess)arrayAccess).getIndexExpression();
            if (!(jsExpression4 instanceof JsStringLiteral)) {
                jsExpression4 = null;
            }
            JsStringLiteral jsStringLiteral = (JsStringLiteral)jsExpression4;
            if (jsStringLiteral == null) {
                return false;
            }
            JsStringLiteral stringLiteral = jsStringLiteral;
            sb.append(JsToStringGenerationVisitor.javaScriptString(stringLiteral.getValue()));
            return true;
        }
        if (jsExpression instanceof JsInvocation) {
            JsExpression invocation = expression2;
            JsExpression jsExpression5 = ((JsInvocation)invocation).getQualifier();
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression5, (String)"invocation.qualifier");
            if (!CollectUtilsKt.extractImportTagImpl(jsExpression5, sb)) {
                return false;
            }
            List<JsExpression> list2 = ((JsInvocation)invocation).getArguments();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"invocation.arguments");
            return CollectUtilsKt.appendArguments(list2, sb);
        }
        if (jsExpression instanceof JsNew) {
            JsExpression newExpr = expression2;
            JsExpression jsExpression6 = ((JsNew)newExpr).getConstructorExpression();
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression6, (String)"newExpr.constructorExpression");
            if (!CollectUtilsKt.extractImportTagImpl(jsExpression6, sb)) {
                return false;
            }
            List<JsExpression> list3 = ((JsNew)newExpr).getArguments();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"newExpr.arguments");
            return CollectUtilsKt.appendArguments(list3, sb);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean appendArguments(List<? extends JsExpression> arguments2, StringBuilder sb) {
        Iterable $this$forEachIndexed$iv = arguments2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void arg;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            JsExpression jsExpression = (JsExpression)item$iv;
            int index2 = n;
            boolean bl2 = false;
            if (!(arg instanceof JsIntLiteral)) {
                return false;
            }
            sb.append(index2 == 0 ? "(" : ",");
            sb.append(((JsIntLiteral)arg).value);
        }
        sb.append(")");
        return true;
    }
}

