/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts;

import groovy.lang.Closure;
import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.PathValidation;
import org.gradle.api.Script;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.FileTree;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.ProcessOperations;
import org.gradle.api.internal.file.DefaultFileOperations;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.HasScriptServices;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.model.InstantiatorBackedObjectFactory;
import org.gradle.api.internal.plugins.DefaultObjectConfigurationAction;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.LoggingManager;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.resources.ResourceHandler;
import org.gradle.api.tasks.WorkResult;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.BasicScript;
import org.gradle.internal.Actions;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resource.TextUriResourceLoader;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.internal.ExecFactory;
import org.gradle.util.ConfigureUtil;

public abstract class DefaultScript
extends BasicScript {
    private static final Logger LOGGER = Logging.getLogger(Script.class);
    private FileOperations fileOperations;
    private ProcessOperations processOperations;
    private ProviderFactory providerFactory;
    private LoggingManager loggingManager;
    public ServiceRegistry __scriptServices;

    @Override
    public void init(Object target, ServiceRegistry services) {
        super.init(target, services);
        this.__scriptServices = services;
        this.loggingManager = (LoggingManager)services.get(LoggingManager.class);
        if (target instanceof HasScriptServices) {
            HasScriptServices scriptServices = (HasScriptServices)target;
            this.fileOperations = scriptServices.getFileOperations();
            this.processOperations = scriptServices.getProcessOperations();
        } else {
            Instantiator instantiator = (Instantiator)services.get(Instantiator.class);
            FileLookup fileLookup = (FileLookup)services.get(FileLookup.class);
            FileCollectionFactory fileCollectionFactory = (FileCollectionFactory)services.get(FileCollectionFactory.class);
            File sourceFile = this.getScriptSource().getResource().getLocation().getFile();
            if (sourceFile != null) {
                FileResolver resolver = fileLookup.getFileResolver(sourceFile.getParentFile());
                FileCollectionFactory fileCollectionFactoryWithBase = fileCollectionFactory.withResolver((PathToFileResolver)resolver);
                this.fileOperations = DefaultFileOperations.createSimple(resolver, fileCollectionFactoryWithBase, services);
                this.processOperations = ((ExecFactory)services.get(ExecFactory.class)).forContext(resolver, fileCollectionFactoryWithBase, instantiator, new InstantiatorBackedObjectFactory(instantiator));
            } else {
                this.fileOperations = DefaultFileOperations.createSimple(fileLookup.getFileResolver(), fileCollectionFactory, services);
                this.processOperations = (ProcessOperations)services.get(ExecFactory.class);
            }
        }
        this.providerFactory = (ProviderFactory)services.get(ProviderFactory.class);
    }

    public FileResolver getFileResolver() {
        return this.fileOperations.getFileResolver();
    }

    private DefaultObjectConfigurationAction createObjectConfigurationAction() {
        ClassLoaderScope classLoaderScope = (ClassLoaderScope)this.__scriptServices.get(ClassLoaderScope.class);
        return new DefaultObjectConfigurationAction(this.getFileResolver(), (ScriptPluginFactory)this.__scriptServices.get(ScriptPluginFactory.class), (ScriptHandlerFactory)this.__scriptServices.get(ScriptHandlerFactory.class), classLoaderScope, (TextUriResourceLoader.Factory)this.__scriptServices.get(TextUriResourceLoader.Factory.class), this.getScriptTarget());
    }

    public void apply(Closure closure) {
        DefaultObjectConfigurationAction action = this.createObjectConfigurationAction();
        ConfigureUtil.configure((Closure)closure, (Object)action);
        action.execute();
    }

    public void apply(Map options) {
        DefaultObjectConfigurationAction action = this.createObjectConfigurationAction();
        ConfigureUtil.configureByMap((Map)options, (Object)action);
        action.execute();
    }

    public ScriptHandler getBuildscript() {
        return (ScriptHandler)this.__scriptServices.get(ScriptHandler.class);
    }

    public void buildscript(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getBuildscript());
    }

    public File file(Object path) {
        return this.fileOperations.file(path);
    }

    public File file(Object path, PathValidation validation) {
        return this.fileOperations.file(path, validation);
    }

    public URI uri(Object path) {
        return this.fileOperations.uri(path);
    }

    public ConfigurableFileCollection files(Object ... paths) {
        return this.fileOperations.configurableFiles(paths);
    }

    public ConfigurableFileCollection files(Object paths, Closure configureClosure) {
        return (ConfigurableFileCollection)ConfigureUtil.configure((Closure)configureClosure, (Object)this.files(paths));
    }

    public String relativePath(Object path) {
        return this.fileOperations.relativePath(path);
    }

    public ConfigurableFileTree fileTree(Object baseDir) {
        return this.fileOperations.fileTree(baseDir);
    }

    public ConfigurableFileTree fileTree(Map<String, ?> args) {
        return this.fileOperations.fileTree(args);
    }

    public ConfigurableFileTree fileTree(Object baseDir, Closure configureClosure) {
        return (ConfigurableFileTree)ConfigureUtil.configure((Closure)configureClosure, (Object)this.fileOperations.fileTree(baseDir));
    }

    public FileTree zipTree(Object zipPath) {
        return this.fileOperations.zipTree(zipPath);
    }

    public FileTree tarTree(Object tarPath) {
        return this.fileOperations.tarTree(tarPath);
    }

    public ResourceHandler getResources() {
        return this.fileOperations.getResources();
    }

    public WorkResult copy(Closure closure) {
        return this.copy((Action<? super CopySpec>)ConfigureUtil.configureUsing((Closure)closure));
    }

    public WorkResult copy(Action<? super CopySpec> action) {
        return this.fileOperations.copy(action);
    }

    public WorkResult sync(Action<? super CopySpec> action) {
        return this.fileOperations.sync(action);
    }

    public CopySpec copySpec(Closure closure) {
        return (CopySpec)Actions.with((Object)this.copySpec(), (Action)ConfigureUtil.configureUsing((Closure)closure));
    }

    public CopySpec copySpec() {
        return this.fileOperations.copySpec();
    }

    public File mkdir(Object path) {
        return this.fileOperations.mkdir(path);
    }

    public boolean delete(Object ... paths) {
        return this.fileOperations.delete(paths);
    }

    public WorkResult delete(Action<? super DeleteSpec> action) {
        return this.fileOperations.delete(action);
    }

    public ExecResult javaexec(Closure closure) {
        return this.processOperations.javaexec((Action<? super JavaExecSpec>)ConfigureUtil.configureUsing((Closure)closure));
    }

    public ExecResult javaexec(Action<? super JavaExecSpec> action) {
        return this.processOperations.javaexec(action);
    }

    public ExecResult exec(Closure closure) {
        return this.processOperations.exec((Action<? super ExecSpec>)ConfigureUtil.configureUsing((Closure)closure));
    }

    public ExecResult exec(Action<? super ExecSpec> action) {
        return this.processOperations.exec(action);
    }

    public <T> Provider<T> provider(Callable<T> value) {
        return this.providerFactory.provider(value);
    }

    public LoggingManager getLogging() {
        return this.loggingManager;
    }

    public Logger getLogger() {
        return LOGGER;
    }

    public String toString() {
        return "script";
    }
}

