/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import com.google.common.collect.Sets;
import java.util.Set;
import org.gradle.internal.build.event.BuildEventSubscriptions;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.internal.protocol.events.InternalOperationFinishedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalOperationStartedProgressEvent;
import org.gradle.tooling.internal.provider.runner.ProgressEventConsumer;

abstract class SubtreeFilteringBuildOperationListener<D>
implements BuildOperationListener {
    protected final ProgressEventConsumer eventConsumer;
    private final BuildOperationListener delegate;
    private final Class<D> detailsClass;
    private final Set<Object> skipEvents = Sets.newConcurrentHashSet();
    private final boolean enabled;

    SubtreeFilteringBuildOperationListener(ProgressEventConsumer eventConsumer, BuildEventSubscriptions clientSubscriptions, BuildOperationListener delegate, OperationType operationType, Class<D> detailsClass) {
        this.eventConsumer = eventConsumer;
        this.delegate = delegate;
        this.detailsClass = detailsClass;
        this.enabled = clientSubscriptions.isRequested(operationType);
    }

    protected boolean isEnabled() {
        return this.enabled;
    }

    public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
        OperationIdentifier parentId = buildOperation.getParentId();
        if (parentId != null && this.skipEvents.contains(parentId)) {
            this.skipEvents.add(buildOperation.getId());
            return;
        }
        if (this.detailsClass.isInstance(buildOperation.getDetails())) {
            if (this.enabled) {
                D details = this.detailsClass.cast(buildOperation.getDetails());
                this.eventConsumer.started(this.toStartedEvent(buildOperation, startEvent, details));
            } else {
                this.skipEvents.add(buildOperation.getId());
            }
        } else {
            this.delegate.started(buildOperation, startEvent);
        }
    }

    public void progress(OperationIdentifier buildOperationId, OperationProgressEvent progressEvent) {
    }

    public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
        if (this.skipEvents.remove(buildOperation.getId())) {
            return;
        }
        if (this.detailsClass.isInstance(buildOperation.getDetails())) {
            D details = this.detailsClass.cast(buildOperation.getDetails());
            this.eventConsumer.finished(this.toFinishedEvent(buildOperation, finishEvent, details));
        } else {
            this.delegate.finished(buildOperation, finishEvent);
        }
    }

    protected abstract InternalOperationStartedProgressEvent toStartedEvent(BuildOperationDescriptor var1, OperationStartEvent var2, D var3);

    protected abstract InternalOperationFinishedProgressEvent toFinishedEvent(BuildOperationDescriptor var1, OperationFinishEvent var2, D var3);
}

