/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.cache.internal.DefaultInMemoryCacheDecoratorFactory;
import org.gradle.cache.internal.InMemoryCacheController;
import org.gradle.cache.internal.MultiProcessSafeAsyncPersistentIndexedCache;

public class CleaningInMemoryCacheDecoratorFactory
extends DefaultInMemoryCacheDecoratorFactory {
    private final List<WeakReference<InMemoryCacheController>> inMemoryCaches = Lists.newArrayList();

    public CleaningInMemoryCacheDecoratorFactory(boolean longLivingProcess, CrossBuildInMemoryCacheFactory cacheFactory) {
        super(longLivingProcess, cacheFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches(Predicate<InMemoryCacheController> predicate) {
        List<WeakReference<InMemoryCacheController>> list = this.inMemoryCaches;
        synchronized (list) {
            Iterator<WeakReference<InMemoryCacheController>> iterator = this.inMemoryCaches.iterator();
            while (iterator.hasNext()) {
                WeakReference<InMemoryCacheController> ref = iterator.next();
                InMemoryCacheController cache = (InMemoryCacheController)ref.get();
                if (cache == null) {
                    iterator.remove();
                    continue;
                }
                if (!predicate.test(cache)) continue;
                cache.clearInMemoryCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <K, V> MultiProcessSafeAsyncPersistentIndexedCache<K, V> applyInMemoryCaching(String cacheId, MultiProcessSafeAsyncPersistentIndexedCache<K, V> backingCache, int maxEntriesToKeepInMemory, boolean cacheInMemoryForShortLivedProcesses) {
        MultiProcessSafeAsyncPersistentIndexedCache<K, V> delegate = super.applyInMemoryCaching(cacheId, backingCache, maxEntriesToKeepInMemory, cacheInMemoryForShortLivedProcesses);
        if (delegate instanceof InMemoryCacheController) {
            InMemoryCacheController cimc = (InMemoryCacheController)((Object)delegate);
            WeakReference<InMemoryCacheController> ref = new WeakReference<InMemoryCacheController>(cimc);
            List<WeakReference<InMemoryCacheController>> list = this.inMemoryCaches;
            synchronized (list) {
                this.inMemoryCaches.add(ref);
            }
        }
        return delegate;
    }
}

