/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.plugins;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginManagerCore;
import org.jetbrains.kotlin.com.intellij.openapi.application.PathManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.impl.ApplicationInfoImpl;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;

public final class DisabledPluginsState {
    private static volatile Set<PluginId> ourDisabledPlugins;
    @Nullable
    private static Runnable disabledPluginListener;

    public static void dontLoadDisabledPlugins() {
        ourDisabledPlugins = Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void loadDisabledPlugins(@NotNull String configPath, @NotNull Collection<PluginId> disabledPlugins) {
        Path file2;
        if (configPath == null) {
            DisabledPluginsState.$$$reportNull$$$0(1);
        }
        if (disabledPlugins == null) {
            DisabledPluginsState.$$$reportNull$$$0(2);
        }
        if (!Files.isRegularFile(file2 = Paths.get(configPath, "disabled_plugins.txt"), new LinkOption[0])) {
            return;
        }
        List<String> requiredPlugins = StringUtil.split(System.getProperty("idea.required.plugins.id", ""), ",");
        try {
            boolean updateDisablePluginsList = false;
            try (BufferedReader reader = Files.newBufferedReader(file2);){
                String id;
                while ((id = reader.readLine()) != null) {
                    if (!requiredPlugins.contains(id = id.trim()) && !ApplicationInfoImpl.getShadowInstance().isEssentialPlugin(id)) {
                        disabledPlugins.add(PluginId.getId(id));
                        continue;
                    }
                    updateDisablePluginsList = true;
                }
            }
            finally {
                if (updateDisablePluginsList) {
                    PluginManagerCore.savePluginsList(disabledPlugins, file2, false);
                    DisabledPluginsState.fireEditDisablePlugins();
                }
            }
        }
        catch (IOException e) {
            DisabledPluginsState.getLogger().info("Unable to load disabled plugins list from " + file2, e);
        }
    }

    @NotNull
    public static Set<PluginId> disabledPlugins() {
        Set<PluginId> set = Collections.unmodifiableSet(DisabledPluginsState.getDisabledIds());
        if (set == null) {
            DisabledPluginsState.$$$reportNull$$$0(3);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static Set<PluginId> getDisabledIds() {
        Set<PluginId> result2 = ourDisabledPlugins;
        if (result2 != null) {
            Set<PluginId> set = result2;
            if (set == null) {
                DisabledPluginsState.$$$reportNull$$$0(4);
            }
            return set;
        }
        if (System.getProperty("idea.ignore.disabled.plugins") != null) {
            Set<PluginId> set = Collections.emptySet();
            if (set == null) {
                DisabledPluginsState.$$$reportNull$$$0(5);
            }
            return set;
        }
        Class<PluginManagerCore> clazz = PluginManagerCore.class;
        synchronized (PluginManagerCore.class) {
            block10: {
                result2 = ourDisabledPlugins;
                if (result2 == null) break block10;
                Set<PluginId> set = result2;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                if (set == null) {
                    DisabledPluginsState.$$$reportNull$$$0(6);
                }
                return set;
            }
            result2 = new LinkedHashSet<PluginId>();
            DisabledPluginsState.loadDisabledPlugins(PathManager.getConfigPath(), result2);
            ourDisabledPlugins = result2;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            Set<PluginId> set = result2;
            if (set == null) {
                DisabledPluginsState.$$$reportNull$$$0(7);
            }
            return set;
        }
    }

    private static void fireEditDisablePlugins() {
        if (disabledPluginListener != null) {
            disabledPluginListener.run();
        }
    }

    @NotNull
    public static Logger getLogger() {
        Logger logger = Logger.getInstance("#com.intellij.ide.plugins.DisabledPluginsState");
        if (logger == null) {
            DisabledPluginsState.$$$reportNull$$$0(16);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configPath";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPlugins";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/ide/plugins/DisabledPluginsState";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/ide/plugins/DisabledPluginsState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "disabledPlugins";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIds";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setDisabledPluginListener";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadDisabledPlugins";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "disablePlugin";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugin";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugins";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "enablePluginsById";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "trySaveDisabledPlugins";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "saveDisabledPlugins";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

