/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.jvm.toolchain.install.internal.JdkCacheDirectory;
import org.gradle.jvm.toolchain.internal.AutoDetectingInstallationSupplier;
import org.gradle.jvm.toolchain.internal.InstallationLocation;

public class AutoInstalledInstallationSupplier
extends AutoDetectingInstallationSupplier {
    private final JdkCacheDirectory cacheDirProvider;
    private final Provider<Boolean> downloadEnabled;

    public AutoInstalledInstallationSupplier(ProviderFactory factory, JdkCacheDirectory cacheDirProvider) {
        super(factory);
        this.cacheDirProvider = cacheDirProvider;
        this.downloadEnabled = factory.gradleProperty("org.gradle.java.installations.auto-download").forUseAtConfigurationTime().map(Boolean::parseBoolean);
    }

    protected Set<InstallationLocation> findCandidates() {
        return this.cacheDirProvider.listJavaHomes().stream().map(this::asInstallation).collect(Collectors.toSet());
    }

    private InstallationLocation asInstallation(File javaHome) {
        return new InstallationLocation(javaHome, "Auto-provisioned by Gradle");
    }

    protected boolean isAutoDetectionEnabled() {
        return super.isAutoDetectionEnabled() || (Boolean)this.downloadEnabled.getOrElse((Object)true) != false;
    }
}

