/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ear.descriptor.internal;

import groovy.lang.Closure;
import groovy.namespace.QName;
import groovy.util.Node;
import groovy.xml.XmlParser;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.XmlProvider;
import org.gradle.api.internal.DomNode;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.IoActions;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ear.descriptor.DeploymentDescriptor;
import org.gradle.plugins.ear.descriptor.EarModule;
import org.gradle.plugins.ear.descriptor.EarSecurityRole;
import org.gradle.plugins.ear.descriptor.EarWebModule;
import org.gradle.plugins.ear.descriptor.internal.DefaultEarModule;
import org.gradle.plugins.ear.descriptor.internal.DefaultEarSecurityRole;
import org.gradle.plugins.ear.descriptor.internal.DefaultEarWebModule;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;

public class DefaultDeploymentDescriptor
implements DeploymentDescriptor {
    private static final String ACCESS_EXTERNAL_DTD = "http://javax.xml.XMLConstants/property/accessExternalDTD";
    private static final String ALLOW_ANY_EXTERNAL_DTD = "all";
    private final XmlTransformer transformer = new XmlTransformer();
    private final PathToFileResolver fileResolver;
    private ObjectFactory objectFactory;
    private String fileName = "application.xml";
    private String version = "6";
    private String applicationName;
    private Boolean initializeInOrder = Boolean.FALSE;
    private String description;
    private String displayName;
    private String libraryDirectory;
    private Set<EarModule> modules = new LinkedHashSet<EarModule>();
    private Set<EarSecurityRole> securityRoles = new LinkedHashSet<EarSecurityRole>();
    private Map<String, String> moduleTypeMappings = new LinkedHashMap<String, String>();

    @Inject
    public DefaultDeploymentDescriptor(PathToFileResolver fileResolver, ObjectFactory objectFactory) {
        this.fileResolver = fileResolver;
        this.objectFactory = objectFactory;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.readFrom(new File("META-INF", fileName));
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Override
    public Boolean getInitializeInOrder() {
        return this.initializeInOrder;
    }

    @Override
    public void setInitializeInOrder(Boolean initializeInOrder) {
        this.initializeInOrder = initializeInOrder;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getLibraryDirectory() {
        return this.libraryDirectory;
    }

    @Override
    public void setLibraryDirectory(String libraryDirectory) {
        this.libraryDirectory = libraryDirectory;
    }

    @Override
    public Set<EarModule> getModules() {
        return this.modules;
    }

    @Override
    public void setModules(Set<EarModule> modules) {
        this.modules = modules;
    }

    @Override
    public Set<EarSecurityRole> getSecurityRoles() {
        return this.securityRoles;
    }

    @Override
    public void setSecurityRoles(Set<EarSecurityRole> securityRoles) {
        this.securityRoles = securityRoles;
    }

    @Override
    public Map<String, String> getModuleTypeMappings() {
        return this.moduleTypeMappings;
    }

    @Override
    public void setModuleTypeMappings(Map<String, String> moduleTypeMappings) {
        this.moduleTypeMappings = moduleTypeMappings;
    }

    @Override
    public DefaultDeploymentDescriptor module(EarModule module, String type) {
        this.modules.add(module);
        this.moduleTypeMappings.put(module.getPath(), type);
        return this;
    }

    @Override
    public DefaultDeploymentDescriptor module(String path, String type) {
        return this.module(new DefaultEarModule(path), type);
    }

    @Override
    public DefaultDeploymentDescriptor webModule(String path, String contextRoot) {
        this.modules.add(new DefaultEarWebModule(path, contextRoot));
        this.moduleTypeMappings.put(path, "web");
        return this;
    }

    @Override
    public DefaultDeploymentDescriptor securityRole(EarSecurityRole role) {
        this.securityRoles.add(role);
        return this;
    }

    @Override
    public DeploymentDescriptor securityRole(String role) {
        this.securityRoles.add(new DefaultEarSecurityRole(role));
        return this;
    }

    @Override
    public DeploymentDescriptor securityRole(Action<? super EarSecurityRole> action) {
        EarSecurityRole role = (EarSecurityRole)this.objectFactory.newInstance(DefaultEarSecurityRole.class, new Object[0]);
        action.execute((Object)role);
        this.securityRoles.add(role);
        return this;
    }

    @Override
    public DeploymentDescriptor withXml(Closure closure) {
        this.transformer.addAction(closure);
        return this;
    }

    @Override
    public DeploymentDescriptor withXml(Action<? super XmlProvider> action) {
        this.transformer.addAction(action);
        return this;
    }

    @Override
    public boolean readFrom(Object path) {
        if (this.fileResolver == null) {
            return false;
        }
        File descriptorFile = this.fileResolver.resolve(path);
        if (descriptorFile == null || !descriptorFile.exists()) {
            return false;
        }
        try {
            FileReader reader = new FileReader(descriptorFile);
            this.readFrom(reader);
            return true;
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private static XmlParser createParser() {
        try {
            XmlParser parser = new XmlParser(false, true, true);
            try {
                parser.setProperty(ACCESS_EXTERNAL_DTD, (Object)ALLOW_ANY_EXTERNAL_DTD);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
            return parser;
        }
        catch (Exception ex) {
            throw UncheckedException.throwAsUncheckedException((Throwable)ex);
        }
    }

    @Override
    public DeploymentDescriptor readFrom(Reader reader) {
        try {
            Node appNode = DefaultDeploymentDescriptor.createParser().parse(reader);
            this.version = (String)appNode.attribute((Object)"version");
            block24: for (final Node child : (List)Cast.uncheckedCast((Object)appNode.children())) {
                String childLocalName;
                switch (childLocalName = DefaultDeploymentDescriptor.localNameOf(child)) {
                    case "application-name": {
                        this.applicationName = child.text();
                        break;
                    }
                    case "initialize-in-order": {
                        this.initializeInOrder = Boolean.valueOf(child.text());
                        break;
                    }
                    case "description": {
                        this.description = child.text();
                        break;
                    }
                    case "display-name": {
                        this.displayName = child.text();
                        break;
                    }
                    case "library-directory": {
                        this.libraryDirectory = child.text();
                        break;
                    }
                    case "module": {
                        EarModule module = null;
                        for (Node moduleNode : (List)Cast.uncheckedCast((Object)child.children())) {
                            String moduleNodeLocalName = DefaultDeploymentDescriptor.localNameOf(moduleNode);
                            if (moduleNodeLocalName.equals("web")) {
                                String webUri = DefaultDeploymentDescriptor.childNodeText(moduleNode, "web-uri");
                                String contextRoot = DefaultDeploymentDescriptor.childNodeText(moduleNode, "context-root");
                                module = new DefaultEarWebModule(webUri, contextRoot);
                                this.modules.add(module);
                                this.moduleTypeMappings.put(module.getPath(), "web");
                                continue;
                            }
                            if (moduleNodeLocalName.equals("alt-dd")) {
                                assert (module != null);
                                module.setAltDeployDescriptor(moduleNode.text());
                                continue;
                            }
                            module = new DefaultEarModule(moduleNode.text());
                            this.modules.add(module);
                            this.moduleTypeMappings.put(module.getPath(), moduleNodeLocalName);
                        }
                        continue block24;
                    }
                    case "security-role": {
                        String roleName = DefaultDeploymentDescriptor.childNodeText(child, "role-name");
                        String description = DefaultDeploymentDescriptor.childNodeText(child, "description");
                        this.securityRoles.add(new DefaultEarSecurityRole(roleName, description));
                        break;
                    }
                    default: {
                        this.withXml((Action<? super XmlProvider>)new Action<XmlProvider>(){

                            public void execute(XmlProvider xmlProvider) {
                                xmlProvider.asNode().append(child);
                            }
                        });
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException((Throwable)ex);
        }
        catch (SAXException ex) {
            throw UncheckedException.throwAsUncheckedException((Throwable)ex);
        }
        finally {
            IoActions.closeQuietly((Closeable)reader);
        }
        return this;
    }

    private static String childNodeText(Node root, String name) {
        for (Node child : (List)Cast.uncheckedCast((Object)root.children())) {
            if (!DefaultDeploymentDescriptor.localNameOf(child).equals(name)) continue;
            return child.text();
        }
        return null;
    }

    private static String localNameOf(Node node) {
        return node.name() instanceof QName ? ((QName)node.name()).getLocalPart() : String.valueOf(node.name());
    }

    @Override
    public DefaultDeploymentDescriptor writeTo(Object path) {
        this.transformer.transform((Node)this.toXmlNode(), this.fileResolver.resolve(path));
        return this;
    }

    @Override
    public DefaultDeploymentDescriptor writeTo(Writer writer) {
        this.transformer.transform(this.toXmlNode(), writer);
        return this;
    }

    private DomNode toXmlNode() {
        DomNode root = new DomNode(this.nodeNameFor("application"));
        Map rootAttributes = (Map)Cast.uncheckedCast((Object)root.attributes());
        rootAttributes.put("version", this.version);
        if (!"1.3".equals(this.version)) {
            rootAttributes.put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        if ("1.3".equals(this.version)) {
            root.setPublicId("-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN");
            root.setSystemId("http://java.sun.com/dtd/application_1_3.dtd");
        } else if ("1.4".equals(this.version)) {
            rootAttributes.put("xsi:schemaLocation", "http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/application_1_4.xsd");
        } else if ("5".equals(this.version) || "6".equals(this.version)) {
            rootAttributes.put("xsi:schemaLocation", "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application_" + this.version + ".xsd");
        } else if ("7".equals(this.version)) {
            rootAttributes.put("xsi:schemaLocation", "http://xmlns.jcp.org/xml/ns/javaee http://xmlns.jcp.org/xml/ns/javaee/application_" + this.version + ".xsd");
        }
        if (this.applicationName != null) {
            new Node((Node)root, this.nodeNameFor("application-name"), (Object)this.applicationName);
        }
        if (this.description != null) {
            new Node((Node)root, this.nodeNameFor("description"), (Object)this.description);
        }
        if (this.displayName != null) {
            new Node((Node)root, this.nodeNameFor("display-name"), (Object)this.displayName);
        }
        if (this.initializeInOrder != null && this.initializeInOrder.booleanValue()) {
            new Node((Node)root, this.nodeNameFor("initialize-in-order"), (Object)this.initializeInOrder);
        }
        for (EarModule module : this.modules) {
            Node moduleNode = new Node((Node)root, this.nodeNameFor("module"));
            module.toXmlNode(moduleNode, this.moduleNameFor(module));
        }
        if (this.securityRoles != null) {
            for (EarSecurityRole role : this.securityRoles) {
                Node roleNode = new Node((Node)root, this.nodeNameFor("security-role"));
                if (role.getDescription() != null) {
                    new Node(roleNode, this.nodeNameFor("description"), (Object)role.getDescription());
                }
                new Node(roleNode, this.nodeNameFor("role-name"), (Object)role.getRoleName());
            }
        }
        if (this.libraryDirectory != null) {
            new Node((Node)root, this.nodeNameFor("library-directory"), (Object)this.libraryDirectory);
        }
        return root;
    }

    private Object moduleNameFor(EarModule module) {
        String name = this.moduleTypeMappings.get(module.getPath());
        if (name == null) {
            name = module instanceof EarWebModule ? "web" : "ejb";
        }
        return this.nodeNameFor(name);
    }

    private Object nodeNameFor(String name) {
        if ("1.3".equals(this.version)) {
            return name;
        }
        if ("1.4".equals(this.version)) {
            return new QName("http://java.sun.com/xml/ns/j2ee", name);
        }
        if ("5".equals(this.version) || "6".equals(this.version)) {
            return new QName("http://java.sun.com/xml/ns/javaee", name);
        }
        if ("7".equals(this.version)) {
            return new QName("http://xmlns.jcp.org/xml/ns/javaee", name);
        }
        return new QName(name);
    }

    XmlTransformer getTransformer() {
        return this.transformer;
    }
}

