/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.resolve;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.resolve.VirtualFileScriptSource;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\u00058VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/scripting/resolve/KtFileScriptSource;", "Lorg/jetbrains/kotlin/scripting/resolve/VirtualFileScriptSource;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "preloadedText", "", "(Lorg/jetbrains/kotlin/psi/KtFile;Ljava/lang/String;)V", "getKtFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "name", "getName", "()Ljava/lang/String;", "text", "getText", "text$delegate", "Lkotlin/Lazy;", "equals", "", "other", "", "hashCode", "", "kotlin-scripting-compiler-impl"})
public class KtFileScriptSource
extends VirtualFileScriptSource {
    @NotNull
    private final KtFile ktFile;
    @NotNull
    private final Lazy text$delegate;

    public KtFileScriptSource(@NotNull KtFile ktFile, @Nullable String preloadedText) {
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
        VirtualFile virtualFile = ktFile.getVirtualFile();
        VirtualFile virtualFile2 = virtualFile == null ? ktFile.getOriginalFile().getVirtualFile() : virtualFile;
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"ktFile.virtualFile ?: ktFile.originalFile.virtualFile");
        super(virtualFile2, preloadedText);
        this.ktFile = ktFile;
        this.text$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(preloadedText, this){
            final /* synthetic */ String $preloadedText;
            final /* synthetic */ KtFileScriptSource this$0;
            {
                this.$preloadedText = $preloadedText;
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke() {
                String string = this.$preloadedText;
                return string == null ? this.this$0.getKtFile().getText() : string;
            }
        }));
    }

    public /* synthetic */ KtFileScriptSource(KtFile ktFile, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(ktFile, string);
    }

    @NotNull
    public final KtFile getKtFile() {
        return this.ktFile;
    }

    @Override
    @NotNull
    public String getText() {
        Lazy lazy = this.text$delegate;
        boolean bl = false;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pyright 2010-2019 JetBrains s.r.o. and Kotlin Programming Language contributors.\n * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.\n */\n\npackage org.jetbrains.kotlin.scripting.resolve\n\nimport com.intellij.openapi.application.ApplicationManager\nimport com.intellij.openapi.editor.Document\nimport com.intellij.openapi.project.Project\nimport com.intellij.openapi.util.text.StringUtil\nimport com.intellij.openapi.vfs.CharsetToolkit\nimport com.intellij.openapi.vfs.LocalFileSystem\nimport com.intellij.openapi.vfs.VirtualFile\nimport com.intellij.psi.PsiElement\nimport com.intellij.psi.PsiFile\nimport com.intellij.psi.PsiManager\nimport com.intellij.testFramework.LightVirtualFile\nimport kotlinx.coroutines.runBlocking\nimport org.jetbrains.kotlin.idea.KotlinLanguage\nimport org.jetbrains.kotlin.psi.KtAnnotationEntry\nimport org.jetbrains.kotlin.psi.KtFile\nimport org.jetbrains.kotlin.psi.psiUtil.endOffset\nimport org.jetbrains.kotlin.psi.psiUtil.startOffset\nimport org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition\nimport org.jetbrains.kotlin.scripting.definitions.ScriptDefinition\nimport org.jetbrains.kotlin.scripting.definitions.runReadAction\nimport org.jetbrains.kotlin.scripting.withCorrectExtension\nimport java.io.File\nimport java.net.URL\nimport kotlin.reflect.KClass\nimport kotlin.script.experimental.api.*\nimport kotlin.script.experimental.dependencies.AsyncDependenciesResolver\nimport kotlin.script.experimental.dependencies.DependenciesResolver\nimport kotlin.script.experimental.dependencies.ScriptDependencies\nimport kotlin.script.experimental.host.*\nimport kotlin.script.experimental.jvm.*\nimport kotlin.script.experimental.jvm.compat.mapToDiagnostics\nimport kotlin.script.experimental.jvm.impl.toClassPathOrEmpty\nimport kotlin.script.experimental.jvm.impl.toDependencies\n\ninternal fun VirtualFile.loadAnnotations(\n    acceptedAnnotations: List<KClass<out Annotation>>,\n    project: Project,\n    classLoader: ClassLoader?\n): List<Annotation> =\n// TODO_R: report error on failure to load annotation class\n    ApplicationManager.getApplication().runReadAction<List<Annotation>> {\n        this.getAnnotationEntries(project)\n            .construct(classLoader, acceptedAnnotations, project)\n            .map { it.first }\n    }\n\ninternal fun VirtualFile.getAnnotationEntries(project: Project): Iterable<KtAnnotationEntry> {\n    val psiFile: PsiFile = PsiManager.getInstance(project).findFile(this)\n        ?: throw IllegalArgumentException(\"Unable to load PSI from $canonicalPath\")\n    return (psiFile as? KtFile)?.annotationEntries\n        ?: throw IllegalArgumentException(\"Unable to extract kotlin annotations from $name ($fileType)\")\n}\n\n/**\n * The implementation of the SourceCode for a script located in a virtual file\n */\nopen class VirtualFileScriptSource(val virtualFile: VirtualFile, private val preloadedText: String? = null) :\n    FileBasedScriptSource() {\n    override val file: File get() = File(virtualFile.path)\n    override val externalLocation: URL get() = URL(virtualFile.url)\n    override val text: String by lazy { preloadedText ?: virtualFile.inputStream.bufferedReader().readText() }\n    override val name: String? get() = virtualFile.name\n    override val locationId: String? get() = virtualFile.path\n\n    override fun equals(other: Any?): Boolean =\n        this === other || (other as? VirtualFileScriptSource)?.let { virtualFile == it.virtualFile } == true\n\n    override fun hashCode(): Int = virtualFile.hashCode()\n}\n\n/**\n * The implementation of the SourceCode for a script located in a KtFile\n */\nopen class KtFileScriptSource(val ktFile: KtFile, preloadedText: String? = null) :\n    VirtualFileScriptSource(ktFile.virtualFile ?: ktFile.originalFile.virtualFile, preloadedText) {\n\n    override val text: String by lazy { preloadedText ?: ktFile.text }");
        return (String)object;
    }

    @Override
    @Nullable
    public String getName() {
        return this.ktFile.getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        Boolean bl;
        KtFileScriptSource ktFileScriptSource;
        if (this == other) return true;
        KtFileScriptSource ktFileScriptSource2 = ktFileScriptSource = other instanceof KtFileScriptSource ? (KtFileScriptSource)((Object)other) : null;
        if (ktFileScriptSource == null) {
            bl = null;
        } else {
            KtFileScriptSource ktFileScriptSource3 = ktFileScriptSource;
            boolean bl2 = false;
            boolean bl3 = false;
            KtFileScriptSource it = ktFileScriptSource3;
            boolean bl4 = false;
            bl = Intrinsics.areEqual((Object)this.getKtFile(), (Object)it.getKtFile());
        }
        if (!Intrinsics.areEqual(bl, (Object)true)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.ktFile.hashCode();
    }
}

