/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.interpreter.Exception;
import org.jetbrains.kotlin.ir.interpreter.Next;
import org.jetbrains.kotlin.ir.interpreter.ReturnLabel;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J'\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00052\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00000\r\u00a2\u0006\u0002\b\u000eR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/ExecutionResult;", "", "returnLabel", "Lorg/jetbrains/kotlin/ir/interpreter/ReturnLabel;", "owner", "Lorg/jetbrains/kotlin/ir/IrElement;", "(Lorg/jetbrains/kotlin/ir/interpreter/ReturnLabel;Lorg/jetbrains/kotlin/ir/IrElement;)V", "getReturnLabel", "()Lorg/jetbrains/kotlin/ir/interpreter/ReturnLabel;", "addOwnerInfo", "getNextLabel", "irElement", "interpret", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "ir.interpreter"})
public class ExecutionResult {
    @NotNull
    private final ReturnLabel returnLabel;
    @Nullable
    private final IrElement owner;

    public ExecutionResult(@NotNull ReturnLabel returnLabel, @Nullable IrElement owner) {
        Intrinsics.checkNotNullParameter((Object)((Object)returnLabel), (String)"returnLabel");
        this.returnLabel = returnLabel;
        this.owner = owner;
    }

    public /* synthetic */ ExecutionResult(ReturnLabel returnLabel, IrElement irElement, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            irElement = null;
        }
        this(returnLabel, irElement);
    }

    @NotNull
    public final ReturnLabel getReturnLabel() {
        return this.returnLabel;
    }

    @NotNull
    public final ExecutionResult getNextLabel(@NotNull IrElement irElement, @NotNull Function1<? super IrElement, ? extends ExecutionResult> interpret2) {
        ExecutionResult executionResult2;
        Intrinsics.checkNotNullParameter((Object)irElement, (String)"irElement");
        Intrinsics.checkNotNullParameter(interpret2, (String)"interpret");
        ReturnLabel returnLabel = this.returnLabel;
        int n = WhenMappings.$EnumSwitchMapping$0[returnLabel.ordinal()];
        switch (n) {
            case 1: {
                IrElement irElement2 = irElement;
                if ((irElement2 instanceof IrCall ? true : irElement2 instanceof IrReturnableBlock) ? true : irElement2 instanceof IrSimpleFunction) {
                    if (Intrinsics.areEqual((Object)this.owner, (Object)irElement)) {
                        executionResult2 = Next.INSTANCE;
                        break;
                    }
                    executionResult2 = this;
                    break;
                }
                executionResult2 = this;
                break;
            }
            case 2: {
                IrElement irElement3 = irElement;
                if (irElement3 instanceof IrWhen) {
                    executionResult2 = Next.INSTANCE;
                    break;
                }
                executionResult2 = this;
                break;
            }
            case 3: {
                IrElement irElement4 = irElement;
                if (irElement4 instanceof IrWhileLoop) {
                    if (Intrinsics.areEqual((Object)this.owner, (Object)irElement)) {
                        executionResult2 = Next.INSTANCE;
                        break;
                    }
                    executionResult2 = this;
                    break;
                }
                executionResult2 = this;
                break;
            }
            case 4: {
                IrElement irElement5 = irElement;
                if (irElement5 instanceof IrWhileLoop) {
                    if (Intrinsics.areEqual((Object)this.owner, (Object)irElement)) {
                        executionResult2 = (ExecutionResult)interpret2.invoke((Object)irElement);
                        break;
                    }
                    executionResult2 = this;
                    break;
                }
                executionResult2 = this;
                break;
            }
            case 5: {
                executionResult2 = Exception.INSTANCE;
                break;
            }
            case 6: {
                executionResult2 = Next.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return executionResult2;
    }

    @NotNull
    public final ExecutionResult addOwnerInfo(@NotNull IrElement owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        return new ExecutionResult(this.returnLabel, owner);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReturnLabel.values().length];
            nArray[ReturnLabel.RETURN.ordinal()] = 1;
            nArray[ReturnLabel.BREAK_WHEN.ordinal()] = 2;
            nArray[ReturnLabel.BREAK_LOOP.ordinal()] = 3;
            nArray[ReturnLabel.CONTINUE.ordinal()] = 4;
            nArray[ReturnLabel.EXCEPTION.ordinal()] = 5;
            nArray[ReturnLabel.REGULAR.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

