/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class FeaturePreviews {
    private final Set<Feature> activeFeatures;
    private final EnumSet<Feature> enabledFeatures = EnumSet.noneOf(Feature.class);

    public FeaturePreviews() {
        EnumSet<Feature> tmpActiveSet = EnumSet.noneOf(Feature.class);
        for (Feature feature : Feature.values()) {
            if (!feature.isActive()) continue;
            tmpActiveSet.add(feature);
        }
        this.activeFeatures = Collections.unmodifiableSet(tmpActiveSet);
    }

    public void enableFeature(Feature feature) {
        if (feature.isActive()) {
            this.enabledFeatures.add(feature);
        }
    }

    public boolean isFeatureEnabled(Feature feature) {
        return feature.isActive() && this.enabledFeatures.contains((Object)feature);
    }

    public Set<Feature> getActiveFeatures() {
        return this.activeFeatures;
    }

    public static enum Feature {
        GROOVY_COMPILATION_AVOIDANCE(true),
        ONE_LOCKFILE_PER_PROJECT(false),
        VERSION_ORDERING_V2(false),
        VERSION_CATALOGS(true),
        TYPESAFE_PROJECT_ACCESSORS(true);

        private final boolean active;

        public static Feature withName(String name) {
            try {
                return Feature.valueOf(name);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("There is no feature named " + name);
            }
        }

        private Feature(boolean active) {
            this.active = active;
        }

        public boolean isActive() {
            return this.active;
        }
    }
}

