/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.configuration.ProjectsPreparer;
import org.gradle.execution.TaskSelector;

public class ExcludedTaskFilteringProjectsPreparer
implements ProjectsPreparer {
    private final TaskSelector taskSelector;

    public ExcludedTaskFilteringProjectsPreparer(TaskSelector taskSelector) {
        this.taskSelector = taskSelector;
    }

    @Override
    public void prepareProjects(GradleInternal gradle) {
        Set excludedTaskNames = gradle.getStartParameter().getExcludedTaskNames();
        if (!excludedTaskNames.isEmpty()) {
            HashSet<Spec<Task>> filters = new HashSet<Spec<Task>>();
            for (String taskName : excludedTaskNames) {
                filters.add(this.taskSelector.getFilter(taskName));
            }
            gradle.getTaskGraph().useFilter((Spec<? super Task>)Specs.intersect(filters));
        }
    }
}

