/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import java.util.function.Function;
import java.util.function.Supplier;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.composite.internal.IncludedBuildTaskGraph;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.buildtree.BuildTreeFinishExecutor;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.buildtree.BuildTreeModelCreator;
import org.gradle.internal.buildtree.BuildTreeWorkExecutor;
import org.gradle.internal.buildtree.BuildTreeWorkPreparer;

public class DefaultBuildTreeLifecycleController
implements BuildTreeLifecycleController {
    private boolean completed;
    private final BuildLifecycleController buildLifecycleController;
    private final IncludedBuildTaskGraph taskGraph;
    private final BuildTreeWorkPreparer workPreparer;
    private final BuildTreeWorkExecutor workExecutor;
    private final BuildTreeModelCreator modelCreator;
    private final BuildTreeFinishExecutor finishExecutor;
    private final ExceptionAnalyser exceptionAnalyser;

    public DefaultBuildTreeLifecycleController(BuildLifecycleController buildLifecycleController, IncludedBuildTaskGraph taskGraph, BuildTreeWorkPreparer workPreparer, BuildTreeWorkExecutor workExecutor, BuildTreeModelCreator modelCreator, BuildTreeFinishExecutor finishExecutor, ExceptionAnalyser exceptionAnalyser) {
        this.buildLifecycleController = buildLifecycleController;
        this.taskGraph = taskGraph;
        this.workPreparer = workPreparer;
        this.modelCreator = modelCreator;
        this.workExecutor = workExecutor;
        this.finishExecutor = finishExecutor;
        this.exceptionAnalyser = exceptionAnalyser;
    }

    @Override
    public GradleInternal getGradle() {
        if (this.completed) {
            throw new IllegalStateException("Cannot use Gradle object after build has finished.");
        }
        return this.buildLifecycleController.getGradle();
    }

    @Override
    public void scheduleAndRunTasks() {
        this.runBuild(this::doScheduleAndRunTasks);
    }

    @Override
    public <T> T fromBuildModel(boolean runTasks, Function<? super GradleInternal, T> action) {
        return this.runBuild(() -> {
            ExecutionResult<Void> result;
            if (runTasks && !(result = this.doScheduleAndRunTasks()).getFailures().isEmpty()) {
                return result.asFailure();
            }
            Object model = this.modelCreator.fromBuildModel(action);
            return ExecutionResult.succeeded(model);
        });
    }

    private ExecutionResult<Void> doScheduleAndRunTasks() {
        return this.taskGraph.withNewTaskGraph(() -> {
            this.workPreparer.scheduleRequestedTasks();
            return this.workExecutor.execute();
        });
    }

    @Override
    public <T> T withEmptyBuild(Function<? super SettingsInternal, T> action) {
        return this.runBuild(() -> {
            Object result = action.apply(this.buildLifecycleController.getLoadedSettings());
            return ExecutionResult.succeeded(result);
        });
    }

    private <T> T runBuild(Supplier<ExecutionResult<? extends T>> action) {
        ExecutionResult<Object> result;
        if (this.completed) {
            throw new IllegalStateException("Cannot run more than one action for this build.");
        }
        this.completed = true;
        try {
            result = action.get();
        }
        catch (Throwable t) {
            result = ExecutionResult.failed(t);
        }
        ExecutionResult<Void> finishResult = this.finishExecutor.finishBuildTree(result.getFailures());
        result = result.withFailures(finishResult);
        RuntimeException finalReportableFailure = this.exceptionAnalyser.transform(result.getFailures());
        if (finalReportableFailure != null) {
            throw finalReportableFailure;
        }
        return (T)result.getValue();
    }
}

