/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.references.FirBackingFieldReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirValReassignmentChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirVariableAssignmentChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkValReassignmentOnValueParameter", "checkValReassignmentViaBackingField", "checkers"})
public final class FirValReassignmentChecker
extends FirExpressionChecker<FirVariableAssignment> {
    @NotNull
    public static final FirValReassignmentChecker INSTANCE = new FirValReassignmentChecker();

    private FirValReassignmentChecker() {
    }

    @Override
    public void check(@NotNull FirVariableAssignment expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.checkValReassignmentViaBackingField(expression2, context2, reporter);
        this.checkValReassignmentOnValueParameter(expression2, context2, reporter);
    }

    private final void checkValReassignmentViaBackingField(FirVariableAssignment expression2, CheckerContext context2, DiagnosticReporter reporter) {
        FirDeclaration firDeclaration;
        FirProperty property2;
        FirBackingFieldReference backingFieldReference;
        block11: {
            FirBackingFieldReference firBackingFieldReference;
            FirReference firReference = expression2.getLValue();
            FirBackingFieldReference firBackingFieldReference2 = firBackingFieldReference = firReference instanceof FirBackingFieldReference ? (FirBackingFieldReference)firReference : null;
            if (firBackingFieldReference == null) {
                return;
            }
            backingFieldReference = firBackingFieldReference;
            property2 = (FirProperty)backingFieldReference.getResolvedSymbol().getFir();
            if (property2.isVar()) {
                return;
            }
            CheckerContext $this$findClosest$iv = context2;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest$iv.getContainingDeclarations())) {
                FirDeclaration firDeclaration2;
                FirDeclaration firDeclaration3;
                FirDeclaration firDeclaration4;
                FirDeclaration firDeclaration5 = it$iv;
                if (!(firDeclaration5 instanceof FirPropertyAccessor)) {
                    firDeclaration5 = null;
                }
                if ((firDeclaration4 = (FirDeclaration)((FirPropertyAccessor)firDeclaration5)) == null) {
                    firDeclaration3 = null;
                } else {
                    FirDeclaration firDeclaration6 = firDeclaration4;
                    boolean bl = false;
                    boolean bl2 = false;
                    FirPropertyAccessor it = (FirPropertyAccessor)firDeclaration6;
                    boolean bl3 = false;
                    firDeclaration3 = firDeclaration2 = it.isGetter() ? firDeclaration6 : null;
                }
                if (firDeclaration2 == null) continue;
                firDeclaration = firDeclaration2;
                break block11;
            }
            firDeclaration = null;
        }
        Object object = (FirPropertyAccessor)firDeclaration;
        if (object == null) {
            return;
        }
        FirPropertyAccessor closestGetter = object;
        if (!Intrinsics.areEqual((Object)property2.getGetter(), (Object)closestGetter)) {
            return;
        }
        object = backingFieldReference.getSource();
        if (object != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl4 = false;
            Object it = object2;
            boolean bl5 = false;
            if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.RestrictionOfValReassignmentViaBackingField)) {
                DiagnosticReporterKt.reportOn$default(reporter, (FirSourceElement)it, FirErrors.INSTANCE.getVAL_REASSIGNMENT_VIA_BACKING_FIELD_ERROR(), property2.getSymbol(), context2, null, 16, null);
            } else {
                DiagnosticReporterKt.reportOn$default(reporter, (FirSourceElement)it, FirErrors.INSTANCE.getVAL_REASSIGNMENT_VIA_BACKING_FIELD(), property2.getSymbol(), context2, null, 16, null);
            }
        }
    }

    private final void checkValReassignmentOnValueParameter(FirVariableAssignment expression2, CheckerContext context2, DiagnosticReporter reporter) {
        FirValueParameter firValueParameter;
        FirResolvedNamedReference firResolvedNamedReference;
        Object object = expression2.getLValue();
        FirResolvedNamedReference firResolvedNamedReference2 = firResolvedNamedReference = object instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)object : null;
        Object var6_6 = firResolvedNamedReference == null ? null : ((object = firResolvedNamedReference.getResolvedSymbol()) == null ? null : ((AbstractFirBasedSymbol)object).getFir());
        FirValueParameter firValueParameter2 = firValueParameter = var6_6 instanceof FirValueParameter ? (FirValueParameter)var6_6 : null;
        if (firValueParameter == null) {
            return;
        }
        FirValueParameter valueParameter2 = firValueParameter;
        DiagnosticReporterKt.reportOn$default(reporter, expression2.getLValue().getSource(), FirErrors.INSTANCE.getVAL_REASSIGNMENT(), valueParameter2.getSymbol(), context2, null, 16, null);
    }
}

