/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.plugins;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.plugin.devel.tasks.ValidatePlugins;
import org.gradle.plugin.use.PluginId;

@Incubating
@CacheableTask
public abstract class ExternalPluginValidationPlugin
implements Plugin<Project> {
    private static final Logger LOGGER = Logging.getLogger(ExternalPluginValidationPlugin.class);
    private static final String VALIDATE_EXTERNAL_PLUGINS_TASK_NAME = "validateExternalPlugins";
    private static final String VALIDATE_EXTERNAL_PLUGIN_TASK_PREFIX = "validatePluginWithId_";
    private final FileOperations fileOperations;

    @Inject
    public ExternalPluginValidationPlugin(FileOperations fileOperations) {
        this.fileOperations = fileOperations;
    }

    public void apply(Project project) {
        TaskProvider<Task> lifecycleTask = ExternalPluginValidationPlugin.createLifecycleTask(project);
        PluginRegistry registry = ExternalPluginValidationPlugin.findPluginRegistry(project);
        HashMap jarsByPlugin = Maps.newHashMap();
        project.getPlugins().configureEach(p -> this.configurePluginValidation(project, lifecycleTask, registry, jarsByPlugin, (Plugin<?>)p));
    }

    private void configurePluginValidation(Project project, TaskProvider<Task> lifecycleTask, PluginRegistry registry, Map<String, List<File>> jarsByPlugin, Plugin<?> plugin) {
        Class<?> pluginClass = plugin.getClass();
        if (ExternalPluginValidationPlugin.isExternal(pluginClass)) {
            Optional pluginForClass = registry.findPluginForClass(pluginClass);
            String pluginId = pluginForClass.map(PluginId::getId).orElseGet(() -> ExternalPluginValidationPlugin.computePluginName(plugin));
            File pluginJar = ExternalPluginValidationPlugin.findPluginJar(pluginClass);
            if (pluginJar != null) {
                jarsByPlugin.computeIfAbsent(pluginId, firstSeenPlugin -> this.registerValidationTaskForNewPlugin((String)firstSeenPlugin, project, lifecycleTask)).add(pluginJar);
            } else {
                LOGGER.warn("Validation won't be performed for plugin '{}' because we couldn't locate its jar file", (Object)pluginId);
            }
        }
    }

    private static String computePluginName(Plugin<?> plugin) {
        return plugin.getClass().getName();
    }

    private List<File> registerValidationTaskForNewPlugin(String pluginId, Project project, TaskProvider<Task> lifecycleTask) {
        ArrayList jarsForPlugin = Lists.newArrayList();
        TaskProvider<ValidatePlugins> validationTask = this.configureValidationTask(project, jarsForPlugin, pluginId);
        lifecycleTask.configure(task -> task.dependsOn(new Object[]{validationTask}));
        return jarsForPlugin;
    }

    private static PluginRegistry findPluginRegistry(Project project) {
        return (PluginRegistry)((ProjectInternal)project).getServices().get(PluginRegistry.class);
    }

    private static TaskProvider<Task> createLifecycleTask(Project project) {
        return project.getTasks().register(VALIDATE_EXTERNAL_PLUGINS_TASK_NAME);
    }

    private TaskProvider<ValidatePlugins> configureValidationTask(Project project, List<File> pluginJars, String pluginId) {
        String idWithoutDots = pluginId.replace('.', '_');
        return project.getTasks().register(VALIDATE_EXTERNAL_PLUGIN_TASK_PREFIX + idWithoutDots, ValidatePlugins.class, task -> {
            task.setGroup("Plugin development");
            task.setDescription("Validates the plugin by checking parameter annotations on task and artifact transform types etc.");
            task.getOutputFile().set(project.getLayout().getBuildDirectory().file("reports/plugins/validation-report-for-" + idWithoutDots + ".txt"));
            ScriptHandlerInternal scriptHandler = (ScriptHandlerInternal)project.getBuildscript();
            List scriptClassPath = scriptHandler.getScriptClassPath().getAsFiles();
            task.getClasses().setFrom(this.pluginClassesOf(pluginJars));
            task.getClasspath().setFrom((Iterable)scriptClassPath);
        });
    }

    private List<FileTree> pluginClassesOf(List<File> pluginJars) {
        return pluginJars.stream().map(arg_0 -> ((FileOperations)this.fileOperations).zipTree(arg_0)).collect(Collectors.toList());
    }

    @Nullable
    private static File findPluginJar(Class<?> pluginClass) {
        return ExternalPluginValidationPlugin.toFile(pluginClass.getProtectionDomain().getCodeSource().getLocation());
    }

    private static boolean isExternal(Class<?> pluginClass) {
        return !pluginClass.getName().startsWith("org.gradle");
    }

    @Nullable
    private static File toFile(URL url) {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

