/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.execution.ExecuteTaskBuildOperationDetails;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.operations.ExecuteTestBuildOperationType;
import org.gradle.api.tasks.testing.TestExecutionException;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.build.event.types.DefaultTestDescriptor;
import org.gradle.internal.operations.BuildOperationAncestryTracker;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.tooling.internal.protocol.events.InternalTestDescriptor;
import org.gradle.tooling.internal.protocol.test.InternalJvmTestRequest;
import org.gradle.tooling.internal.provider.action.TestExecutionRequestAction;

class TestExecutionResultEvaluator
implements BuildOperationListener {
    private static final String INDENT = "    ";
    private final BuildOperationAncestryTracker ancestryTracker;
    private final TestExecutionRequestAction internalTestExecutionRequest;
    private final AtomicLong resultCount = new AtomicLong();
    private final Map<Object, String> runningTasks = Maps.newConcurrentMap();
    private final Queue<FailedTest> failedTests = new ConcurrentLinkedQueue<FailedTest>();

    public TestExecutionResultEvaluator(BuildOperationAncestryTracker ancestryTracker, TestExecutionRequestAction internalTestExecutionRequest) {
        this.ancestryTracker = ancestryTracker;
        this.internalTestExecutionRequest = internalTestExecutionRequest;
    }

    public boolean hasUnmatchedTests() {
        return this.resultCount.get() == 0L;
    }

    public boolean hasFailedTests() {
        return !this.failedTests.isEmpty();
    }

    public void evaluate() {
        if (this.hasUnmatchedTests()) {
            String formattedTestRequest = this.formatInternalTestExecutionRequest();
            throw new TestExecutionException("No matching tests found in any candidate test task.\n" + formattedTestRequest);
        }
        if (this.hasFailedTests()) {
            StringBuilder failedTestsMessage = new StringBuilder("Test failed.\n").append(INDENT).append("Failed tests:");
            for (FailedTest failedTest : this.failedTests) {
                failedTestsMessage.append("\n").append(Strings.repeat((String)INDENT, (int)2)).append(failedTest.getDescription());
            }
            throw new TestExecutionException(failedTestsMessage.toString());
        }
    }

    private String formatInternalTestExecutionRequest() {
        StringBuilder requestDetails = new StringBuilder(INDENT).append("Requested tests:");
        for (InternalTestDescriptor internalTestDescriptor : this.internalTestExecutionRequest.getTestExecutionDescriptors()) {
            requestDetails.append("\n").append(Strings.repeat((String)INDENT, (int)2)).append(internalTestDescriptor.getDisplayName());
            requestDetails.append(" (Task: '").append(((DefaultTestDescriptor)internalTestDescriptor).getTaskPath()).append("')");
        }
        Set internalJvmTestRequests = this.internalTestExecutionRequest.getInternalJvmTestRequests();
        for (InternalJvmTestRequest internalJvmTestRequest : internalJvmTestRequests) {
            String className = internalJvmTestRequest.getClassName();
            String methodName = internalJvmTestRequest.getMethodName();
            if (methodName == null) {
                requestDetails.append("\n").append(Strings.repeat((String)INDENT, (int)2)).append("Test class ").append(className);
                continue;
            }
            requestDetails.append("\n").append(Strings.repeat((String)INDENT, (int)2)).append("Test method ").append(className).append(".").append(methodName).append("()");
        }
        return requestDetails.toString();
    }

    public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
        if (buildOperation.getDetails() instanceof ExecuteTaskBuildOperationDetails) {
            TaskInternal task = ((ExecuteTaskBuildOperationDetails)buildOperation.getDetails()).getTask();
            this.runningTasks.put(buildOperation.getId(), task.getPath());
        }
    }

    public void progress(OperationIdentifier buildOperationId, OperationProgressEvent progressEvent) {
    }

    public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
        if (buildOperation.getDetails() instanceof ExecuteTaskBuildOperationDetails) {
            this.runningTasks.remove(buildOperation.getId());
        } else if (finishEvent.getResult() instanceof ExecuteTestBuildOperationType.Result) {
            TestDescriptorInternal testDescriptor = (TestDescriptorInternal)((ExecuteTestBuildOperationType.Details)buildOperation.getDetails()).getTestDescriptor();
            TestResult testResult = ((ExecuteTestBuildOperationType.Result)finishEvent.getResult()).getResult();
            if (testDescriptor.getParent() == null) {
                this.resultCount.addAndGet(testResult.getTestCount());
            }
            if (!testDescriptor.isComposite() && testResult.getFailedTestCount() != 0L) {
                this.failedTests.add(new FailedTest(testDescriptor.getName(), testDescriptor.getClassName(), this.getTaskPath(buildOperation.getId(), testDescriptor)));
            }
        }
    }

    private String getTaskPath(OperationIdentifier buildOperationId, TestDescriptorInternal descriptor) {
        return (String)this.ancestryTracker.findClosestExistingAncestor(buildOperationId, this.runningTasks::get).orElseThrow(() -> new IllegalStateException("No parent task for test " + descriptor));
    }

    private static class FailedTest {
        final String name;
        final String className;
        final String taskPath;

        public FailedTest(String name, String className, String taskPath) {
            this.name = name;
            this.className = className;
            this.taskPath = taskPath;
        }

        public String getDescription() {
            StringBuilder stringBuilder = new StringBuilder("Test ").append(this.className).append("#").append(this.name).append(" (Task: ").append(this.taskPath).append(")");
            return stringBuilder.toString();
        }
    }
}

