/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.type;

import com.google.common.io.Files;
import java.io.File;
import java.util.HashSet;
import java.util.function.Consumer;
import org.gradle.api.artifacts.type.ArtifactTypeContainer;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.artifacts.ArtifactTransformRegistration;
import org.gradle.api.internal.artifacts.VariantTransformRegistry;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.artifacts.type.DefaultArtifactTypeContainer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.reflect.Instantiator;

public class DefaultArtifactTypeRegistry
implements ArtifactTypeRegistry {
    private final Instantiator instantiator;
    private final ImmutableAttributesFactory attributesFactory;
    private final CollectionCallbackActionDecorator callbackActionDecorator;
    private final VariantTransformRegistry transformRegistry;
    private ArtifactTypeContainer artifactTypeDefinitions;

    public DefaultArtifactTypeRegistry(Instantiator instantiator, ImmutableAttributesFactory attributesFactory, CollectionCallbackActionDecorator callbackActionDecorator, VariantTransformRegistry transformRegistry) {
        this.instantiator = instantiator;
        this.attributesFactory = attributesFactory;
        this.callbackActionDecorator = callbackActionDecorator;
        this.transformRegistry = transformRegistry;
    }

    @Override
    public void visitArtifactTypes(Consumer<? super ImmutableAttributes> action) {
        HashSet<ImmutableAttributes> seen = new HashSet<ImmutableAttributes>();
        if (this.artifactTypeDefinitions != null) {
            for (ArtifactTypeDefinition artifactTypeDefinition : this.artifactTypeDefinitions) {
                ImmutableAttributes attributes = ((AttributeContainerInternal)artifactTypeDefinition.getAttributes()).asImmutable();
                attributes = this.attributesFactory.concat(this.attributesFactory.of(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)artifactTypeDefinition.getName()), attributes);
                if (!seen.add(attributes)) continue;
                action.accept((ImmutableAttributes)attributes);
            }
        }
        for (ArtifactTransformRegistration transform : this.transformRegistry.getTransforms()) {
            ImmutableAttributes attributes;
            AttributeContainerInternal sourceAttributes = transform.getFrom();
            String format = (String)sourceAttributes.getAttribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE);
            if (format == null || !seen.add(attributes = sourceAttributes.asImmutable())) continue;
            action.accept((ImmutableAttributes)attributes);
        }
    }

    public ArtifactTypeContainer create() {
        if (this.artifactTypeDefinitions == null) {
            this.artifactTypeDefinitions = (ArtifactTypeContainer)this.instantiator.newInstance(DefaultArtifactTypeContainer.class, new Object[]{this.instantiator, this.attributesFactory, this.callbackActionDecorator});
        }
        return this.artifactTypeDefinitions;
    }

    @Override
    public ImmutableAttributes mapAttributesFor(File file) {
        ImmutableAttributes attributes = ImmutableAttributes.EMPTY;
        if (file.isDirectory()) {
            attributes = this.attributesFactory.of(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"directory");
        } else {
            String extension = Files.getFileExtension((String)file.getName());
            if (this.artifactTypeDefinitions != null) {
                attributes = this.applyForExtension(attributes, extension);
            }
            attributes = this.attributesFactory.concat(this.attributesFactory.of(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)extension), attributes);
        }
        return attributes;
    }

    @Override
    public ImmutableAttributes mapAttributesFor(ImmutableAttributes attributes, Iterable<? extends ComponentArtifactMetadata> artifacts) {
        if (this.artifactTypeDefinitions != null) {
            String extension = null;
            for (ComponentArtifactMetadata componentArtifactMetadata : artifacts) {
                String candidateExtension = componentArtifactMetadata.getName().getExtension();
                if (extension == null) {
                    extension = candidateExtension;
                    continue;
                }
                if (extension.equals(candidateExtension)) continue;
                extension = null;
                break;
            }
            if (extension != null) {
                attributes = this.applyForExtension(attributes, extension);
            }
        }
        if (!attributes.contains(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE)) {
            String format = null;
            for (ComponentArtifactMetadata componentArtifactMetadata : artifacts) {
                String candidateFormat = componentArtifactMetadata.getName().getType();
                if (format == null) {
                    format = candidateFormat;
                    continue;
                }
                if (format.equals(candidateFormat)) continue;
                format = null;
                break;
            }
            if (format != null) {
                attributes = this.attributesFactory.concat(attributes.asImmutable(), ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, format);
            }
        }
        return attributes;
    }

    private ImmutableAttributes applyForExtension(ImmutableAttributes attributes, String extension) {
        ArtifactTypeDefinition definition = (ArtifactTypeDefinition)this.artifactTypeDefinitions.findByName(extension);
        if (definition != null) {
            attributes = this.attributesFactory.concat(((AttributeContainerInternal)definition.getAttributes()).asImmutable(), attributes);
        }
        return attributes;
    }
}

