/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildevents;

import java.util.List;
import java.util.function.Consumer;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.internal.exceptions.ContextAwareException;
import org.gradle.internal.exceptions.ExceptionContextVisitor;
import org.gradle.internal.exceptions.FailureResolutionAware;
import org.gradle.internal.exceptions.StyledException;
import org.gradle.internal.logging.text.BufferingStyledTextOutput;
import org.gradle.internal.logging.text.LinePrefixingStyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.util.internal.GUtil;

public class BuildExceptionReporter
implements Action<Throwable> {
    private final StyledTextOutputFactory textOutputFactory;
    private final LoggingConfiguration loggingConfiguration;
    private final BuildClientMetaData clientMetaData;

    public BuildExceptionReporter(StyledTextOutputFactory textOutputFactory, LoggingConfiguration loggingConfiguration, BuildClientMetaData clientMetaData) {
        this.textOutputFactory = textOutputFactory;
        this.loggingConfiguration = loggingConfiguration;
        this.clientMetaData = clientMetaData;
    }

    public void buildFinished(BuildResult result) {
        Throwable failure = result.getFailure();
        if (failure == null) {
            return;
        }
        this.execute(failure);
    }

    public void execute(Throwable failure) {
        if (failure instanceof MultipleBuildFailures) {
            List flattenedFailures = ((MultipleBuildFailures)((Object)failure)).getCauses();
            this.renderMultipleBuildExceptions(failure.getMessage(), flattenedFailures);
            return;
        }
        this.renderSingleBuildException(failure);
    }

    private void renderMultipleBuildExceptions(String message, List<? extends Throwable> flattenedFailures) {
        StyledTextOutput output = this.textOutputFactory.create(BuildExceptionReporter.class, LogLevel.ERROR);
        output.println();
        output.withStyle(StyledTextOutput.Style.Failure).format("FAILURE: %s", new Object[]{message});
        output.println();
        for (int i = 0; i < flattenedFailures.size(); ++i) {
            Throwable cause = flattenedFailures.get(i);
            FailureDetails details = this.constructFailureDetails("Task", cause);
            output.println();
            output.withStyle(StyledTextOutput.Style.Failure).format("%s: ", new Object[]{i + 1});
            details.summary.writeTo(output.withStyle(StyledTextOutput.Style.Failure));
            output.println();
            output.text((Object)"-----------");
            this.writeFailureDetails(output, details);
            output.println((Object)"==============================================================================");
        }
        this.writeGeneralTips(output);
    }

    private void renderSingleBuildException(Throwable failure) {
        StyledTextOutput output = this.textOutputFactory.create(BuildExceptionReporter.class, LogLevel.ERROR);
        FailureDetails details = this.constructFailureDetails("Build", failure);
        output.println();
        output.withStyle(StyledTextOutput.Style.Failure).text((Object)"FAILURE: ");
        details.summary.writeTo(output.withStyle(StyledTextOutput.Style.Failure));
        output.println();
        this.writeFailureDetails(output, details);
        this.writeGeneralTips(output);
    }

    private ExceptionStyle getShowStackTraceOption() {
        if (this.loggingConfiguration.getShowStacktrace() != ShowStacktrace.INTERNAL_EXCEPTIONS) {
            return ExceptionStyle.FULL;
        }
        return ExceptionStyle.NONE;
    }

    private FailureDetails constructFailureDetails(String granularity, Throwable failure) {
        FailureDetails details = new FailureDetails(failure, this.getShowStackTraceOption());
        details.summary.format("%s failed with an exception.", new Object[]{granularity});
        this.fillInFailureResolution(details);
        if (failure instanceof ContextAwareException) {
            ((ContextAwareException)((Object)failure)).accept(new ExceptionFormattingVisitor(details));
        } else {
            details.appendDetails();
        }
        details.renderStackTrace();
        return details;
    }

    private void fillInFailureResolution(FailureDetails details) {
        BufferingStyledTextOutput resolution = details.resolution;
        ContextImpl context = new ContextImpl(resolution);
        if (details.failure instanceof FailureResolutionAware) {
            ((FailureResolutionAware)((Object)details.failure)).appendResolutions(context);
        }
        if (details.exceptionStyle == ExceptionStyle.NONE) {
            context.appendResolution(output -> {
                resolution.text((Object)"Run with ");
                resolution.withStyle(StyledTextOutput.Style.UserInput).format("--%s", new Object[]{"stacktrace"});
                resolution.text((Object)" option to get the stack trace.");
            });
        }
        if (this.loggingConfiguration.getLogLevel() != LogLevel.DEBUG) {
            context.appendResolution(output -> {
                resolution.text((Object)"Run with ");
                if (this.loggingConfiguration.getLogLevel() != LogLevel.INFO) {
                    resolution.withStyle(StyledTextOutput.Style.UserInput).format("--%s", new Object[]{"info"});
                    resolution.text((Object)" or ");
                }
                resolution.withStyle(StyledTextOutput.Style.UserInput).format("--%s", new Object[]{"debug"});
                resolution.text((Object)" option to get more log output.");
            });
        }
        if (!context.missingBuild) {
            this.addBuildScanMessage(context);
        }
    }

    private void addBuildScanMessage(ContextImpl context) {
        context.appendResolution(output -> {
            output.text((Object)"Run with ");
            output.withStyle(StyledTextOutput.Style.UserInput).format("--%s", new Object[]{"scan"});
            output.text((Object)" to get full insights.");
        });
    }

    private void writeGeneralTips(StyledTextOutput resolution) {
        resolution.println();
        resolution.text((Object)"* Get more help at ");
        resolution.withStyle(StyledTextOutput.Style.UserInput).text((Object)"https://help.gradle.org");
        resolution.println();
    }

    private static String getMessage(Throwable throwable) {
        try {
            String message = throwable.getMessage();
            if (GUtil.isTrue((Object)message)) {
                return message;
            }
            return String.format("%s (no error message)", throwable.getClass().getName());
        }
        catch (Throwable t) {
            return String.format("Unable to get message for failure of type %s due to %s", throwable.getClass().getSimpleName(), t.getMessage());
        }
    }

    private void writeFailureDetails(StyledTextOutput output, FailureDetails details) {
        if (details.location.getHasContent()) {
            output.println();
            output.println((Object)"* Where:");
            details.location.writeTo(output);
            output.println();
        }
        if (details.details.getHasContent()) {
            output.println();
            output.println((Object)"* What went wrong:");
            details.details.writeTo(output);
            output.println();
        }
        if (details.resolution.getHasContent()) {
            output.println();
            output.println((Object)"* Try:");
            details.resolution.writeTo(output);
            output.println();
        }
        if (details.stackTrace.getHasContent()) {
            output.println();
            output.println((Object)"* Exception is:");
            details.stackTrace.writeTo(output);
            output.println();
        }
    }

    static void renderStyledError(Throwable failure, StyledTextOutput details) {
        if (failure instanceof StyledException) {
            ((StyledException)((Object)failure)).render(details);
        } else {
            details.text((Object)BuildExceptionReporter.getMessage(failure));
        }
    }

    private class ContextImpl
    implements FailureResolutionAware.Context {
        private final BufferingStyledTextOutput resolution;
        private boolean missingBuild;

        public ContextImpl(BufferingStyledTextOutput resolution) {
            this.resolution = resolution;
        }

        @Override
        public BuildClientMetaData getClientMetaData() {
            return BuildExceptionReporter.this.clientMetaData;
        }

        @Override
        public void doNotSuggestResolutionsThatRequireBuildDefinition() {
            this.missingBuild = true;
        }

        @Override
        public void appendResolution(Consumer<StyledTextOutput> resolutionProducer) {
            if (this.resolution.getHasContent()) {
                this.resolution.println();
            }
            this.resolution.style(StyledTextOutput.Style.Info).text((Object)"> ").style(StyledTextOutput.Style.Normal);
            resolutionProducer.accept((StyledTextOutput)this.resolution);
        }
    }

    private static class FailureDetails {
        Throwable failure;
        final BufferingStyledTextOutput summary = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput details = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput location = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput stackTrace = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput resolution = new BufferingStyledTextOutput();
        final ExceptionStyle exceptionStyle;

        public FailureDetails(Throwable failure, ExceptionStyle exceptionStyle) {
            this.failure = failure;
            this.exceptionStyle = exceptionStyle;
        }

        void appendDetails() {
            BuildExceptionReporter.renderStyledError(this.failure, (StyledTextOutput)this.details);
        }

        void renderStackTrace() {
            if (this.exceptionStyle == ExceptionStyle.FULL) {
                try {
                    this.stackTrace.exception(this.failure);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private static class ExceptionFormattingVisitor
    extends ExceptionContextVisitor {
        private final FailureDetails failureDetails;
        private int depth;

        private ExceptionFormattingVisitor(FailureDetails failureDetails) {
            this.failureDetails = failureDetails;
        }

        @Override
        protected void visitCause(Throwable cause) {
            this.failureDetails.failure = cause;
            this.failureDetails.appendDetails();
        }

        @Override
        protected void visitLocation(String location) {
            this.failureDetails.location.text((Object)location);
        }

        @Override
        public void node(Throwable node) {
            LinePrefixingStyledTextOutput output = this.getLinePrefixingStyledTextOutput(this.failureDetails);
            BuildExceptionReporter.renderStyledError(node, (StyledTextOutput)output);
        }

        @Override
        public void startChildren() {
            ++this.depth;
        }

        @Override
        public void endChildren() {
            --this.depth;
        }

        private LinePrefixingStyledTextOutput getLinePrefixingStyledTextOutput(FailureDetails details) {
            details.details.format("%n", new Object[0]);
            StringBuilder prefix = new StringBuilder();
            for (int i = 1; i < this.depth; ++i) {
                prefix.append("   ");
            }
            details.details.text((Object)prefix);
            prefix.append("  ");
            details.details.style(StyledTextOutput.Style.Info).text((Object)"> ").style(StyledTextOutput.Style.Normal);
            return new LinePrefixingStyledTextOutput((StyledTextOutput)details.details, (CharSequence)prefix, false);
        }
    }

    private static enum ExceptionStyle {
        NONE,
        FULL;

    }
}

