/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import groovy.lang.Closure;
import java.io.File;
import java.net.URI;
import org.gradle.api.JavaVersion;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.DependencyLockingHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.attributes.java.TargetJvmVersion;
import org.gradle.api.attributes.plugin.GradlePluginApiVersion;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.JavaEcosystemSupport;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptClassPathResolver;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.metaobject.BeanDynamicObject;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.resource.ResourceLocation;
import org.gradle.util.GradleVersion;
import org.gradle.util.internal.ConfigureUtil;

public class DefaultScriptHandler
implements ScriptHandler,
ScriptHandlerInternal,
DynamicObjectAware {
    private static final Logger LOGGER = Logging.getLogger(DefaultScriptHandler.class);
    private final ResourceLocation scriptResource;
    private final ClassLoaderScope classLoaderScope;
    private final ScriptClassPathResolver scriptClassPathResolver;
    private final DependencyResolutionServices dependencyResolutionServices;
    private final NamedObjectInstantiator instantiator;
    private final DependencyLockingHandler dependencyLockingHandler;
    private RepositoryHandler repositoryHandler;
    private DependencyHandler dependencyHandler;
    private ConfigurationContainer configContainer;
    private Configuration classpathConfiguration;
    private DynamicObject dynamicObject;

    public DefaultScriptHandler(ScriptSource scriptSource, DependencyResolutionServices dependencyResolutionServices, ClassLoaderScope classLoaderScope, ScriptClassPathResolver scriptClassPathResolver, NamedObjectInstantiator instantiator) {
        this.dependencyResolutionServices = dependencyResolutionServices;
        this.scriptResource = scriptSource.getResource().getLocation();
        this.classLoaderScope = classLoaderScope;
        this.scriptClassPathResolver = scriptClassPathResolver;
        this.instantiator = instantiator;
        this.dependencyLockingHandler = dependencyResolutionServices.getDependencyLockingHandler();
        JavaEcosystemSupport.configureSchema(dependencyResolutionServices.getAttributesSchema(), dependencyResolutionServices.getObjectFactory());
    }

    public void dependencies(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getDependencies());
    }

    @Override
    public void addScriptClassPathDependency(Object notation) {
        this.getDependencies().add("classpath", notation);
    }

    @Override
    public ClassPath getScriptClassPath() {
        return ClasspathUtil.getClasspath((ClassLoader)this.getClassLoader());
    }

    @Override
    public ClassPath getNonInstrumentedScriptClassPath() {
        return this.scriptClassPathResolver.resolveClassPath(this.classpathConfiguration);
    }

    public DependencyHandler getDependencies() {
        this.defineConfiguration();
        return this.dependencyHandler;
    }

    public RepositoryHandler getRepositories() {
        if (this.repositoryHandler == null) {
            this.repositoryHandler = this.dependencyResolutionServices.getResolveRepositoryHandler();
        }
        return this.repositoryHandler;
    }

    public void repositories(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getRepositories());
    }

    public ConfigurationContainer getConfigurations() {
        this.defineConfiguration();
        return this.configContainer;
    }

    private void defineConfiguration() {
        if (this.configContainer == null) {
            this.configContainer = this.dependencyResolutionServices.getConfigurationContainer();
        }
        if (this.dependencyHandler == null) {
            this.dependencyHandler = this.dependencyResolutionServices.getDependencyHandler();
        }
        if (this.classpathConfiguration == null) {
            this.classpathConfiguration = (Configuration)this.configContainer.create("classpath");
            AttributeContainer attributes = this.classpathConfiguration.getAttributes();
            attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)this.instantiator.named(Usage.class, "java-runtime")));
            attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)this.instantiator.named(Category.class, "library")));
            attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)this.instantiator.named(LibraryElements.class, "jar")));
            attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)this.instantiator.named(Bundling.class, "external")));
            attributes.attribute(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE, (Object)Integer.parseInt(JavaVersion.current().getMajorVersion()));
            attributes.attribute(GradlePluginApiVersion.GRADLE_PLUGIN_API_VERSION_ATTRIBUTE, (Object)((GradlePluginApiVersion)this.instantiator.named(GradlePluginApiVersion.class, GradleVersion.current().getVersion())));
            this.classpathConfiguration.getDependencyConstraints().add((Object)this.dependencyHandler.getConstraints().create((Object)"org.apache.logging.log4j:log4j-core", constraint -> constraint.version(version -> {
                version.require("2.17.0");
                version.reject(new String[]{"[2.0, 2.17)"});
            })));
        }
    }

    public void dependencyLocking(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getDependencyLocking());
    }

    public DependencyLockingHandler getDependencyLocking() {
        return this.dependencyLockingHandler;
    }

    public File getSourceFile() {
        return this.scriptResource.getFile();
    }

    public URI getSourceURI() {
        return this.scriptResource.getURI();
    }

    public ClassLoader getClassLoader() {
        if (!this.classLoaderScope.isLocked()) {
            LOGGER.debug("Eager creation of script class loader for {}. This may result in performance issues.", (Object)this.scriptResource.getDisplayName());
        }
        return this.classLoaderScope.getLocalClassLoader();
    }

    public DynamicObject getAsDynamicObject() {
        if (this.dynamicObject == null) {
            this.dynamicObject = new BeanDynamicObject((Object)this);
        }
        return this.dynamicObject;
    }
}

