/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.capsule.core;

import io.usethesource.capsule.Set;
import io.usethesource.capsule.SetMultimap;
import io.usethesource.capsule.core.AbstractPersistentTrieSetMultimap;
import io.usethesource.capsule.core.AbstractTransientTrieSetMultimap;
import io.usethesource.capsule.core.AbstractTrieSetMultimap;
import io.usethesource.capsule.core.trie.ArrayView;
import io.usethesource.capsule.core.trie.EitherSingletonOrCollection;
import io.usethesource.capsule.core.trie.MultimapNode;
import io.usethesource.capsule.core.trie.MultimapResult;
import io.usethesource.capsule.util.ArrayUtils;
import io.usethesource.capsule.util.BitmapUtils;
import io.usethesource.capsule.util.EqualityComparator;
import io.usethesource.capsule.util.collection.AbstractSpecialisedImmutableMap;
import io.usethesource.capsule.util.collection.AbstractSpecialisedImmutableSet;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class PersistentTrieSetMultimap<K, V>
extends AbstractPersistentTrieSetMultimap<K, V, Set.Immutable<V>, AbstractSetMultimapNode<K, V>>
implements Serializable {
    private static final long serialVersionUID = 42L;
    private static final PersistentTrieSetMultimap EMPTY_SETMULTIMAP = new PersistentTrieSetMultimap(EqualityComparator.EQUALS, CompactSetMultimapNode.EMPTY_NODE, 0, 0, 0);

    PersistentTrieSetMultimap(EqualityComparator<Object> cmp, AbstractSetMultimapNode<K, V> rootNode, int cachedSize, int keySetHashCode, int keySetSize) {
        super(cmp, rootNode, cachedSize, keySetHashCode, keySetSize);
    }

    @Override
    protected Set.Immutable<V> valueToTemporaryBox(V value) {
        return AbstractSpecialisedImmutableSet.setOf(value);
    }

    @Override
    protected final Set.Immutable<V> collectionToInternalFormat(Set.Immutable<V> valueCollection) {
        return valueCollection;
    }

    @Override
    protected final Set.Immutable<V> internalFormatToCollection(Set.Immutable<V> values) {
        return values;
    }

    @Override
    protected final PersistentTrieSetMultimap<K, V> wrap(EqualityComparator<Object> cmp, AbstractSetMultimapNode<K, V> rootNode, int cachedSize, int keySetHashCode, int keySetSize) {
        return new PersistentTrieSetMultimap<K, V>(cmp, rootNode, cachedSize, keySetHashCode, keySetSize);
    }

    public static final <K, V> SetMultimap.Immutable<K, V> of() {
        return EMPTY_SETMULTIMAP;
    }

    public static final <K, V> SetMultimap.Immutable<K, V> of(EqualityComparator<Object> cmp) {
        return new PersistentTrieSetMultimap<K, V>(cmp, CompactSetMultimapNode.EMPTY_NODE, 0, 0, 0);
    }

    public static final <K, V> SetMultimap.Immutable<K, V> of(K key, V ... values) {
        SetMultimap.Immutable<K, V> result = EMPTY_SETMULTIMAP;
        for (V value : values) {
            result = result.__insert(key, value);
        }
        return result;
    }

    public static final <K, V> SetMultimap.Immutable<K, V> of(K key0, V value0, K key1, V value1) {
        SetMultimap.Transient<K, V> result = EMPTY_SETMULTIMAP.asTransient();
        result.__insert(key0, value0);
        result.__insert(key1, value1);
        return result.freeze();
    }

    public static final <K, V> SetMultimap.Transient<K, V> transientOf() {
        return EMPTY_SETMULTIMAP.asTransient();
    }

    public static final <K, V> SetMultimap.Transient<K, V> transientOf(EqualityComparator<Object> cmp) {
        return PersistentTrieSetMultimap.of(cmp).asTransient();
    }

    public static final <K, V> SetMultimap.Transient<K, V> transientOf(K key, V ... values) {
        SetMultimap.Transient<K, V> result = EMPTY_SETMULTIMAP.asTransient();
        for (V value : values) {
            result.__insert(key, value);
        }
        return result;
    }

    @Override
    public SetMultimap.Immutable<K, V> union(SetMultimap<? extends K, ? extends V> setMultimap) {
        SetMultimap.Transient<? extends K, ? extends V> tmpTransient = this.asTransient();
        tmpTransient.union(setMultimap);
        return tmpTransient.freeze();
    }

    @Override
    public SetMultimap.Immutable<V, K> inverseMap() {
        SetMultimap.Transient builder = PersistentTrieSetMultimap.transientOf();
        this.entryIterator().forEachRemaining(tuple -> builder.__insert(tuple.getValue(), tuple.getKey()));
        return builder.freeze();
    }

    @Override
    public int size() {
        return this.cachedSize;
    }

    @Override
    public int sizeDistinct() {
        return this.cachedKeySetSize;
    }

    @Override
    public boolean isEmpty() {
        return this.cachedSize == 0;
    }

    @Override
    public Iterator<V> valueIterator() {
        return super.valueIterator(Set.Immutable::of);
    }

    @Override
    public boolean isTransientSupported() {
        return true;
    }

    @Override
    public SetMultimap.Transient<K, V> asTransient() {
        return new TransientTrieSetMultimap(this);
    }

    static final class TransientTrieSetMultimap<K, V>
    extends AbstractTransientTrieSetMultimap<K, V, Set.Immutable<V>, AbstractSetMultimapNode<K, V>> {
        TransientTrieSetMultimap(PersistentTrieSetMultimap<K, V> trieSetMultimap) {
            super(trieSetMultimap);
        }

        @Override
        protected Set.Immutable<V> valueToTemporaryBox(V value) {
            return AbstractSpecialisedImmutableSet.setOf(value);
        }

        @Override
        protected final Set.Immutable<V> collectionToInternalFormat(Set.Immutable<V> valueCollection) {
            return valueCollection;
        }

        @Override
        protected final Set.Immutable<V> internalFormatToCollection(Set.Immutable<V> values) {
            return values;
        }

        @Override
        public boolean union(SetMultimap<? extends K, ? extends V> setMultimap) {
            boolean modified = false;
            for (Map.Entry<K, V> entry : setMultimap.entrySet()) {
                modified |= this.__insert(entry.getKey(), entry.getValue());
            }
            return modified;
        }

        @Override
        public int size() {
            return this.cachedSize;
        }

        @Override
        public boolean isEmpty() {
            return this.cachedSize == 0;
        }

        @Override
        public Iterator<K> keyIterator() {
            return new AbstractTransientTrieSetMultimap.TransientSetMultimapKeyIterator(this);
        }

        @Override
        public Iterator<V> valueIterator() {
            return this.valueCollectionsStream().flatMap(Collection::stream).iterator();
        }

        @Override
        public Iterator<Map.Entry<K, V>> entryIterator() {
            return new AbstractTransientTrieSetMultimap.TransientSetMultimapTupleIterator(this, AbstractSpecialisedImmutableMap::entryOf);
        }

        @Override
        public <T> Iterator<T> tupleIterator(BiFunction<K, V, T> tupleOf) {
            return new AbstractTransientTrieSetMultimap.TransientSetMultimapTupleIterator(this, tupleOf);
        }

        private Spliterator<Set.Immutable<V>> valueCollectionsSpliterator() {
            int characteristics = 16704;
            return Spliterators.spliterator(new AbstractTrieSetMultimap.SetMultimapValueIterator(this.rootNode, Set.Immutable::of), (long)this.size(), characteristics);
        }

        private Stream<Set.Immutable<V>> valueCollectionsStream() {
            boolean isParallel = false;
            return StreamSupport.stream(this.valueCollectionsSpliterator(), isParallel);
        }

        @Override
        public SetMultimap.Immutable<K, V> freeze() {
            if (this.mutator.get() == null) {
                throw new IllegalStateException("Transient already frozen.");
            }
            this.mutator.set(null);
            return new PersistentTrieSetMultimap((EqualityComparator<Object>)this.cmp, (AbstractSetMultimapNode)this.rootNode, this.cachedSize, this.cachedKeySetHashCode, this.cachedKeySetSize);
        }
    }

    private static final class HashCollisionNode<K, V>
    extends AbstractHashCollisionNode<K, V> {
        private final int hash;
        private final List<Map.Entry<K, Set.Immutable<V>>> collisionContent;
        private static final RuntimeException UOE = new UnsupportedOperationException();
        private static final Supplier<RuntimeException> UOE_NOT_YET_IMPLEMENTED_FACTORY = () -> new UnsupportedOperationException("Not yet implemented @ HashCollisionNode.");

        HashCollisionNode(int hash, K key0, Set.Immutable<V> valColl0, K key1, Set.Immutable<V> valColl1) {
            this(hash, Arrays.asList(AbstractSpecialisedImmutableMap.entryOf(key0, valColl0), AbstractSpecialisedImmutableMap.entryOf(key1, valColl1)));
        }

        HashCollisionNode(int hash, List<Map.Entry<K, Set.Immutable<V>>> collisionContent) {
            this.hash = hash;
            this.collisionContent = collisionContent;
        }

        @Override
        public ArrayView<AbstractSetMultimapNode<K, V>> nodeArray() {
            return ArrayView.empty();
        }

        public boolean equals(Object other) {
            if (null == other) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            HashCollisionNode that = (HashCollisionNode)other;
            if (this.hash != that.hash) {
                return false;
            }
            if (this.collisionContent.size() != that.collisionContent.size()) {
                return false;
            }
            return this.collisionContent.stream().allMatch(that.collisionContent::contains);
        }

        @Override
        public byte sizePredicate() {
            return 2;
        }

        @Override
        boolean hasNodes() {
            return false;
        }

        @Override
        int nodeArity() {
            return 0;
        }

        @Override
        CompactSetMultimapNode<K, V> getNode(int index) {
            throw UOE;
        }

        @Override
        boolean hasPayload(EitherSingletonOrCollection.Type type) {
            switch (type) {
                case SINGLETON: {
                    return this.collisionContent.stream().filter(kImmutableSetEntry -> ((Set.Immutable)kImmutableSetEntry.getValue()).size() == 1).findAny().isPresent();
                }
                case COLLECTION: {
                    return this.collisionContent.stream().filter(kImmutableSetEntry -> ((Set.Immutable)kImmutableSetEntry.getValue()).size() >= 2).findAny().isPresent();
                }
            }
            throw new RuntimeException();
        }

        @Override
        int payloadArity(EitherSingletonOrCollection.Type type) {
            switch (type) {
                case SINGLETON: {
                    return (int)this.collisionContent.stream().filter(kImmutableSetEntry -> ((Set.Immutable)kImmutableSetEntry.getValue()).size() == 1).count();
                }
                case COLLECTION: {
                    return (int)this.collisionContent.stream().filter(kImmutableSetEntry -> ((Set.Immutable)kImmutableSetEntry.getValue()).size() >= 2).count();
                }
            }
            throw new RuntimeException();
        }

        @Override
        K getSingletonKey(int index) {
            return this.collisionContent.stream().filter(kImmutableSetEntry -> ((Set.Immutable)kImmutableSetEntry.getValue()).size() == 1).skip(index).findAny().get().getKey();
        }

        @Override
        V getSingletonValue(int index) {
            return (V)((Set.Immutable)this.collisionContent.stream().filter(kImmutableSetEntry -> ((Set.Immutable)kImmutableSetEntry.getValue()).size() == 1).skip(index).findAny().get().getValue()).stream().findAny().get();
        }

        @Override
        K getCollectionKey(int index) {
            return this.collisionContent.stream().filter(kImmutableSetEntry -> ((Set.Immutable)kImmutableSetEntry.getValue()).size() >= 2).skip(index).findAny().get().getKey();
        }

        @Override
        Set.Immutable<V> getCollectionValue(int index) {
            return (Set.Immutable)this.collisionContent.stream().filter(kImmutableSetEntry -> ((Set.Immutable)kImmutableSetEntry.getValue()).size() >= 2).skip(index).findAny().get().getValue();
        }

        @Override
        boolean hasSlots() {
            return true;
        }

        @Override
        int slotArity() {
            return this.collisionContent.size() * 2;
        }

        @Override
        Object getSlot(int index) {
            if (index % 2 == 0) {
                return this.collisionContent.get(index / 2).getKey();
            }
            return this.collisionContent.get(index / 2).getValue();
        }

        @Override
        public boolean containsKey(K key, int keyHash, int shift, EqualityComparator<Object> cmp) {
            return this.collisionContent.stream().filter(entry -> cmp.equals(key, entry.getKey())).findAny().isPresent();
        }

        @Override
        public boolean containsTuple(K key, V value, int keyHash, int shift, EqualityComparator<Object> cmp) {
            return this.collisionContent.stream().filter(entry -> cmp.equals(key, entry.getKey()) && ((Set.Immutable)entry.getValue()).containsEquivalent(value, cmp)).findAny().isPresent();
        }

        @Override
        public final Optional<Set.Immutable<V>> findByKey(K key, int keyHash, int shift, EqualityComparator<Object> cmp) {
            return this.collisionContent.stream().filter(entry -> cmp.equals(key, entry.getKey())).findAny().map(Map.Entry::getValue);
        }

        @Override
        public AbstractSetMultimapNode<K, V> insertedSingle(AtomicReference<Thread> mutator, K key, V value, int keyHash, int shift, MultimapResult<K, V, Set.Immutable<V>> details, EqualityComparator<Object> cmp) {
            Optional<Map.Entry> optionalTuple = this.collisionContent.stream().filter(entry -> cmp.equals(key, entry.getKey())).findAny();
            if (optionalTuple.isPresent()) {
                Set.Immutable values = (Set.Immutable)optionalTuple.get().getValue();
                if (values.containsEquivalent(value, cmp)) {
                    return this;
                }
                Function<Map.Entry, Map.Entry> substitutionMapper = kImmutableSetEntry -> {
                    if (kImmutableSetEntry == optionalTuple.get()) {
                        Set.Immutable<Object> updatedValues = values.__insertEquivalent(value, cmp);
                        return AbstractSpecialisedImmutableMap.entryOf(key, updatedValues);
                    }
                    return kImmutableSetEntry;
                };
                List<Map.Entry<K, Set.Immutable<V>>> updatedCollisionContent = this.collisionContent.stream().map(substitutionMapper).collect(Collectors.toList());
                assert (updatedCollisionContent.size() == this.collisionContent.size());
                assert (!updatedCollisionContent.contains(optionalTuple.get()));
                assert (updatedCollisionContent.stream().filter(entry -> cmp.equals(key, entry.getKey()) && ((Set.Immutable)entry.getValue()).containsEquivalent(value, cmp)).findAny().isPresent());
                details.modified(MultimapResult.Modification.INSERTED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.INSERTED_VALUE), 1);
                return new HashCollisionNode<K, V>(this.hash, updatedCollisionContent);
            }
            Stream.Builder<Map.Entry<K, Set.Immutable<V>>> builder = Stream.builder().add(AbstractSpecialisedImmutableMap.entryOf(key, Set.Immutable.of(value)));
            this.collisionContent.forEach(builder::accept);
            List<Map.Entry<K, Set.Immutable<V>>> updatedCollisionContent = builder.build().collect(Collectors.toList());
            assert (updatedCollisionContent.size() == this.collisionContent.size() + 1);
            assert (updatedCollisionContent.containsAll(this.collisionContent));
            assert (updatedCollisionContent.stream().filter(entry -> cmp.equals(key, entry.getKey()) && Objects.equals(Set.Immutable.of(value), entry.getValue())).findAny().isPresent());
            details.modified(MultimapResult.Modification.INSERTED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.INSERTED_KEY, MultimapResult.Modification.INSERTED_VALUE), 1);
            return new HashCollisionNode<K, V>(this.hash, updatedCollisionContent);
        }

        @Override
        public AbstractSetMultimapNode<K, V> updatedSingle(AtomicReference<Thread> mutator, K key, V value, int keyHash, int shift, MultimapResult<K, V, Set.Immutable<V>> details, EqualityComparator<Object> cmp) {
            Optional<Map.Entry> optionalTuple = this.collisionContent.stream().filter(entry -> cmp.equals(key, entry.getKey())).findAny();
            if (optionalTuple.isPresent()) {
                Set.Immutable values = (Set.Immutable)optionalTuple.get().getValue();
                Function<Map.Entry, Map.Entry> substitutionMapper = kImmutableSetEntry -> {
                    if (kImmutableSetEntry == optionalTuple.get()) {
                        Set.Immutable<Object> updatedValues = values.__insertEquivalent(value, cmp);
                        return AbstractSpecialisedImmutableMap.entryOf(key, updatedValues);
                    }
                    return kImmutableSetEntry;
                };
                List<Map.Entry<K, Set.Immutable<V>>> updatedCollisionContent = this.collisionContent.stream().map(substitutionMapper).collect(Collectors.toList());
                if (values.size() == 1) {
                    details.modified(MultimapResult.Modification.REPLACED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.REPLACED_VALUE), values);
                } else {
                    details.modified(MultimapResult.Modification.REPLACED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.REPLACED_VALUE_COLLECTION), values);
                }
                return new HashCollisionNode<K, V>(this.hash, updatedCollisionContent);
            }
            Stream.Builder<Map.Entry<K, Set.Immutable<V>>> builder = Stream.builder().add(AbstractSpecialisedImmutableMap.entryOf(key, Set.Immutable.of(value)));
            this.collisionContent.forEach(builder::accept);
            List<Map.Entry<K, Set.Immutable<V>>> updatedCollisionContent = builder.build().collect(Collectors.toList());
            details.modified(MultimapResult.Modification.INSERTED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.INSERTED_KEY, MultimapResult.Modification.INSERTED_VALUE));
            return new HashCollisionNode<K, V>(this.hash, updatedCollisionContent);
        }

        @Override
        public AbstractSetMultimapNode<K, V> removed(AtomicReference<Thread> mutator, K key, V value, int keyHash, int shift, MultimapResult<K, V, Set.Immutable<V>> details, EqualityComparator<Object> cmp) {
            Set.Immutable values;
            Optional<Map.Entry> optionalTuple = this.collisionContent.stream().filter(entry -> cmp.equals(key, entry.getKey())).findAny();
            if (optionalTuple.isPresent() && (values = (Set.Immutable)optionalTuple.get().getValue()).containsEquivalent(value, cmp)) {
                if (values.size() == 1) {
                    List<Map.Entry<K, Set.Immutable<V>>> updatedCollisionContent = this.collisionContent.stream().filter(kImmutableSetEntry -> kImmutableSetEntry != optionalTuple.get()).collect(Collectors.toList());
                    details.modified(MultimapResult.Modification.REMOVED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.REMOVED_KEY, MultimapResult.Modification.REMOVED_VALUE));
                    return new HashCollisionNode<K, V>(this.hash, updatedCollisionContent);
                }
                Function<Map.Entry, Map.Entry> substitutionMapper = kImmutableSetEntry -> {
                    if (kImmutableSetEntry == optionalTuple.get()) {
                        Set.Immutable<Object> updatedValues = values.__removeEquivalent(value, cmp);
                        return AbstractSpecialisedImmutableMap.entryOf(key, updatedValues);
                    }
                    return kImmutableSetEntry;
                };
                List<Map.Entry<K, Set.Immutable<V>>> updatedCollisionContent = this.collisionContent.stream().map(substitutionMapper).collect(Collectors.toList());
                details.modified(MultimapResult.Modification.REMOVED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.REMOVED_VALUE));
                return new HashCollisionNode<K, V>(this.hash, updatedCollisionContent);
            }
            return this;
        }

        @Override
        public AbstractSetMultimapNode<K, V> removed(AtomicReference<Thread> mutator, K key, int keyHash, int shift, MultimapResult<K, V, Set.Immutable<V>> details, EqualityComparator<Object> cmp) {
            Optional<Map.Entry> optionalTuple = this.collisionContent.stream().filter(entry -> cmp.equals(key, entry.getKey())).findAny();
            if (optionalTuple.isPresent()) {
                Set.Immutable values = (Set.Immutable)optionalTuple.get().getValue();
                List<Map.Entry<K, Set.Immutable<V>>> updatedCollisionContent = this.collisionContent.stream().filter(kImmutableSetEntry -> kImmutableSetEntry != optionalTuple.get()).collect(Collectors.toList());
                if (values.size() == 1) {
                    details.modified(MultimapResult.Modification.REMOVED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.REMOVED_KEY, MultimapResult.Modification.REMOVED_VALUE), values);
                    return new HashCollisionNode<K, V>(this.hash, updatedCollisionContent);
                }
                details.modified(MultimapResult.Modification.REMOVED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.REMOVED_KEY, MultimapResult.Modification.REMOVED_VALUE_COLLECTION), values);
                return new HashCollisionNode<K, V>(this.hash, updatedCollisionContent);
            }
            return this;
        }
    }

    private static abstract class AbstractHashCollisionNode<K, V>
    extends CompactSetMultimapNode<K, V> {
        private static final RuntimeException UOE_BOILERPLATE = new UnsupportedOperationException("TODO: CompactSetMultimapNode -> AbstractSetMultimapNode");
        private static final Supplier<RuntimeException> UOE_FACTORY = () -> new UnsupportedOperationException("TODO: CompactSetMultimapNode -> AbstractSetMultimapNode");

        private AbstractHashCollisionNode() {
        }

        static final <K, V, VS extends Set.Immutable<V>> AbstractHashCollisionNode<K, V> of(int hash, K key0, VS valColl0, K key1, VS valColl1) {
            return new HashCollisionNode(hash, key0, valColl0, key1, valColl1);
        }

        @Override
        int bitmap(int category) {
            throw UOE_FACTORY.get();
        }

        @Override
        int dataMap() {
            throw UOE_FACTORY.get();
        }

        @Override
        int collMap() {
            throw UOE_FACTORY.get();
        }

        @Override
        int nodeMap() {
            throw UOE_FACTORY.get();
        }

        @Override
        int rawMap1() {
            throw UOE_FACTORY.get();
        }

        @Override
        int rawMap2() {
            throw UOE_FACTORY.get();
        }

        public CompactSetMultimapNode<K, V> copyAndUpdateBitmaps(AtomicReference<Thread> mutator, int rawMap1, int rawMap2) {
            throw UOE_FACTORY.get();
        }

        @Override
        CompactSetMultimapNode<K, V> copyAndSetSingletonValue(AtomicReference<Thread> mutator, int bitpos, V val) {
            throw UOE_FACTORY.get();
        }

        @Override
        CompactSetMultimapNode<K, V> copyAndSetCollectionValue(AtomicReference<Thread> mutator, int bitpos, Set.Immutable<V> valColl) {
            throw UOE_FACTORY.get();
        }

        @Override
        CompactSetMultimapNode<K, V> copyAndSetNode(AtomicReference<Thread> mutator, int bitpos, AbstractSetMultimapNode<K, V> node) {
            throw UOE_FACTORY.get();
        }

        @Override
        CompactSetMultimapNode<K, V> copyAndInsertSingleton(AtomicReference<Thread> mutator, int bitpos, K key, V val) {
            throw UOE_FACTORY.get();
        }

        @Override
        CompactSetMultimapNode<K, V> copyAndInsertCollection(AtomicReference<Thread> mutator, int bitpos, K key, Set.Immutable<V> values) {
            throw UOE_FACTORY.get();
        }

        @Override
        CompactSetMultimapNode<K, V> copyAndMigrateFromSingletonToCollection(AtomicReference<Thread> mutator, int bitpos, K key, Set.Immutable<V> valColl) {
            throw UOE_FACTORY.get();
        }

        @Override
        CompactSetMultimapNode<K, V> copyAndRemoveSingleton(AtomicReference<Thread> mutator, int bitpos) {
            throw UOE_FACTORY.get();
        }

        @Override
        CompactSetMultimapNode<K, V> copyAndRemoveCollection(AtomicReference<Thread> mutator, int bitpos) {
            throw UOE_FACTORY.get();
        }

        @Override
        CompactSetMultimapNode<K, V> copyAndMigrateFromSingletonToNode(AtomicReference<Thread> mutator, int bitpos, AbstractSetMultimapNode<K, V> node) {
            throw UOE_FACTORY.get();
        }

        @Override
        CompactSetMultimapNode<K, V> copyAndMigrateFromNodeToSingleton(AtomicReference<Thread> mutator, int bitpos, AbstractSetMultimapNode<K, V> node) {
            throw UOE_FACTORY.get();
        }

        @Override
        CompactSetMultimapNode<K, V> copyAndMigrateFromCollectionToNode(AtomicReference<Thread> mutator, int bitpos, AbstractSetMultimapNode<K, V> node) {
            throw UOE_FACTORY.get();
        }

        @Override
        CompactSetMultimapNode<K, V> copyAndMigrateFromNodeToCollection(AtomicReference<Thread> mutator, int bitpos, AbstractSetMultimapNode<K, V> node) {
            throw UOE_FACTORY.get();
        }

        @Override
        CompactSetMultimapNode<K, V> copyAndMigrateFromCollectionToSingleton(AtomicReference<Thread> mutator, int bitpos, K key, V val) {
            throw UOE_FACTORY.get();
        }

        @Override
        public EitherSingletonOrCollection.Type typeOfSingleton() {
            throw UOE_FACTORY.get();
        }

        @Override
        CompactSetMultimapNode<K, V> canonicalize(AtomicReference<Thread> mutator, int keyHash, int shift) {
            throw UOE_FACTORY.get();
        }
    }

    private static final class BitmapIndexedSetMultimapNode<K, V>
    extends CompactMixedSetMultimapNode<K, V> {
        final transient AtomicReference<Thread> mutator;
        final Object[] nodes;

        private BitmapIndexedSetMultimapNode(AtomicReference<Thread> mutator, int rawMap1, int rawMap2, Object[] nodes) {
            super(mutator, rawMap1, rawMap2);
            this.mutator = mutator;
            this.nodes = nodes;
            assert (this.nodeInvariant());
        }

        @Override
        public ArrayView<AbstractSetMultimapNode<K, V>> nodeArray() {
            return new ArrayView<AbstractSetMultimapNode<K, V>>(){

                @Override
                public int size() {
                    return this.nodeArity();
                }

                @Override
                public AbstractSetMultimapNode<K, V> get(int index) {
                    return this.getNode(index);
                }

                @Override
                public void set(int index, AbstractSetMultimapNode<K, V> item) {
                    nodes[nodes.length - 1 - index] = item;
                }

                @Override
                public void set(int index, AbstractSetMultimapNode<K, V> item, AtomicReference<?> writeCapabilityToken) {
                    if (!AbstractSetMultimapNode.isAllowedToEdit(mutator, writeCapabilityToken)) {
                        throw new IllegalStateException();
                    }
                    nodes[nodes.length - 1 - index] = item;
                }
            };
        }

        @Override
        K getSingletonKey(int index) {
            return (K)this.nodes[2 * index];
        }

        @Override
        V getSingletonValue(int index) {
            return (V)this.nodes[2 * index + 1];
        }

        @Override
        K getCollectionKey(int index) {
            int offset = 2 * (BitmapIndexedSetMultimapNode.arity(this.dataMap()) + index);
            return (K)this.nodes[offset];
        }

        @Override
        Set.Immutable<V> getCollectionValue(int index) {
            int offset = 2 * (BitmapIndexedSetMultimapNode.arity(this.dataMap()) + index) + 1;
            return (Set.Immutable)this.nodes[offset];
        }

        @Override
        CompactSetMultimapNode<K, V> getNode(int index) {
            return (CompactSetMultimapNode)this.nodes[this.nodes.length - 1 - index];
        }

        @Override
        boolean hasPayload(EitherSingletonOrCollection.Type type) {
            return this.payloadArity(type) != 0;
        }

        @Override
        int payloadArity(EitherSingletonOrCollection.Type type) {
            if (type == EitherSingletonOrCollection.Type.SINGLETON) {
                return Integer.bitCount(this.dataMap());
            }
            return Integer.bitCount(this.collMap());
        }

        @Override
        boolean hasNodes() {
            return this.nodeArity() != 0;
        }

        @Override
        int nodeArity() {
            return Integer.bitCount(this.nodeMap());
        }

        @Override
        Object getSlot(int index) {
            return this.nodes[index];
        }

        private <T> Iterator<T> ziperator(final int expectedSize, final int bitmap0, final Iterator<T> dataIterator0, final int bitmap1, final Iterator<T> dataIterator1) {
            return new Iterator<T>(){
                private int encounteredSize = 0;
                private int bitsToSkip = 0;

                @Override
                public boolean hasNext() {
                    return this.encounteredSize < expectedSize;
                }

                @Override
                public T next() {
                    ++this.encounteredSize;
                    int trailingZeroCount0 = Integer.numberOfTrailingZeros(bitmap0 >> this.bitsToSkip);
                    int trailingZeroCount1 = Integer.numberOfTrailingZeros(bitmap1 >> this.bitsToSkip);
                    this.bitsToSkip = this.bitsToSkip + 1 + Math.min(trailingZeroCount0, trailingZeroCount1);
                    if (trailingZeroCount0 < trailingZeroCount1) {
                        return dataIterator0.next();
                    }
                    return dataIterator1.next();
                }
            };
        }

        @Override
        boolean hasSlots() {
            return this.nodes.length != 0;
        }

        @Override
        int slotArity() {
            return this.nodes.length;
        }

        public int hashCode() {
            int prime = 31;
            int result = 0;
            result = 31 * result + this.rawMap1();
            result = 31 * result + this.rawMap2();
            result = 31 * result + Arrays.hashCode(this.nodes);
            return result;
        }

        public boolean equals(Object other) {
            if (null == other) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            BitmapIndexedSetMultimapNode that = (BitmapIndexedSetMultimapNode)other;
            if (this.rawMap1() != that.rawMap1()) {
                return false;
            }
            if (this.rawMap2() != that.rawMap2()) {
                return false;
            }
            return ArrayUtils.equals(this.nodes, that.nodes);
        }

        @Override
        public byte sizePredicate() {
            if (this.nodeArity() == 0) {
                switch (BitmapIndexedSetMultimapNode.arity(this.dataMap()) + BitmapIndexedSetMultimapNode.arity(this.collMap())) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                }
                return 2;
            }
            return 2;
        }

        @Override
        CompactSetMultimapNode<K, V> copyAndSetSingletonValue(AtomicReference<Thread> mutator, int bitpos, V val) {
            int idx = 2 * this.dataIndex(bitpos) + 1;
            CompactSetMultimapNode<K, V> updatedNode = this.copyAndSetXxxValue(mutator, idx, val);
            return updatedNode;
        }

        @Override
        CompactSetMultimapNode<K, V> copyAndSetCollectionValue(AtomicReference<Thread> mutator, int bitpos, Set.Immutable<V> valColl) {
            int idx = 2 * (BitmapIndexedSetMultimapNode.arity(this.dataMap()) + this.collIndex(bitpos)) + 1;
            CompactSetMultimapNode<K, V> updatedNode = this.copyAndSetXxxValue(mutator, idx, valColl);
            return updatedNode;
        }

        private CompactSetMultimapNode<K, V> copyAndSetXxxValue(AtomicReference<Thread> mutator, int idx, Object newValue) {
            CompactSetMultimapNode updatedNode;
            if (BitmapIndexedSetMultimapNode.isAllowedToEdit(this.mutator, mutator)) {
                this.nodes[idx] = newValue;
                updatedNode = this;
            } else {
                Object[] src = this.nodes;
                Object[] dst = new Object[src.length];
                System.arraycopy(src, 0, dst, 0, src.length);
                dst[idx + 0] = newValue;
                updatedNode = BitmapIndexedSetMultimapNode.nodeOf(mutator, this.rawMap1(), this.rawMap2(), dst);
            }
            return updatedNode;
        }

        @Override
        CompactSetMultimapNode<K, V> copyAndSetNode(AtomicReference<Thread> mutator, int bitpos, AbstractSetMultimapNode<K, V> node) {
            int idx = this.nodes.length - 1 - this.nodeIndex(bitpos);
            if (BitmapIndexedSetMultimapNode.isAllowedToEdit(this.mutator, mutator)) {
                this.nodes[idx] = node;
                return this;
            }
            Object[] src = this.nodes;
            Object[] dst = new Object[src.length];
            System.arraycopy(src, 0, dst, 0, src.length);
            dst[idx + 0] = node;
            return BitmapIndexedSetMultimapNode.nodeOf(mutator, this.rawMap1(), this.rawMap2(), dst);
        }

        @Override
        CompactSetMultimapNode<K, V> copyAndInsertSingleton(AtomicReference<Thread> mutator, int bitpos, K key, V val) {
            int idx = 2 * this.dataIndex(bitpos);
            Object[] src = this.nodes;
            Object[] dst = new Object[src.length + 2];
            System.arraycopy(src, 0, dst, 0, idx);
            dst[idx + 0] = key;
            dst[idx + 1] = val;
            System.arraycopy(src, idx, dst, idx + 2, src.length - idx);
            return BitmapIndexedSetMultimapNode.nodeOf(mutator, this.rawMap1(), this.rawMap2() | bitpos, dst);
        }

        @Override
        CompactSetMultimapNode<K, V> copyAndInsertCollection(AtomicReference<Thread> mutator, int bitpos, K key, Set.Immutable<V> valColl) {
            int idx = 2 * (BitmapIndexedSetMultimapNode.arity(this.dataMap()) + this.collIndex(bitpos));
            Object[] src = this.nodes;
            Object[] dst = new Object[src.length + 2];
            System.arraycopy(src, 0, dst, 0, idx);
            dst[idx + 0] = key;
            dst[idx + 1] = valColl;
            System.arraycopy(src, idx, dst, idx + 2, src.length - idx);
            return BitmapIndexedSetMultimapNode.nodeOf(mutator, this.rawMap1() | bitpos, this.rawMap2() | bitpos, dst);
        }

        @Override
        CompactSetMultimapNode<K, V> copyAndMigrateFromSingletonToCollection(AtomicReference<Thread> mutator, int bitpos, K key, Set.Immutable<V> valColl) {
            int idxOld = 2 * BitmapIndexedSetMultimapNode.index(this.dataMap(), bitpos);
            int idxNew = 2 * (BitmapIndexedSetMultimapNode.arity(this.dataMap()) - 1 + BitmapIndexedSetMultimapNode.index(this.collMap(), bitpos));
            Object[] src = this.nodes;
            Object[] dst = new Object[src.length];
            assert (idxOld <= idxNew);
            System.arraycopy(src, 0, dst, 0, idxOld);
            System.arraycopy(src, idxOld + 2, dst, idxOld, idxNew - idxOld);
            dst[idxNew + 0] = key;
            dst[idxNew + 1] = valColl;
            System.arraycopy(src, idxNew + 2, dst, idxNew + 2, src.length - idxNew - 2);
            return BitmapIndexedSetMultimapNode.nodeOf(mutator, this.rawMap1() | bitpos, this.rawMap2() | bitpos, dst);
        }

        @Override
        CompactSetMultimapNode<K, V> copyAndMigrateFromCollectionToSingleton(AtomicReference<Thread> mutator, int bitpos, K key, V val) {
            int idxOld = 2 * (BitmapIndexedSetMultimapNode.arity(this.dataMap()) + BitmapIndexedSetMultimapNode.index(this.collMap(), bitpos));
            int idxNew = 2 * BitmapIndexedSetMultimapNode.index(this.dataMap(), bitpos);
            Object[] src = this.nodes;
            Object[] dst = new Object[src.length];
            assert (idxNew <= idxOld);
            System.arraycopy(src, 0, dst, 0, idxNew);
            dst[idxNew + 0] = key;
            dst[idxNew + 1] = val;
            System.arraycopy(src, idxNew, dst, idxNew + 2, idxOld - idxNew);
            System.arraycopy(src, idxOld + 2, dst, idxOld + 2, src.length - idxOld - 2);
            return BitmapIndexedSetMultimapNode.nodeOf(mutator, this.rawMap1() ^ bitpos, this.rawMap2() | bitpos, dst);
        }

        @Override
        CompactSetMultimapNode<K, V> copyAndRemoveSingleton(AtomicReference<Thread> mutator, int bitpos) {
            int idx = 2 * this.dataIndex(bitpos);
            Object[] src = this.nodes;
            Object[] dst = new Object[src.length - 2];
            System.arraycopy(src, 0, dst, 0, idx);
            System.arraycopy(src, idx + 2, dst, idx, src.length - idx - 2);
            return BitmapIndexedSetMultimapNode.nodeOf(mutator, this.rawMap1(), this.rawMap2() ^ bitpos, dst);
        }

        @Override
        CompactSetMultimapNode<K, V> copyAndRemoveCollection(AtomicReference<Thread> mutator, int bitpos) {
            int idx = 2 * (BitmapIndexedSetMultimapNode.arity(this.dataMap()) + this.collIndex(bitpos));
            Object[] src = this.nodes;
            Object[] dst = new Object[src.length - 2];
            System.arraycopy(src, 0, dst, 0, idx);
            System.arraycopy(src, idx + 2, dst, idx, src.length - idx - 2);
            return BitmapIndexedSetMultimapNode.nodeOf(mutator, this.rawMap1() ^ bitpos, this.rawMap2() ^ bitpos, dst);
        }

        @Override
        CompactSetMultimapNode<K, V> copyAndMigrateFromSingletonToNode(AtomicReference<Thread> mutator, int bitpos, AbstractSetMultimapNode<K, V> node) {
            int idxOld = 2 * this.dataIndex(bitpos);
            int idxNew = this.nodes.length - 2 - this.nodeIndex(bitpos);
            Object[] dst = this.copyAndMigrateFromXxxToNode(idxOld, idxNew, node);
            return BitmapIndexedSetMultimapNode.nodeOf(mutator, this.rawMap1() | bitpos, this.rawMap2() ^ bitpos, dst);
        }

        @Override
        CompactSetMultimapNode<K, V> copyAndMigrateFromCollectionToNode(AtomicReference<Thread> mutator, int bitpos, AbstractSetMultimapNode<K, V> node) {
            int idxOld = 2 * (BitmapIndexedSetMultimapNode.arity(this.dataMap()) + BitmapIndexedSetMultimapNode.index(this.collMap(), bitpos));
            int idxNew = this.nodes.length - 2 - this.nodeIndex(bitpos);
            Object[] dst = this.copyAndMigrateFromXxxToNode(idxOld, idxNew, node);
            return BitmapIndexedSetMultimapNode.nodeOf(mutator, this.rawMap1() | bitpos, this.rawMap2() ^ bitpos, dst);
        }

        private Object[] copyAndMigrateFromXxxToNode(int idxOld, int idxNew, AbstractSetMultimapNode<K, V> node) {
            Object[] src = this.nodes;
            Object[] dst = new Object[src.length - 2 + 1];
            assert (idxOld <= idxNew);
            System.arraycopy(src, 0, dst, 0, idxOld);
            System.arraycopy(src, idxOld + 2, dst, idxOld, idxNew - idxOld);
            dst[idxNew + 0] = node;
            System.arraycopy(src, idxNew + 2, dst, idxNew + 1, src.length - idxNew - 2);
            return dst;
        }

        @Override
        CompactSetMultimapNode<K, V> copyAndMigrateFromNodeToSingleton(AtomicReference<Thread> mutator, int bitpos, AbstractSetMultimapNode<K, V> node) {
            int idxOld = this.nodes.length - 1 - this.nodeIndex(bitpos);
            int idxNew = 2 * this.dataIndex(bitpos);
            K keyToInline = node.getSingletonKey(0);
            V valToInline = node.getSingletonValue(0);
            Object[] dst = this.copyAndMigrateFromNodeToXxx(idxOld, idxNew, keyToInline, valToInline);
            return BitmapIndexedSetMultimapNode.nodeOf(mutator, this.rawMap1() ^ bitpos, this.rawMap2() | bitpos, dst);
        }

        @Override
        CompactSetMultimapNode<K, V> copyAndMigrateFromNodeToCollection(AtomicReference<Thread> mutator, int bitpos, AbstractSetMultimapNode<K, V> node) {
            int idxOld = this.nodes.length - 1 - this.nodeIndex(bitpos);
            int idxNew = 2 * (BitmapIndexedSetMultimapNode.arity(this.dataMap()) + BitmapIndexedSetMultimapNode.index(this.collMap(), bitpos));
            K keyToInline = node.getCollectionKey(0);
            Set.Immutable<V> valToInline = node.getCollectionValue(0);
            Object[] dst = this.copyAndMigrateFromNodeToXxx(idxOld, idxNew, keyToInline, valToInline);
            return BitmapIndexedSetMultimapNode.nodeOf(mutator, this.rawMap1() | bitpos, this.rawMap2() | bitpos, dst);
        }

        private Object[] copyAndMigrateFromNodeToXxx(int idxOld, int idxNew, Object keyToInline, Object valToInline) {
            Object[] src = this.nodes;
            Object[] dst = new Object[src.length - 1 + 2];
            assert (idxOld >= idxNew);
            System.arraycopy(src, 0, dst, 0, idxNew);
            dst[idxNew + 0] = keyToInline;
            dst[idxNew + 1] = valToInline;
            System.arraycopy(src, idxNew, dst, idxNew + 2, idxOld - idxNew);
            System.arraycopy(src, idxOld + 1, dst, idxOld + 2, src.length - idxOld - 1);
            return dst;
        }

        public CompactSetMultimapNode<K, V> copyAndUpdateBitmaps(AtomicReference<Thread> mutator, int rawMap1, int rawMap2) {
            return BitmapIndexedSetMultimapNode.nodeOf(mutator, rawMap1, rawMap2, this.nodes);
        }

        @Override
        public EitherSingletonOrCollection.Type typeOfSingleton() {
            int rawMap2;
            assert (this.sizePredicate() == 1);
            int rawMap1 = this.rawMap1();
            if (rawMap1 != (rawMap2 = this.rawMap2())) {
                return EitherSingletonOrCollection.Type.SINGLETON;
            }
            return EitherSingletonOrCollection.Type.COLLECTION;
        }

        @Override
        CompactSetMultimapNode<K, V> canonicalize(AtomicReference<Thread> mutator, int keyHash, int shift) {
            if (shift > 0) {
                boolean containsPaylaod;
                int rawMap1 = this.rawMap1();
                int rawMap2 = this.rawMap2();
                boolean slotCountEqualsTupleLength = this.nodes.length == 2;
                boolean bl = containsPaylaod = rawMap2 != 0;
                if (slotCountEqualsTupleLength && containsPaylaod) {
                    int newBitmap = BitmapIndexedSetMultimapNode.bitpos(BitmapIndexedSetMultimapNode.mask(keyHash, 0));
                    if (rawMap1 != rawMap2) {
                        return this.copyAndUpdateBitmaps(mutator, 0, newBitmap);
                    }
                    return this.copyAndUpdateBitmaps(mutator, newBitmap, newBitmap);
                }
            }
            return this;
        }
    }

    protected static abstract class CompactMixedSetMultimapNode<K, V>
    extends CompactSetMultimapNode<K, V> {
        private final int rawMap1;
        private final int rawMap2;

        CompactMixedSetMultimapNode(AtomicReference<Thread> mutator, int nodeMap, int dataMap) {
            this.rawMap1 = nodeMap;
            this.rawMap2 = dataMap;
        }

        @Override
        public final int rawMap1() {
            return this.rawMap1;
        }

        @Override
        public final int rawMap2() {
            return this.rawMap2;
        }

        @Override
        final int bitmap(int category) {
            switch (category) {
                case 0: {
                    return this.dataMap();
                }
                case 1: {
                    return this.collMap();
                }
            }
            return 0;
        }

        @Override
        final int dataMap() {
            return this.rawMap2() ^ this.collMap();
        }

        @Override
        final int collMap() {
            return this.rawMap1() & this.rawMap2();
        }

        @Override
        final int nodeMap() {
            return this.rawMap1() ^ this.collMap();
        }
    }

    protected static abstract class CompactSetMultimapNode<K, V>
    extends AbstractSetMultimapNode<K, V> {
        static final int HASH_CODE_LENGTH = 32;
        static final int BIT_PARTITION_SIZE = 5;
        static final int BIT_PARTITION_MASK = 31;
        static final CompactSetMultimapNode EMPTY_NODE = new BitmapIndexedSetMultimapNode(null, 0, 0, new Object[0]);

        protected CompactSetMultimapNode() {
        }

        static final int mask(int keyHash, int shift) {
            return keyHash >>> shift & 0x1F;
        }

        static final int bitpos(int mask) {
            return 1 << mask;
        }

        abstract int bitmap(int var1);

        @Deprecated
        abstract int dataMap();

        @Deprecated
        abstract int collMap();

        @Deprecated
        abstract int nodeMap();

        abstract int rawMap1();

        abstract int rawMap2();

        @Override
        @Deprecated
        int arity() {
            return CompactSetMultimapNode.arity(this.dataMap()) + CompactSetMultimapNode.arity(this.collMap()) + CompactSetMultimapNode.arity(this.nodeMap());
        }

        static final int arity(int bitmap) {
            if (bitmap == 0) {
                return 0;
            }
            return Integer.bitCount(bitmap);
        }

        @Override
        abstract CompactSetMultimapNode<K, V> getNode(int var1);

        boolean nodeInvariant() {
            return true;
        }

        abstract CompactSetMultimapNode<K, V> copyAndSetSingletonValue(AtomicReference<Thread> var1, int var2, V var3);

        abstract CompactSetMultimapNode<K, V> copyAndSetCollectionValue(AtomicReference<Thread> var1, int var2, Set.Immutable<V> var3);

        abstract CompactSetMultimapNode<K, V> copyAndSetNode(AtomicReference<Thread> var1, int var2, AbstractSetMultimapNode<K, V> var3);

        abstract CompactSetMultimapNode<K, V> copyAndInsertSingleton(AtomicReference<Thread> var1, int var2, K var3, V var4);

        abstract CompactSetMultimapNode<K, V> copyAndInsertCollection(AtomicReference<Thread> var1, int var2, K var3, Set.Immutable<V> var4);

        abstract CompactSetMultimapNode<K, V> copyAndMigrateFromSingletonToCollection(AtomicReference<Thread> var1, int var2, K var3, Set.Immutable<V> var4);

        abstract CompactSetMultimapNode<K, V> copyAndRemoveSingleton(AtomicReference<Thread> var1, int var2);

        abstract CompactSetMultimapNode<K, V> copyAndRemoveCollection(AtomicReference<Thread> var1, int var2);

        abstract CompactSetMultimapNode<K, V> copyAndMigrateFromSingletonToNode(AtomicReference<Thread> var1, int var2, AbstractSetMultimapNode<K, V> var3);

        abstract CompactSetMultimapNode<K, V> copyAndMigrateFromNodeToSingleton(AtomicReference<Thread> var1, int var2, AbstractSetMultimapNode<K, V> var3);

        abstract CompactSetMultimapNode<K, V> copyAndMigrateFromCollectionToNode(AtomicReference<Thread> var1, int var2, AbstractSetMultimapNode<K, V> var3);

        abstract CompactSetMultimapNode<K, V> copyAndMigrateFromNodeToCollection(AtomicReference<Thread> var1, int var2, AbstractSetMultimapNode<K, V> var3);

        abstract CompactSetMultimapNode<K, V> copyAndMigrateFromCollectionToSingleton(AtomicReference<Thread> var1, int var2, K var3, V var4);

        static final <K, V> CompactSetMultimapNode<K, V> mergeTwoSingletonPairs(K key0, V val0, int keyHash0, K key1, V val1, int keyHash1, int shift, EqualityComparator<Object> cmp) {
            int mask1;
            if (shift >= 32) {
                return AbstractHashCollisionNode.of(keyHash0, key0, Set.Immutable.of(val0), key1, Set.Immutable.of(val1));
            }
            int mask0 = CompactSetMultimapNode.mask(keyHash0, shift);
            if (mask0 != (mask1 = CompactSetMultimapNode.mask(keyHash1, shift))) {
                boolean rawMap1 = false;
                int rawMap2 = CompactSetMultimapNode.bitpos(mask0) | CompactSetMultimapNode.bitpos(mask1);
                if (mask0 < mask1) {
                    return CompactSetMultimapNode.nodeOf(null, 0, rawMap2, new Object[]{key0, val0, key1, val1});
                }
                return CompactSetMultimapNode.nodeOf(null, 0, rawMap2, new Object[]{key1, val1, key0, val0});
            }
            CompactSetMultimapNode<K, V> node = CompactSetMultimapNode.mergeTwoSingletonPairs(key0, val0, keyHash0, key1, val1, keyHash1, shift + 5, cmp);
            int rawMap1 = CompactSetMultimapNode.bitpos(mask0);
            boolean rawMap2 = false;
            return CompactSetMultimapNode.nodeOf(null, rawMap1, 0, new Object[]{node});
        }

        static final <K, V> CompactSetMultimapNode<K, V> mergeCollectionAndSingletonPairs(K key0, Set.Immutable<V> valColl0, int keyHash0, K key1, V val1, int keyHash1, int shift, EqualityComparator<Object> cmp) {
            int mask1;
            if (shift >= 32) {
                return AbstractHashCollisionNode.of(keyHash0, key1, Set.Immutable.of(val1), key0, valColl0);
            }
            int mask0 = CompactSetMultimapNode.mask(keyHash0, shift);
            if (mask0 != (mask1 = CompactSetMultimapNode.mask(keyHash1, shift))) {
                int rawMap1 = CompactSetMultimapNode.bitpos(mask0);
                int rawMap2 = CompactSetMultimapNode.bitpos(mask0) | CompactSetMultimapNode.bitpos(mask1);
                return CompactSetMultimapNode.nodeOf(null, rawMap1, rawMap2, new Object[]{key1, val1, key0, valColl0});
            }
            CompactSetMultimapNode<K, V> node = CompactSetMultimapNode.mergeCollectionAndSingletonPairs(key0, valColl0, keyHash0, key1, val1, keyHash1, shift + 5, cmp);
            int rawMap1 = CompactSetMultimapNode.bitpos(mask0);
            boolean rawMap2 = false;
            return CompactSetMultimapNode.nodeOf(null, rawMap1, 0, new Object[]{node});
        }

        static final <K, V, C extends Set.Immutable<V>> AbstractSetMultimapNode<K, V> mergeTwoCollectionPairs(K key0, C valColl0, int keyHash0, K key1, C valColl1, int keyHash1, int shift, EqualityComparator<Object> cmp) {
            int mask1;
            assert (!cmp.equals(key0, key1));
            if (shift >= 32) {
                return AbstractHashCollisionNode.of(keyHash0, key1, valColl1, key0, valColl1);
            }
            int mask0 = CompactSetMultimapNode.mask(keyHash0, shift);
            if (mask0 != (mask1 = CompactSetMultimapNode.mask(keyHash1, shift))) {
                int bitmap0;
                int bitmap1 = bitmap0 = 1 << mask0 | 1 << mask1;
                if (mask0 < mask1) {
                    return CompactSetMultimapNode.nodeOf(null, bitmap0, bitmap1, new Object[]{key0, valColl0, key1, valColl1});
                }
                return CompactSetMultimapNode.nodeOf(null, bitmap0, bitmap1, new Object[]{key1, valColl1, key0, valColl0});
            }
            AbstractSetMultimapNode<K, V> node = CompactSetMultimapNode.mergeTwoCollectionPairs(key0, valColl0, keyHash0, key1, valColl1, keyHash1, shift + 5, cmp);
            int bitmap0 = 1 << mask0;
            int bitmap1 = 0;
            return CompactSetMultimapNode.nodeOf(null, bitmap0, bitmap1, new Object[]{node});
        }

        static final <K, V> CompactSetMultimapNode<K, V> nodeOf(AtomicReference<Thread> mutator, int nodeMap, int dataMap, Object[] nodes) {
            return new BitmapIndexedSetMultimapNode(mutator, nodeMap, dataMap, nodes);
        }

        static final <K, V> CompactSetMultimapNode<K, V> nodeOf(AtomicReference<Thread> mutator) {
            return EMPTY_NODE;
        }

        static final <K, V> CompactSetMultimapNode<K, V> nodeOf(AtomicReference<Thread> mutator, int nodeMap, int dataMap, K key, Set.Immutable<V> valColl) {
            assert (nodeMap == 0);
            return CompactSetMultimapNode.nodeOf(mutator, 0, dataMap, new Object[]{key, valColl});
        }

        static final int index(int bitmap, int bitpos) {
            return Integer.bitCount(bitmap & bitpos - 1);
        }

        static final int index(int bitmap, int mask, int bitpos) {
            return bitmap == -1 ? mask : CompactSetMultimapNode.index(bitmap, bitpos);
        }

        @Deprecated
        final int dataIndex(int bitpos) {
            return Integer.bitCount(this.dataMap() & bitpos - 1);
        }

        @Deprecated
        final int collIndex(int bitpos) {
            return Integer.bitCount(this.collMap() & bitpos - 1);
        }

        @Deprecated
        final int nodeIndex(int bitpos) {
            return Integer.bitCount(this.nodeMap() & bitpos - 1);
        }

        @Override
        public boolean containsKey(K key, int keyHash, int shift, EqualityComparator<Object> cmp) {
            int mask = CompactSetMultimapNode.mask(keyHash, shift);
            int bitpos = CompactSetMultimapNode.bitpos(mask);
            int rawMap1 = this.rawMap1();
            int rawMap2 = this.rawMap2();
            int collMap = rawMap1 & rawMap2;
            int dataMap = rawMap2 ^ collMap;
            int nodeMap = rawMap1 ^ collMap;
            if (BitmapUtils.isBitInBitmap(dataMap, bitpos)) {
                int index = CompactSetMultimapNode.index(dataMap, mask, bitpos);
                return cmp.equals(this.getSingletonKey(index), key);
            }
            if (BitmapUtils.isBitInBitmap(collMap, bitpos)) {
                int index = CompactSetMultimapNode.index(collMap, mask, bitpos);
                return cmp.equals(this.getCollectionKey(index), key);
            }
            if (BitmapUtils.isBitInBitmap(nodeMap, bitpos)) {
                int index = CompactSetMultimapNode.index(nodeMap, mask, bitpos);
                return ((CompactSetMultimapNode)this.getNode(index)).containsKey(key, keyHash, shift + 5, cmp);
            }
            return false;
        }

        @Override
        public boolean containsTuple(K key, V value, int keyHash, int shift, EqualityComparator<Object> cmp) {
            int mask = CompactSetMultimapNode.mask(keyHash, shift);
            int bitpos = CompactSetMultimapNode.bitpos(mask);
            int rawMap1 = this.rawMap1();
            int rawMap2 = this.rawMap2();
            int collMap = rawMap1 & rawMap2;
            int dataMap = rawMap2 ^ collMap;
            int nodeMap = rawMap1 ^ collMap;
            if (BitmapUtils.isBitInBitmap(dataMap, bitpos)) {
                int index = CompactSetMultimapNode.index(dataMap, mask, bitpos);
                return cmp.equals(this.getSingletonKey(index), key) && cmp.equals(this.getSingletonValue(index), value);
            }
            if (BitmapUtils.isBitInBitmap(collMap, bitpos)) {
                int index = CompactSetMultimapNode.index(collMap, mask, bitpos);
                return cmp.equals(this.getCollectionKey(index), key) && this.getCollectionValue(index).containsEquivalent(value, cmp);
            }
            if (BitmapUtils.isBitInBitmap(nodeMap, bitpos)) {
                int index = CompactSetMultimapNode.index(nodeMap, mask, bitpos);
                return ((CompactSetMultimapNode)this.getNode(index)).containsTuple(key, value, keyHash, shift + 5, cmp);
            }
            return false;
        }

        @Override
        public Optional<Set.Immutable<V>> findByKey(K key, int keyHash, int shift, EqualityComparator<Object> cmp) {
            int mask = CompactSetMultimapNode.mask(keyHash, shift);
            int bitpos = CompactSetMultimapNode.bitpos(mask);
            int rawMap1 = this.rawMap1();
            int rawMap2 = this.rawMap2();
            int collMap = rawMap1 & rawMap2;
            int dataMap = rawMap2 ^ collMap;
            int nodeMap = rawMap1 ^ collMap;
            if (BitmapUtils.isBitInBitmap(dataMap, bitpos)) {
                int index = CompactSetMultimapNode.index(dataMap, mask, bitpos);
                Object currentKey = this.getSingletonKey(index);
                if (cmp.equals(currentKey, key)) {
                    Object currentVal = this.getSingletonValue(index);
                    return Optional.of(Set.Immutable.of(currentVal));
                }
                return Optional.empty();
            }
            if (BitmapUtils.isBitInBitmap(collMap, bitpos)) {
                int index = CompactSetMultimapNode.index(collMap, mask, bitpos);
                Object currentKey = this.getCollectionKey(index);
                if (cmp.equals(currentKey, key)) {
                    Set.Immutable currentValColl = this.getCollectionValue(index);
                    return Optional.of(currentValColl);
                }
                return Optional.empty();
            }
            if (BitmapUtils.isBitInBitmap(nodeMap, bitpos)) {
                int index = CompactSetMultimapNode.index(nodeMap, mask, bitpos);
                AbstractSetMultimapNode subNode = this.getNode(index);
                return subNode.findByKey(key, keyHash, shift + 5, cmp);
            }
            return Optional.empty();
        }

        @Override
        public AbstractSetMultimapNode<K, V> inserted(AtomicReference<Thread> mutator, K key, Set.Immutable<V> values, int keyHash, int shift, MultimapResult<K, V, Set.Immutable<V>> details, EqualityComparator<Object> cmp) {
            if (values.size() == 1) {
                Object value = values.findFirst().get();
                return this.insertedSingle((AtomicReference)mutator, (Object)key, value, keyHash, shift, (MultimapResult)details, (EqualityComparator)cmp);
            }
            return this.insertedMultiple(mutator, key, values, keyHash, shift, details, cmp);
        }

        @Override
        public AbstractSetMultimapNode<K, V> insertedSingle(AtomicReference<Thread> mutator, K key, V value, int keyHash, int shift, MultimapResult<K, V, Set.Immutable<V>> details, EqualityComparator<Object> cmp) {
            int mask = CompactSetMultimapNode.mask(keyHash, shift);
            int bitpos = CompactSetMultimapNode.bitpos(mask);
            int rawMap1 = this.rawMap1();
            int rawMap2 = this.rawMap2();
            int collMap = rawMap1 & rawMap2;
            int dataMap = rawMap2 ^ collMap;
            int nodeMap = rawMap1 ^ collMap;
            if (BitmapUtils.isBitInBitmap(dataMap, bitpos)) {
                int dataIndex = CompactSetMultimapNode.index(dataMap, mask, bitpos);
                Object currentKey = this.getSingletonKey(dataIndex);
                if (cmp.equals(currentKey, key)) {
                    Object currentVal = this.getSingletonValue(dataIndex);
                    if (cmp.equals(currentVal, value)) {
                        return this;
                    }
                    Set.Immutable valColl = Set.Immutable.of(currentVal, value);
                    details.modified(MultimapResult.Modification.INSERTED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.INSERTED_VALUE), 1);
                    return this.copyAndMigrateFromSingletonToCollection(mutator, bitpos, currentKey, valColl);
                }
                Object currentVal = this.getSingletonValue(dataIndex);
                CompactSetMultimapNode subNodeNew = CompactSetMultimapNode.mergeTwoSingletonPairs(currentKey, currentVal, AbstractTrieSetMultimap.transformHashCode(currentKey.hashCode()), key, value, keyHash, shift + 5, cmp);
                details.modified(MultimapResult.Modification.INSERTED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.INSERTED_KEY, MultimapResult.Modification.INSERTED_VALUE), 1);
                return this.copyAndMigrateFromSingletonToNode(mutator, bitpos, subNodeNew);
            }
            if (BitmapUtils.isBitInBitmap(collMap, bitpos)) {
                int collIndex = CompactSetMultimapNode.index(collMap, mask, bitpos);
                Object currentCollKey = this.getCollectionKey(collIndex);
                if (cmp.equals(currentCollKey, key)) {
                    Set.Immutable currentCollVal = this.getCollectionValue(collIndex);
                    if (currentCollVal.contains(value)) {
                        return this;
                    }
                    Set.Immutable newCollVal = currentCollVal.__insert(value);
                    details.modified(MultimapResult.Modification.INSERTED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.INSERTED_VALUE), 1);
                    return this.copyAndSetCollectionValue(mutator, bitpos, newCollVal);
                }
                Set.Immutable currentValues = this.getCollectionValue(collIndex);
                CompactSetMultimapNode subNodeNew = CompactSetMultimapNode.mergeCollectionAndSingletonPairs(currentCollKey, currentValues, AbstractTrieSetMultimap.transformHashCode(currentCollKey.hashCode()), key, value, keyHash, shift + 5, cmp);
                details.modified(MultimapResult.Modification.INSERTED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.INSERTED_KEY, MultimapResult.Modification.INSERTED_VALUE), 1);
                return this.copyAndMigrateFromCollectionToNode(mutator, bitpos, subNodeNew);
            }
            if (BitmapUtils.isBitInBitmap(nodeMap, bitpos)) {
                AbstractSetMultimapNode subNode = this.getNode(this.nodeIndex(bitpos));
                AbstractSetMultimapNode subNodeNew = (AbstractSetMultimapNode)subNode.insertedSingle(mutator, key, value, keyHash, shift + 5, details, cmp);
                if (details.getModificationEffect() != MultimapResult.Modification.NOTHING) {
                    return this.copyAndSetNode(mutator, bitpos, subNodeNew);
                }
                return this;
            }
            details.modified(MultimapResult.Modification.INSERTED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.INSERTED_KEY, MultimapResult.Modification.INSERTED_VALUE), 1);
            return this.copyAndInsertSingleton(mutator, bitpos, key, value);
        }

        @Override
        public AbstractSetMultimapNode<K, V> insertedMultiple(AtomicReference<Thread> mutator, K key, Set.Immutable<V> values, int keyHash, int shift, MultimapResult<K, V, Set.Immutable<V>> details, EqualityComparator<Object> cmp) {
            int mask = CompactSetMultimapNode.mask(keyHash, shift);
            int bitpos = CompactSetMultimapNode.bitpos(mask);
            int rawMap1 = this.rawMap1();
            int rawMap2 = this.rawMap2();
            int collMap = rawMap1 & rawMap2;
            int dataMap = rawMap2 ^ collMap;
            int nodeMap = rawMap1 ^ collMap;
            if (BitmapUtils.isBitInBitmap(dataMap, bitpos)) {
                int dataIndex = CompactSetMultimapNode.index(dataMap, mask, bitpos);
                Object currentKey = this.getSingletonKey(dataIndex);
                if (cmp.equals(currentKey, key)) {
                    Object currentVal = this.getSingletonValue(dataIndex);
                    Set.Immutable<V> mergedValues = values.__insert(currentVal);
                    int sizeDelta = 2 * values.size() - mergedValues.size();
                    details.modified(MultimapResult.Modification.INSERTED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.INSERTED_VALUE_COLLECTION), sizeDelta);
                    return this.copyAndMigrateFromSingletonToCollection(mutator, bitpos, currentKey, mergedValues);
                }
                Object currentVal = this.getSingletonValue(dataIndex);
                CompactSetMultimapNode<K, V> subNodeNew = CompactSetMultimapNode.mergeCollectionAndSingletonPairs(key, values, keyHash, currentKey, currentVal, AbstractTrieSetMultimap.transformHashCode(currentKey.hashCode()), shift + 5, cmp);
                int sizeDelta = values.size();
                details.modified(MultimapResult.Modification.INSERTED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.INSERTED_KEY, MultimapResult.Modification.INSERTED_VALUE_COLLECTION), sizeDelta);
                return this.copyAndMigrateFromSingletonToNode(mutator, bitpos, subNodeNew);
            }
            if (BitmapUtils.isBitInBitmap(collMap, bitpos)) {
                int collIndex = CompactSetMultimapNode.index(collMap, mask, bitpos);
                Object currentCollKey = this.getCollectionKey(collIndex);
                if (cmp.equals(currentCollKey, key)) {
                    Set.Immutable currentCollVal = this.getCollectionValue(collIndex);
                    Set.Immutable mergedValues = currentCollVal.__insertAll(values);
                    int sizeDelta = mergedValues.size() - currentCollVal.size();
                    if (sizeDelta == 0) {
                        return this;
                    }
                    details.modified(MultimapResult.Modification.INSERTED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.INSERTED_VALUE_COLLECTION), sizeDelta);
                    return this.copyAndSetCollectionValue(mutator, bitpos, mergedValues);
                }
                Set.Immutable currentValues = this.getCollectionValue(collIndex);
                AbstractSetMultimapNode subNodeNew = CompactSetMultimapNode.mergeTwoCollectionPairs(currentCollKey, currentValues, AbstractTrieSetMultimap.transformHashCode(currentCollKey.hashCode()), key, values, keyHash, shift + 5, cmp);
                int sizeDelta = values.size();
                details.modified(MultimapResult.Modification.INSERTED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.INSERTED_KEY, MultimapResult.Modification.INSERTED_VALUE_COLLECTION), sizeDelta);
                return this.copyAndMigrateFromCollectionToNode(mutator, bitpos, subNodeNew);
            }
            if (BitmapUtils.isBitInBitmap(nodeMap, bitpos)) {
                AbstractSetMultimapNode subNode = this.getNode(this.nodeIndex(bitpos));
                AbstractSetMultimapNode subNodeNew = (AbstractSetMultimapNode)subNode.insertedMultiple(mutator, key, values, keyHash, shift + 5, details, cmp);
                if (details.getModificationEffect() != MultimapResult.Modification.NOTHING) {
                    return this.copyAndSetNode(mutator, bitpos, subNodeNew);
                }
                return this;
            }
            details.modified(MultimapResult.Modification.INSERTED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.INSERTED_KEY, MultimapResult.Modification.INSERTED_VALUE_COLLECTION), values.size());
            return this.copyAndInsertCollection(mutator, bitpos, key, values);
        }

        @Override
        public final AbstractSetMultimapNode<K, V> updated(AtomicReference<Thread> mutator, K key, Set.Immutable<V> values, int keyHash, int shift, MultimapResult<K, V, Set.Immutable<V>> details, EqualityComparator<Object> cmp) {
            if (values.size() == 1) {
                Object value = values.findFirst().get();
                return this.updatedSingle((AtomicReference)mutator, (Object)key, value, keyHash, shift, (MultimapResult)details, (EqualityComparator)cmp);
            }
            return this.updatedMultiple(mutator, key, values, keyHash, shift, details, cmp);
        }

        @Override
        public AbstractSetMultimapNode<K, V> updatedSingle(AtomicReference<Thread> mutator, K key, V value, int keyHash, int shift, MultimapResult<K, V, Set.Immutable<V>> details, EqualityComparator<Object> cmp) {
            int mask = CompactSetMultimapNode.mask(keyHash, shift);
            int bitpos = CompactSetMultimapNode.bitpos(mask);
            int rawMap1 = this.rawMap1();
            int rawMap2 = this.rawMap2();
            int collMap = rawMap1 & rawMap2;
            int dataMap = rawMap2 ^ collMap;
            int nodeMap = rawMap1 ^ collMap;
            if (BitmapUtils.isBitInBitmap(dataMap, bitpos)) {
                int dataIndex = CompactSetMultimapNode.index(dataMap, mask, bitpos);
                Object currentKey = this.getSingletonKey(dataIndex);
                if (cmp.equals(currentKey, key)) {
                    Object currentVal = this.getSingletonValue(dataIndex);
                    details.modified(MultimapResult.Modification.REPLACED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.REPLACED_VALUE), Set.Immutable.of(currentVal));
                    return this.copyAndSetSingletonValue(mutator, bitpos, value);
                }
                Object currentVal = this.getSingletonValue(dataIndex);
                CompactSetMultimapNode subNodeNew = CompactSetMultimapNode.mergeTwoSingletonPairs(currentKey, currentVal, AbstractTrieSetMultimap.transformHashCode(currentKey.hashCode()), key, value, keyHash, shift + 5, cmp);
                details.modified(MultimapResult.Modification.INSERTED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.INSERTED_KEY, MultimapResult.Modification.INSERTED_VALUE));
                return this.copyAndMigrateFromSingletonToNode(mutator, bitpos, subNodeNew);
            }
            if (BitmapUtils.isBitInBitmap(collMap, bitpos)) {
                int collIndex = CompactSetMultimapNode.index(collMap, mask, bitpos);
                Object currentCollKey = this.getCollectionKey(collIndex);
                if (cmp.equals(currentCollKey, key)) {
                    Set.Immutable currentCollVal = this.getCollectionValue(collIndex);
                    details.modified(MultimapResult.Modification.REPLACED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.REPLACED_VALUE_COLLECTION), currentCollVal);
                    return this.copyAndMigrateFromCollectionToSingleton(mutator, bitpos, currentCollKey, value);
                }
                Set.Immutable currentValues = this.getCollectionValue(collIndex);
                CompactSetMultimapNode subNodeNew = CompactSetMultimapNode.mergeCollectionAndSingletonPairs(currentCollKey, currentValues, AbstractTrieSetMultimap.transformHashCode(currentCollKey.hashCode()), key, value, keyHash, shift + 5, cmp);
                details.modified(MultimapResult.Modification.INSERTED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.INSERTED_KEY, MultimapResult.Modification.INSERTED_VALUE));
                return this.copyAndMigrateFromCollectionToNode(mutator, bitpos, subNodeNew);
            }
            if (BitmapUtils.isBitInBitmap(nodeMap, bitpos)) {
                AbstractSetMultimapNode subNode = this.getNode(this.nodeIndex(bitpos));
                AbstractSetMultimapNode subNodeNew = (AbstractSetMultimapNode)subNode.updatedSingle(mutator, key, value, keyHash, shift + 5, details, cmp);
                if (details.getModificationEffect() != MultimapResult.Modification.NOTHING) {
                    return this.copyAndSetNode(mutator, bitpos, subNodeNew);
                }
                return this;
            }
            details.modified(MultimapResult.Modification.INSERTED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.INSERTED_KEY, MultimapResult.Modification.INSERTED_VALUE));
            return this.copyAndInsertSingleton(mutator, bitpos, key, value);
        }

        @Override
        public AbstractSetMultimapNode<K, V> updatedMultiple(AtomicReference<Thread> mutator, K key, Set.Immutable<V> values, int keyHash, int shift, MultimapResult<K, V, Set.Immutable<V>> details, EqualityComparator<Object> cmp) {
            int mask = CompactSetMultimapNode.mask(keyHash, shift);
            int bitpos = CompactSetMultimapNode.bitpos(mask);
            int rawMap1 = this.rawMap1();
            int rawMap2 = this.rawMap2();
            int collMap = rawMap1 & rawMap2;
            int dataMap = rawMap2 ^ collMap;
            int nodeMap = rawMap1 ^ collMap;
            if (BitmapUtils.isBitInBitmap(dataMap, bitpos)) {
                int dataIndex = CompactSetMultimapNode.index(dataMap, mask, bitpos);
                Object currentKey = this.getSingletonKey(dataIndex);
                if (cmp.equals(currentKey, key)) {
                    Object currentVal = this.getSingletonValue(dataIndex);
                    details.modified(MultimapResult.Modification.REPLACED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.REPLACED_VALUE), Set.Immutable.of(currentVal));
                    return this.copyAndMigrateFromSingletonToCollection(mutator, bitpos, key, values);
                }
                Object currentVal = this.getSingletonValue(dataIndex);
                CompactSetMultimapNode<K, V> subNodeNew = CompactSetMultimapNode.mergeCollectionAndSingletonPairs(key, values, keyHash, currentKey, currentVal, AbstractTrieSetMultimap.transformHashCode(currentKey.hashCode()), shift + 5, cmp);
                details.modified(MultimapResult.Modification.INSERTED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.INSERTED_KEY, MultimapResult.Modification.INSERTED_VALUE_COLLECTION));
                return this.copyAndMigrateFromSingletonToNode(mutator, bitpos, subNodeNew);
            }
            if (BitmapUtils.isBitInBitmap(collMap, bitpos)) {
                int collIndex = CompactSetMultimapNode.index(collMap, mask, bitpos);
                Object currentCollKey = this.getCollectionKey(collIndex);
                if (cmp.equals(currentCollKey, key)) {
                    Set.Immutable currentCollVal = this.getCollectionValue(collIndex);
                    details.modified(MultimapResult.Modification.REPLACED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.REPLACED_VALUE_COLLECTION), currentCollVal);
                    return this.copyAndSetCollectionValue(mutator, bitpos, values);
                }
                Set.Immutable currentValues = this.getCollectionValue(collIndex);
                AbstractSetMultimapNode subNodeNew = CompactSetMultimapNode.mergeTwoCollectionPairs(currentCollKey, currentValues, AbstractTrieSetMultimap.transformHashCode(currentCollKey.hashCode()), key, values, keyHash, shift + 5, cmp);
                details.modified(MultimapResult.Modification.INSERTED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.INSERTED_KEY, MultimapResult.Modification.INSERTED_VALUE_COLLECTION));
                return this.copyAndMigrateFromCollectionToNode(mutator, bitpos, subNodeNew);
            }
            if (BitmapUtils.isBitInBitmap(nodeMap, bitpos)) {
                AbstractSetMultimapNode subNode = this.getNode(this.nodeIndex(bitpos));
                AbstractSetMultimapNode subNodeNew = (AbstractSetMultimapNode)subNode.updatedMultiple(mutator, key, values, keyHash, shift + 5, details, cmp);
                if (details.getModificationEffect() != MultimapResult.Modification.NOTHING) {
                    return this.copyAndSetNode(mutator, bitpos, subNodeNew);
                }
                return this;
            }
            details.modified(MultimapResult.Modification.INSERTED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.INSERTED_KEY, MultimapResult.Modification.INSERTED_VALUE_COLLECTION));
            return this.copyAndInsertCollection(mutator, bitpos, key, values);
        }

        @Override
        public AbstractSetMultimapNode<K, V> removed(AtomicReference<Thread> mutator, K key, V value, int keyHash, int shift, MultimapResult<K, V, Set.Immutable<V>> details, EqualityComparator<Object> cmp) {
            int mask = CompactSetMultimapNode.mask(keyHash, shift);
            int bitpos = CompactSetMultimapNode.bitpos(mask);
            int rawMap1 = this.rawMap1();
            int rawMap2 = this.rawMap2();
            int collMap = rawMap1 & rawMap2;
            int dataMap = rawMap2 ^ collMap;
            int nodeMap = rawMap1 ^ collMap;
            if (BitmapUtils.isBitInBitmap(dataMap, bitpos)) {
                int dataIndex = CompactSetMultimapNode.index(dataMap, mask, bitpos);
                Object currentKey = this.getSingletonKey(dataIndex);
                if (cmp.equals(currentKey, key)) {
                    Object currentVal = this.getSingletonValue(dataIndex);
                    if (cmp.equals(currentVal, value)) {
                        details.modified(MultimapResult.Modification.REMOVED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.REMOVED_KEY, MultimapResult.Modification.REMOVED_VALUE), Set.Immutable.of(currentVal));
                        return this.copyAndRemoveSingleton(mutator, bitpos).canonicalize(mutator, keyHash, shift);
                    }
                    return this;
                }
                return this;
            }
            if (BitmapUtils.isBitInBitmap(collMap, bitpos)) {
                int collIndex = CompactSetMultimapNode.index(collMap, mask, bitpos);
                Object currentKey = this.getCollectionKey(collIndex);
                if (cmp.equals(currentKey, key)) {
                    Set.Immutable currentValColl = this.getCollectionValue(collIndex);
                    if (currentValColl.contains(value)) {
                        details.modified(MultimapResult.Modification.REMOVED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.REMOVED_VALUE), Set.Immutable.of(value));
                        Set.Immutable newValColl = currentValColl.__remove(value);
                        if (newValColl.size() == 1) {
                            Object remainingVal = newValColl.iterator().next();
                            return this.copyAndMigrateFromCollectionToSingleton(mutator, bitpos, key, remainingVal);
                        }
                        return this.copyAndSetCollectionValue(mutator, bitpos, newValColl);
                    }
                    return this;
                }
                return this;
            }
            if (BitmapUtils.isBitInBitmap(nodeMap, bitpos)) {
                AbstractSetMultimapNode subNode = this.getNode(CompactSetMultimapNode.index(nodeMap, mask, bitpos));
                AbstractSetMultimapNode subNodeNew = (AbstractSetMultimapNode)subNode.removed(mutator, key, value, keyHash, shift + 5, details, cmp);
                if (details.getModificationEffect() == MultimapResult.Modification.NOTHING) {
                    return this;
                }
                switch (subNodeNew.sizePredicate()) {
                    case 0: {
                        throw new IllegalStateException("Sub-node must have at least one element.");
                    }
                    case 1: {
                        if (CompactSetMultimapNode.arity(nodeMap) == 1 && CompactSetMultimapNode.arity(dataMap) == 0 && CompactSetMultimapNode.arity(collMap) == 0) {
                            return subNodeNew;
                        }
                        EitherSingletonOrCollection.Type type = subNodeNew.typeOfSingleton();
                        if (type == EitherSingletonOrCollection.Type.SINGLETON) {
                            return this.copyAndMigrateFromNodeToSingleton(mutator, bitpos, subNodeNew);
                        }
                        return this.copyAndMigrateFromNodeToCollection(mutator, bitpos, subNodeNew);
                    }
                }
                return this.copyAndSetNode(mutator, bitpos, subNodeNew);
            }
            return this;
        }

        @Override
        public AbstractSetMultimapNode<K, V> removed(AtomicReference<Thread> mutator, K key, int keyHash, int shift, MultimapResult<K, V, Set.Immutable<V>> details, EqualityComparator<Object> cmp) {
            int mask = CompactSetMultimapNode.mask(keyHash, shift);
            int bitpos = CompactSetMultimapNode.bitpos(mask);
            int rawMap1 = this.rawMap1();
            int rawMap2 = this.rawMap2();
            int collMap = rawMap1 & rawMap2;
            int dataMap = rawMap2 ^ collMap;
            int nodeMap = rawMap1 ^ collMap;
            if (BitmapUtils.isBitInBitmap(dataMap, bitpos)) {
                int dataIndex = CompactSetMultimapNode.index(dataMap, mask, bitpos);
                Object currentKey = this.getSingletonKey(dataIndex);
                if (cmp.equals(currentKey, key)) {
                    Object currentVal = this.getSingletonValue(dataIndex);
                    details.modified(MultimapResult.Modification.REMOVED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.REMOVED_KEY, MultimapResult.Modification.REMOVED_VALUE), Set.Immutable.of(currentVal));
                    return this.copyAndRemoveSingleton(mutator, bitpos).canonicalize(mutator, keyHash, shift);
                }
                return this;
            }
            if (BitmapUtils.isBitInBitmap(collMap, bitpos)) {
                int collIndex = CompactSetMultimapNode.index(collMap, mask, bitpos);
                Object currentKey = this.getCollectionKey(collIndex);
                if (cmp.equals(currentKey, key)) {
                    Set.Immutable currentValColl = this.getCollectionValue(collIndex);
                    details.modified(MultimapResult.Modification.REMOVED_PAYLOAD, MultimapResult.Modification.flag(MultimapResult.Modification.REMOVED_KEY, MultimapResult.Modification.REMOVED_VALUE_COLLECTION), currentValColl);
                    return this.copyAndRemoveCollection(mutator, bitpos).canonicalize(mutator, keyHash, shift);
                }
                return this;
            }
            if (BitmapUtils.isBitInBitmap(nodeMap, bitpos)) {
                AbstractSetMultimapNode subNode = this.getNode(CompactSetMultimapNode.index(nodeMap, mask, bitpos));
                AbstractSetMultimapNode subNodeNew = (AbstractSetMultimapNode)subNode.removed(mutator, key, keyHash, shift + 5, details, cmp);
                if (details.getModificationEffect() == MultimapResult.Modification.NOTHING) {
                    return this;
                }
                switch (subNodeNew.sizePredicate()) {
                    case 0: {
                        throw new IllegalStateException("Sub-node must have at least one element.");
                    }
                    case 1: {
                        if (CompactSetMultimapNode.arity(nodeMap) == 1 && CompactSetMultimapNode.arity(dataMap) == 0 && CompactSetMultimapNode.arity(collMap) == 0) {
                            return subNodeNew;
                        }
                        EitherSingletonOrCollection.Type type = subNodeNew.typeOfSingleton();
                        if (type == EitherSingletonOrCollection.Type.SINGLETON) {
                            return this.copyAndMigrateFromNodeToSingleton(mutator, bitpos, subNodeNew);
                        }
                        return this.copyAndMigrateFromNodeToCollection(mutator, bitpos, subNodeNew);
                    }
                }
                return this.copyAndSetNode(mutator, bitpos, subNodeNew);
            }
            return this;
        }

        abstract CompactSetMultimapNode<K, V> canonicalize(AtomicReference<Thread> var1, int var2, int var3);

        static byte recoverMask(int map, byte i_th) {
            assert (1 <= i_th && i_th <= 32);
            byte cnt1 = 0;
            for (byte mask = 0; mask < 32; mask = (byte)((byte)(mask + 1))) {
                if ((map & 1) == 1 && (cnt1 = (byte)(cnt1 + 1)) == i_th) {
                    return mask;
                }
                map >>= 1;
            }
            assert (cnt1 != i_th);
            throw new RuntimeException("Called with invalid arguments.");
        }

        public String toString() {
            byte pos;
            int i;
            int rawMap1 = this.rawMap1();
            int rawMap2 = this.rawMap2();
            int collMap = rawMap1 & rawMap2;
            int dataMap = rawMap2 ^ collMap;
            int nodeMap = rawMap1 ^ collMap;
            StringBuilder bldr = new StringBuilder();
            bldr.append('[');
            for (i = 0; i < CompactSetMultimapNode.arity(dataMap); i = (int)((byte)(i + 1))) {
                pos = CompactSetMultimapNode.recoverMask(dataMap, (byte)(i + 1));
                bldr.append(String.format("@%d", pos));
                if (i + 1 == CompactSetMultimapNode.arity(dataMap)) continue;
                bldr.append(", ");
            }
            if (CompactSetMultimapNode.arity(dataMap) > 0 && CompactSetMultimapNode.arity(collMap) > 0) {
                bldr.append(", ");
            }
            for (i = 0; i < CompactSetMultimapNode.arity(collMap); i = (int)((byte)(i + 1))) {
                pos = CompactSetMultimapNode.recoverMask(collMap, (byte)(i + 1));
                bldr.append(String.format("@%d", pos));
                if (i + 1 == CompactSetMultimapNode.arity(collMap)) continue;
                bldr.append(", ");
            }
            if (CompactSetMultimapNode.arity(collMap) > 0 && CompactSetMultimapNode.arity(nodeMap) > 0) {
                bldr.append(", ");
            }
            for (i = 0; i < CompactSetMultimapNode.arity(nodeMap); i = (int)((byte)(i + 1))) {
                pos = CompactSetMultimapNode.recoverMask(nodeMap, (byte)(i + 1));
                bldr.append(String.format("@%d: %s", pos, this.getNode(i)));
                if (i + 1 == CompactSetMultimapNode.arity(nodeMap)) continue;
                bldr.append(", ");
            }
            bldr.append(']');
            return bldr.toString();
        }
    }

    protected static abstract class AbstractSetMultimapNode<K, V>
    implements MultimapNode<K, V, Set.Immutable<V>, AbstractSetMultimapNode<K, V>>,
    Serializable {
        private static final long serialVersionUID = 42L;
        static final int TUPLE_LENGTH = 2;

        protected AbstractSetMultimapNode() {
        }

        @Override
        public final boolean mustUnbox(Set.Immutable<V> values) {
            return values.size() == 1;
        }

        @Override
        public final V unbox(Set.Immutable<V> values) {
            assert (this.mustUnbox(values));
            return (V)values.findFirst().get();
        }

        static final boolean isAllowedToEdit(AtomicReference<?> x, AtomicReference<?> y) {
            return x != null && y != null && (x == y || x.get() == y.get());
        }

        @Override
        public <T> ArrayView<T> dataArray(int category, int component) {
            switch (category) {
                case 0: {
                    return this.categoryArrayView0(component);
                }
                case 1: {
                    return this.categoryArrayView1(component);
                }
            }
            throw new IllegalArgumentException("Category %i is not supported.");
        }

        private <T> ArrayView<T> categoryArrayView0(final int component) {
            return new ArrayView<T>(){

                @Override
                public int size() {
                    return this.payloadArity(EitherSingletonOrCollection.Type.SINGLETON);
                }

                @Override
                public T get(int index) {
                    switch (component) {
                        case 0: {
                            return this.getSingletonKey(index);
                        }
                        case 1: {
                            return this.getSingletonValue(index);
                        }
                    }
                    throw new IllegalStateException();
                }
            };
        }

        private <T> ArrayView<T> categoryArrayView1(final int component) {
            return new ArrayView<T>(){

                @Override
                public int size() {
                    return this.payloadArity(EitherSingletonOrCollection.Type.COLLECTION);
                }

                @Override
                public T get(int index) {
                    switch (component) {
                        case 0: {
                            return this.getCollectionKey(index);
                        }
                        case 1: {
                            return this.getCollectionValue(index);
                        }
                    }
                    throw new IllegalStateException();
                }
            };
        }

        public abstract ArrayView<AbstractSetMultimapNode<K, V>> nodeArray();

        abstract boolean hasNodes();

        abstract int nodeArity();

        abstract AbstractSetMultimapNode<K, V> getNode(int var1);

        @Deprecated
        Iterator<? extends AbstractSetMultimapNode<K, V>> nodeIterator() {
            return new Iterator<AbstractSetMultimapNode<K, V>>(){
                int nextIndex = 0;
                final int nodeArity = this.nodeArity();

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public AbstractSetMultimapNode<K, V> next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return this.getNode(this.nextIndex++);
                }

                @Override
                public boolean hasNext() {
                    return this.nextIndex < this.nodeArity;
                }
            };
        }

        abstract boolean hasPayload(EitherSingletonOrCollection.Type var1);

        abstract int payloadArity(EitherSingletonOrCollection.Type var1);

        abstract K getSingletonKey(int var1);

        abstract V getSingletonValue(int var1);

        abstract K getCollectionKey(int var1);

        abstract Set.Immutable<V> getCollectionValue(int var1);

        abstract boolean hasSlots();

        abstract int slotArity();

        abstract Object getSlot(int var1);

        abstract int arity();

        int size() {
            AbstractTrieSetMultimap.SetMultimapKeyIterator it = new AbstractTrieSetMultimap.SetMultimapKeyIterator(this);
            int size = 0;
            while (it.hasNext()) {
                ++size;
                it.next();
            }
            return size;
        }
    }
}

