/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.protocol;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gradle.api.logging.LogLevel;
import org.gradle.configuration.GradleLauncherMetaData;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.logging.events.LogEvent;
import org.gradle.internal.logging.events.LogLevelChangeEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.ProgressCompleteEvent;
import org.gradle.internal.logging.events.ProgressEvent;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.logging.events.PromptOutputEvent;
import org.gradle.internal.logging.events.StyledTextOutputEvent;
import org.gradle.internal.logging.events.UserInputRequestEvent;
import org.gradle.internal.logging.events.UserInputResumeEvent;
import org.gradle.internal.logging.serializer.LogEventSerializer;
import org.gradle.internal.logging.serializer.LogLevelChangeEventSerializer;
import org.gradle.internal.logging.serializer.ProgressCompleteEventSerializer;
import org.gradle.internal.logging.serializer.ProgressEventSerializer;
import org.gradle.internal.logging.serializer.ProgressStartEventSerializer;
import org.gradle.internal.logging.serializer.PromptOutputEventSerializer;
import org.gradle.internal.logging.serializer.SpanSerializer;
import org.gradle.internal.logging.serializer.StyledTextOutputEventSerializer;
import org.gradle.internal.logging.serializer.UserInputRequestEventSerializer;
import org.gradle.internal.logging.serializer.UserInputResumeEventSerializer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.DefaultSerializer;
import org.gradle.internal.serialize.DefaultSerializerRegistry;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.ListSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.launcher.daemon.diagnostics.DaemonDiagnostics;
import org.gradle.launcher.daemon.protocol.Build;
import org.gradle.launcher.daemon.protocol.BuildEvent;
import org.gradle.launcher.daemon.protocol.BuildStarted;
import org.gradle.launcher.daemon.protocol.Cancel;
import org.gradle.launcher.daemon.protocol.CloseInput;
import org.gradle.launcher.daemon.protocol.DaemonUnavailable;
import org.gradle.launcher.daemon.protocol.Failure;
import org.gradle.launcher.daemon.protocol.Finished;
import org.gradle.launcher.daemon.protocol.ForwardInput;
import org.gradle.launcher.daemon.protocol.Message;
import org.gradle.launcher.daemon.protocol.OutputMessage;
import org.gradle.launcher.daemon.protocol.Success;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;
import org.gradle.launcher.exec.DefaultBuildActionParameters;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;
import org.gradle.tooling.internal.provider.serialization.SerializedPayloadSerializer;

public class DaemonMessageSerializer {
    public static Serializer<Message> create(Serializer<BuildAction> buildActionSerializer) {
        BaseSerializerFactory factory = new BaseSerializerFactory();
        Serializer logLevelSerializer = factory.getSerializerFor(LogLevel.class);
        Serializer throwableSerializer = factory.getSerializerFor(Throwable.class);
        DefaultSerializerRegistry registry = new DefaultSerializerRegistry();
        registry.register(Build.class, (Serializer)new BuildSerializer(buildActionSerializer));
        registry.register(Cancel.class, (Serializer)new CancelSerializer());
        registry.register(DaemonUnavailable.class, (Serializer)new DaemonUnavailableSerializer());
        registry.register(BuildStarted.class, (Serializer)new BuildStartedSerializer());
        registry.register(Failure.class, (Serializer)new FailureSerializer((Serializer<Throwable>)throwableSerializer));
        registry.register(Success.class, (Serializer)new SuccessSerializer());
        registry.register(Finished.class, (Serializer)new FinishedSerializer());
        registry.register(BuildEvent.class, (Serializer)new BuildEventSerializer());
        registry.register(ForwardInput.class, (Serializer)new ForwardInputSerializer());
        registry.register(CloseInput.class, (Serializer)new CloseInputSerializer());
        registry.register(LogEvent.class, (Serializer)new LogEventSerializer(logLevelSerializer, throwableSerializer));
        registry.register(UserInputRequestEvent.class, (Serializer)new UserInputRequestEventSerializer());
        registry.register(PromptOutputEvent.class, (Serializer)new PromptOutputEventSerializer());
        registry.register(UserInputResumeEvent.class, (Serializer)new UserInputResumeEventSerializer());
        registry.register(StyledTextOutputEvent.class, (Serializer)new StyledTextOutputEventSerializer(logLevelSerializer, (Serializer)new ListSerializer((Serializer)new SpanSerializer(factory.getSerializerFor(StyledTextOutput.Style.class)))));
        registry.register(ProgressStartEvent.class, (Serializer)new ProgressStartEventSerializer());
        registry.register(ProgressCompleteEvent.class, (Serializer)new ProgressCompleteEventSerializer());
        registry.register(ProgressEvent.class, (Serializer)new ProgressEventSerializer());
        registry.register(LogLevelChangeEvent.class, (Serializer)new LogLevelChangeEventSerializer(logLevelSerializer));
        registry.register(OutputMessage.class, (Serializer)new OutputMessageSerializer((Serializer<OutputEvent>)registry.build(OutputEvent.class)));
        registry.useJavaSerialization(Message.class);
        return registry.build(Message.class);
    }

    private static class FinishedSerializer
    implements Serializer<Finished> {
        private FinishedSerializer() {
        }

        public Finished read(Decoder decoder) {
            return new Finished();
        }

        public void write(Encoder encoder, Finished value) {
        }
    }

    private static class BuildStartedSerializer
    implements Serializer<BuildStarted> {
        private BuildStartedSerializer() {
        }

        public void write(Encoder encoder, BuildStarted buildStarted) throws Exception {
            BaseSerializerFactory.FILE_SERIALIZER.write(encoder, (Object)buildStarted.getDiagnostics().getDaemonLog());
            if (buildStarted.getDiagnostics().getPid() == null) {
                encoder.writeBoolean(false);
            } else {
                encoder.writeBoolean(true);
                encoder.writeLong(buildStarted.getDiagnostics().getPid().longValue());
            }
        }

        public BuildStarted read(Decoder decoder) throws Exception {
            File log = (File)BaseSerializerFactory.FILE_SERIALIZER.read(decoder);
            boolean nonNull = decoder.readBoolean();
            Long pid = null;
            if (nonNull) {
                pid = decoder.readLong();
            }
            return new BuildStarted(new DaemonDiagnostics(log, pid));
        }
    }

    private static class CancelSerializer
    implements Serializer<Cancel> {
        private CancelSerializer() {
        }

        public void write(Encoder encoder, Cancel value) {
        }

        public Cancel read(Decoder decoder) {
            return new Cancel();
        }
    }

    private static class DaemonUnavailableSerializer
    implements Serializer<DaemonUnavailable> {
        private DaemonUnavailableSerializer() {
        }

        public void write(Encoder encoder, DaemonUnavailable value) throws Exception {
            encoder.writeNullableString((CharSequence)value.getReason());
        }

        public DaemonUnavailable read(Decoder decoder) throws Exception {
            return new DaemonUnavailable(decoder.readNullableString());
        }
    }

    private static class BuildActionParametersSerializer
    implements Serializer<BuildActionParameters> {
        private final Serializer<LogLevel> logLevelSerializer = new BaseSerializerFactory().getSerializerFor(LogLevel.class);
        private final Serializer<List<File>> classPathSerializer = new ListSerializer(BaseSerializerFactory.FILE_SERIALIZER);

        BuildActionParametersSerializer() {
        }

        public void write(Encoder encoder, BuildActionParameters parameters) throws Exception {
            BaseSerializerFactory.FILE_SERIALIZER.write(encoder, (Object)parameters.getCurrentDir());
            BaseSerializerFactory.NO_NULL_STRING_MAP_SERIALIZER.write(encoder, parameters.getSystemProperties());
            BaseSerializerFactory.NO_NULL_STRING_MAP_SERIALIZER.write(encoder, parameters.getEnvVariables());
            this.logLevelSerializer.write(encoder, (Object)parameters.getLogLevel());
            encoder.writeBoolean(parameters.isUseDaemon());
            this.classPathSerializer.write(encoder, parameters.getInjectedPluginClasspath().getAsFiles());
        }

        public BuildActionParameters read(Decoder decoder) throws Exception {
            File currentDir = (File)BaseSerializerFactory.FILE_SERIALIZER.read(decoder);
            Map sysProperties = (Map)BaseSerializerFactory.NO_NULL_STRING_MAP_SERIALIZER.read(decoder);
            Map envVariables = (Map)BaseSerializerFactory.NO_NULL_STRING_MAP_SERIALIZER.read(decoder);
            LogLevel logLevel = (LogLevel)this.logLevelSerializer.read(decoder);
            boolean useDaemon = decoder.readBoolean();
            ClassPath classPath = DefaultClassPath.of((Collection)this.classPathSerializer.read(decoder));
            return new DefaultBuildActionParameters(sysProperties, envVariables, currentDir, logLevel, useDaemon, classPath);
        }
    }

    private static class BuildSerializer
    implements Serializer<Build> {
        private final Serializer<BuildAction> buildActionSerializer;
        private final Serializer<BuildActionParameters> buildActionParametersSerializer = new BuildActionParametersSerializer();

        private BuildSerializer(Serializer<BuildAction> buildActionSerializer) {
            this.buildActionSerializer = buildActionSerializer;
        }

        public void write(Encoder encoder, Build build) throws Exception {
            encoder.writeLong(build.getIdentifier().getMostSignificantBits());
            encoder.writeLong(build.getIdentifier().getLeastSignificantBits());
            encoder.writeBinary(build.getToken());
            encoder.writeLong(build.getStartTime());
            encoder.writeBoolean(build.isInteractive());
            this.buildActionSerializer.write(encoder, (Object)build.getAction());
            GradleLauncherMetaData metaData = (GradleLauncherMetaData)build.getBuildClientMetaData();
            encoder.writeString((CharSequence)metaData.getAppName());
            this.buildActionParametersSerializer.write(encoder, (Object)build.getParameters());
        }

        public Build read(Decoder decoder) throws Exception {
            UUID uuid = new UUID(decoder.readLong(), decoder.readLong());
            byte[] token = decoder.readBinary();
            long timestamp = decoder.readLong();
            boolean interactive = decoder.readBoolean();
            BuildAction buildAction = (BuildAction)this.buildActionSerializer.read(decoder);
            GradleLauncherMetaData metaData = new GradleLauncherMetaData(decoder.readString());
            BuildActionParameters buildActionParameters = (BuildActionParameters)this.buildActionParametersSerializer.read(decoder);
            return new Build(uuid, token, buildAction, (BuildClientMetaData)metaData, timestamp, interactive, buildActionParameters);
        }
    }

    private static class OutputMessageSerializer
    implements Serializer<OutputMessage> {
        private final Serializer<OutputEvent> eventSerializer;

        OutputMessageSerializer(Serializer<OutputEvent> eventSerializer) {
            this.eventSerializer = eventSerializer;
        }

        public void write(Encoder encoder, OutputMessage message) throws Exception {
            this.eventSerializer.write(encoder, (Object)message.getEvent());
        }

        public OutputMessage read(Decoder decoder) throws Exception {
            return new OutputMessage((OutputEvent)this.eventSerializer.read(decoder));
        }
    }

    private static class CloseInputSerializer
    implements Serializer<CloseInput> {
        private CloseInputSerializer() {
        }

        public void write(Encoder encoder, CloseInput value) {
        }

        public CloseInput read(Decoder decoder) {
            return new CloseInput();
        }
    }

    private static class ForwardInputSerializer
    implements Serializer<ForwardInput> {
        private ForwardInputSerializer() {
        }

        public void write(Encoder encoder, ForwardInput message) throws Exception {
            encoder.writeBinary(message.getBytes());
        }

        public ForwardInput read(Decoder decoder) throws Exception {
            return new ForwardInput(decoder.readBinary());
        }
    }

    private static class BuildEventSerializer
    implements Serializer<BuildEvent> {
        private final Serializer<Object> payloadSerializer = new DefaultSerializer();

        private BuildEventSerializer() {
        }

        public void write(Encoder encoder, BuildEvent buildEvent) throws Exception {
            this.payloadSerializer.write(encoder, buildEvent.getPayload());
        }

        public BuildEvent read(Decoder decoder) throws Exception {
            return new BuildEvent(this.payloadSerializer.read(decoder));
        }
    }

    private static class FailureSerializer
    implements Serializer<Failure> {
        private final Serializer<Throwable> throwableSerializer;

        FailureSerializer(Serializer<Throwable> throwableSerializer) {
            this.throwableSerializer = throwableSerializer;
        }

        public void write(Encoder encoder, Failure failure) throws Exception {
            this.throwableSerializer.write(encoder, (Object)((Throwable)failure.getValue()));
        }

        public Failure read(Decoder decoder) throws Exception {
            return new Failure((Throwable)this.throwableSerializer.read(decoder));
        }
    }

    private static class SuccessSerializer
    implements Serializer<Success> {
        private final Serializer<Object> javaSerializer = new DefaultSerializer();
        private final Serializer<SerializedPayload> payloadSerializer = new SerializedPayloadSerializer();

        private SuccessSerializer() {
        }

        public void write(Encoder encoder, Success success) throws Exception {
            if (success.getValue() == null) {
                encoder.writeByte((byte)0);
            } else if (success.getValue() instanceof BuildActionResult) {
                BuildActionResult result = (BuildActionResult)success.getValue();
                if (result.getResult() != null) {
                    if (result.getException() != null || result.getFailure() != null || result.wasCancelled()) {
                        throw new IllegalArgumentException("Result should not have both a result object and a failure associated with it.");
                    }
                    if (result.getResult().getHeader() == null && result.getResult().getSerializedModel().isEmpty()) {
                        encoder.writeByte((byte)1);
                    } else {
                        encoder.writeByte((byte)2);
                        this.payloadSerializer.write(encoder, (Object)result.getResult());
                    }
                } else if (result.getFailure() != null) {
                    encoder.writeByte((byte)3);
                    encoder.writeBoolean(result.wasCancelled());
                    this.payloadSerializer.write(encoder, (Object)result.getFailure());
                } else {
                    encoder.writeByte((byte)4);
                    encoder.writeBoolean(result.wasCancelled());
                    this.javaSerializer.write(encoder, (Object)result.getException());
                }
            } else {
                encoder.writeByte((byte)5);
                this.javaSerializer.write(encoder, success.getValue());
            }
        }

        public Success read(Decoder decoder) throws Exception {
            byte tag = decoder.readByte();
            switch (tag) {
                case 0: {
                    return new Success((Object)null);
                }
                case 1: {
                    return new Success(BuildActionResult.of(new SerializedPayload(null, Collections.emptyList())));
                }
                case 2: {
                    SerializedPayload result = (SerializedPayload)this.payloadSerializer.read(decoder);
                    return new Success(BuildActionResult.of(result));
                }
                case 3: {
                    boolean wasCancelled = decoder.readBoolean();
                    SerializedPayload failure = (SerializedPayload)this.payloadSerializer.read(decoder);
                    return new Success(BuildActionResult.failed(wasCancelled, failure, null));
                }
                case 4: {
                    boolean wasCancelled = decoder.readBoolean();
                    RuntimeException exception = (RuntimeException)this.javaSerializer.read(decoder);
                    return new Success(BuildActionResult.failed(wasCancelled, null, exception));
                }
                case 5: {
                    return new Success(this.javaSerializer.read(decoder));
                }
            }
            throw new IllegalArgumentException("Unexpected payload type.");
        }
    }
}

