/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.install.internal;

import java.io.File;
import java.net.URI;
import java.util.Optional;
import javax.inject.Inject;
import net.rubygrapefruit.platform.SystemInfo;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.jvm.inspection.JvmVendor;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.JvmImplementation;
import org.gradle.jvm.toolchain.install.internal.AdoptOpenJdkDownloader;
import org.gradle.jvm.toolchain.internal.DefaultJvmVendorSpec;

public class AdoptOpenJdkRemoteBinary {
    private final SystemInfo systemInfo;
    private final OperatingSystem operatingSystem;
    private final AdoptOpenJdkDownloader downloader;
    private final Provider<String> rootUrl;

    @Inject
    public AdoptOpenJdkRemoteBinary(SystemInfo systemInfo, OperatingSystem operatingSystem, AdoptOpenJdkDownloader downloader, ProviderFactory providerFactory) {
        this.systemInfo = systemInfo;
        this.operatingSystem = operatingSystem;
        this.downloader = downloader;
        this.rootUrl = providerFactory.gradleProperty("org.gradle.jvm.toolchain.install.adoptopenjdk.baseUri");
    }

    public Optional<File> download(JavaToolchainSpec spec, File destinationFile) {
        if (!this.canProvideMatchingJdk(spec)) {
            return Optional.empty();
        }
        URI source = this.toDownloadUri(spec);
        this.downloader.download(source, destinationFile);
        return Optional.of(destinationFile);
    }

    public boolean canProvideMatchingJdk(JavaToolchainSpec spec) {
        boolean matchesLanguageVersion = this.determineLanguageVersion(spec).canCompileOrRun(8);
        boolean j9Requested = spec.getImplementation().get() == JvmImplementation.J9;
        boolean matchesVendor = this.matchesVendor(spec, j9Requested);
        return matchesLanguageVersion && matchesVendor;
    }

    private boolean matchesVendor(JavaToolchainSpec spec, boolean j9Requested) {
        DefaultJvmVendorSpec vendorSpec = (DefaultJvmVendorSpec)spec.getVendor().get();
        if (vendorSpec == DefaultJvmVendorSpec.any()) {
            return true;
        }
        if (vendorSpec.test(JvmVendor.KnownJvmVendor.ADOPTOPENJDK.asJvmVendor())) {
            DeprecationLogger.deprecateBehaviour((String)"Due to changes in AdoptOpenJDK download endpoint, downloading a JDK with an explicit vendor of AdoptOpenJDK should be replaced with a spec without a vendor or using Eclipse Temurin / IBM Semeru.").willBeRemovedInGradle8().withUpgradeGuideSection(7, "adoptopenjdk_download").nagUser();
            return true;
        }
        if (vendorSpec.test(JvmVendor.KnownJvmVendor.ADOPTIUM.asJvmVendor()) && !j9Requested) {
            return true;
        }
        return vendorSpec.test(JvmVendor.KnownJvmVendor.IBM_SEMERU.asJvmVendor());
    }

    URI toDownloadUri(JavaToolchainSpec spec) {
        return this.constructUri(spec);
    }

    private URI constructUri(JavaToolchainSpec spec) {
        return URI.create(this.getServerBaseUri() + "v3/binary/latest/" + this.determineLanguageVersion(spec).toString() + "/" + this.determineReleaseState() + "/" + this.determineOs() + "/" + this.determineArch() + "/jdk/" + this.determineImplementation(spec) + "/normal/adoptopenjdk");
    }

    private String determineImplementation(JavaToolchainSpec spec) {
        JvmImplementation implementation = (JvmImplementation)spec.getImplementation().getOrNull();
        String openj9 = "openj9";
        if (implementation == JvmImplementation.J9) {
            return openj9;
        }
        DefaultJvmVendorSpec vendorSpec = (DefaultJvmVendorSpec)spec.getVendor().get();
        if (vendorSpec != DefaultJvmVendorSpec.any() && vendorSpec.test(JvmVendor.KnownJvmVendor.IBM_SEMERU.asJvmVendor())) {
            return openj9;
        }
        return "hotspot";
    }

    private String determineVendor(JavaToolchainSpec spec) {
        DefaultJvmVendorSpec vendorSpec = (DefaultJvmVendorSpec)spec.getVendor().get();
        if (vendorSpec == DefaultJvmVendorSpec.any()) {
            return "adoptium";
        }
        return vendorSpec.toString().toLowerCase();
    }

    public String toFilename(JavaToolchainSpec spec) {
        return String.format("%s-%s-%s-%s-%s.%s", this.determineVendor(spec), this.determineLanguageVersion(spec), this.determineArch(), this.determineImplementation(spec), this.determineOs(), this.determineFileExtension());
    }

    private String determineFileExtension() {
        if (this.operatingSystem.isWindows()) {
            return "zip";
        }
        return "tar.gz";
    }

    private JavaLanguageVersion determineLanguageVersion(JavaToolchainSpec spec) {
        return (JavaLanguageVersion)spec.getLanguageVersion().get();
    }

    private String determineArch() {
        switch (this.systemInfo.getArchitecture()) {
            case i386: {
                return "x32";
            }
            case amd64: {
                return "x64";
            }
            case aarch64: {
                return "aarch64";
            }
        }
        return this.systemInfo.getArchitectureName();
    }

    private String determineOs() {
        if (this.operatingSystem.isWindows()) {
            return "windows";
        }
        if (this.operatingSystem.isMacOsX()) {
            return "mac";
        }
        if (this.operatingSystem.isLinux()) {
            return "linux";
        }
        return this.operatingSystem.getFamilyName();
    }

    private String determineReleaseState() {
        return "ga";
    }

    private String getServerBaseUri() {
        String baseUri = (String)this.rootUrl.getOrElse((Object)"https://api.adoptopenjdk.net/");
        if (!baseUri.endsWith("/")) {
            baseUri = baseUri + "/";
        }
        return baseUri;
    }
}

