/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionApplicator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DownloadMetadataOperation;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.IncompatibleVariantsSelectionMessageBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolutionConflictTracker;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CapabilitiesConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.DefaultCapabilitiesConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ModuleConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.PotentialConflict;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.CompatibilityRule;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Factory;
import org.gradle.internal.component.IncompatibleVariantsSelectionException;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.local.model.RootLocalComponentMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.DefaultCompatibilityCheckResult;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.LongIdGenerator;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationConstraint;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.resolver.ResolveContextToComponentResolver;
import org.gradle.internal.resolve.result.DefaultBuildableComponentResolveResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyGraphBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyGraphBuilder.class);
    private final ModuleConflictHandler moduleConflictHandler;
    private final Spec<? super DependencyMetadata> edgeFilter;
    private final ResolveContextToComponentResolver moduleResolver;
    private final DependencyToComponentIdResolver idResolver;
    private final ComponentMetaDataResolver metaDataResolver;
    private final AttributesSchemaInternal attributesSchema;
    private final ModuleExclusions moduleExclusions;
    private final BuildOperationExecutor buildOperationExecutor;
    private final ComponentSelectorConverter componentSelectorConverter;
    private final DependencySubstitutionApplicator dependencySubstitutionApplicator;
    private final ImmutableAttributesFactory attributesFactory;
    private final CapabilitiesConflictHandler capabilitiesConflictHandler;
    private final VersionSelectorScheme versionSelectorScheme;
    private final Comparator<Version> versionComparator;
    private final VersionParser versionParser;
    private final ResolutionConflictTracker conflictTracker;
    static final Spec<EdgeState> ENDORSE_STRICT_VERSIONS_DEPENDENCY_SPEC = dependencyState -> dependencyState.getDependencyState().getDependency().isEndorsingStrictVersions();
    static final Spec<EdgeState> NOT_ENDORSE_STRICT_VERSIONS_DEPENDENCY_SPEC = dependencyState -> !dependencyState.getDependencyState().getDependency().isEndorsingStrictVersions();

    public DependencyGraphBuilder(DependencyToComponentIdResolver componentIdResolver, ComponentMetaDataResolver componentMetaDataResolver, ResolveContextToComponentResolver resolveContextToComponentResolver, ModuleConflictHandler moduleConflictHandler, CapabilitiesConflictHandler capabilitiesConflictHandler, Spec<? super DependencyMetadata> edgeFilter, AttributesSchemaInternal attributesSchema, ModuleExclusions moduleExclusions, BuildOperationExecutor buildOperationExecutor, DependencySubstitutionApplicator dependencySubstitutionApplicator, ComponentSelectorConverter componentSelectorConverter, ImmutableAttributesFactory attributesFactory, VersionSelectorScheme versionSelectorScheme, Comparator<Version> versionComparator, VersionParser versionParser) {
        this.idResolver = componentIdResolver;
        this.metaDataResolver = componentMetaDataResolver;
        this.moduleResolver = resolveContextToComponentResolver;
        this.moduleConflictHandler = moduleConflictHandler;
        this.edgeFilter = edgeFilter;
        this.attributesSchema = attributesSchema;
        this.moduleExclusions = moduleExclusions;
        this.buildOperationExecutor = buildOperationExecutor;
        this.dependencySubstitutionApplicator = dependencySubstitutionApplicator;
        this.componentSelectorConverter = componentSelectorConverter;
        this.attributesFactory = attributesFactory;
        this.capabilitiesConflictHandler = capabilitiesConflictHandler;
        this.versionSelectorScheme = versionSelectorScheme;
        this.versionComparator = versionComparator;
        this.versionParser = versionParser;
        this.conflictTracker = new ResolutionConflictTracker(moduleConflictHandler, capabilitiesConflictHandler);
    }

    public void resolve(ResolveContext resolveContext, DependencyGraphVisitor modelVisitor, boolean includeSyntheticDependencies) {
        LongIdGenerator idGenerator = new LongIdGenerator();
        DefaultBuildableComponentResolveResult rootModule = new DefaultBuildableComponentResolveResult();
        this.moduleResolver.resolve(resolveContext, rootModule);
        int graphSize = DependencyGraphBuilder.estimateSize(resolveContext);
        ResolutionStrategyInternal resolutionStrategy = resolveContext.getResolutionStrategy();
        List syntheticDependencies = includeSyntheticDependencies ? DependencyGraphBuilder.syntheticDependenciesOf(rootModule, resolveContext.getName()) : Collections.emptyList();
        ResolveState resolveState = new ResolveState((IdGenerator<Long>)idGenerator, rootModule, resolveContext.getName(), this.idResolver, this.metaDataResolver, this.edgeFilter, this.attributesSchema, this.moduleExclusions, this.componentSelectorConverter, this.attributesFactory, this.dependencySubstitutionApplicator, this.versionSelectorScheme, this.versionComparator, this.versionParser, this.moduleConflictHandler.getResolver(), graphSize, resolveContext.getResolutionStrategy().getConflictResolution(), syntheticDependencies, this.conflictTracker);
        HashMap componentIdentifierCache = Maps.newHashMapWithExpectedSize((int)(graphSize / 2));
        this.traverseGraph(resolveState, componentIdentifierCache);
        this.validateGraph(resolveState, resolutionStrategy.isFailingOnDynamicVersions(), resolutionStrategy.isFailingOnChangingVersions());
        this.assembleResult(resolveState, modelVisitor);
    }

    private static List<? extends DependencyMetadata> syntheticDependenciesOf(DefaultBuildableComponentResolveResult rootModule, String name) {
        ComponentResolveMetadata metadata = rootModule.getMetadata();
        if (metadata instanceof RootLocalComponentMetadata) {
            return ((RootLocalComponentMetadata)metadata).getSyntheticDependencies(name);
        }
        return Collections.emptyList();
    }

    private static int estimateSize(ResolveContext resolveContext) {
        int estimate = 0;
        if (resolveContext instanceof Configuration) {
            estimate = (int)(512.0 * Math.log(((Configuration)resolveContext).getAllDependencies().size()));
        }
        return Math.max(10, estimate);
    }

    private void traverseGraph(ResolveState resolveState, Map<ModuleVersionIdentifier, ComponentIdentifier> componentIdentifierCache) {
        resolveState.onMoreSelected(resolveState.getRoot());
        ArrayList dependencies = Lists.newArrayList();
        while (resolveState.peek() != null || this.moduleConflictHandler.hasConflicts() || this.capabilitiesConflictHandler.hasConflicts()) {
            if (resolveState.peek() != null) {
                NodeState node = resolveState.pop();
                LOGGER.debug("Visiting configuration {}.", (Object)node);
                this.registerCapabilities(resolveState, node);
                dependencies.clear();
                node.visitOutgoingDependencies(dependencies);
                boolean edgeWasProcessed = this.resolveEdges(node, dependencies, ENDORSE_STRICT_VERSIONS_DEPENDENCY_SPEC, false, resolveState, componentIdentifierCache);
                node.collectEndorsedStrictVersions(dependencies);
                this.resolveEdges(node, dependencies, NOT_ENDORSE_STRICT_VERSIONS_DEPENDENCY_SPEC, edgeWasProcessed, resolveState, componentIdentifierCache);
                continue;
            }
            if (this.moduleConflictHandler.hasConflicts()) {
                this.moduleConflictHandler.resolveNextConflict(resolveState.getReplaceSelectionWithConflictResultAction());
                continue;
            }
            this.capabilitiesConflictHandler.resolveNextConflict(resolveState.getReplaceSelectionWithConflictResultAction());
        }
    }

    private void registerCapabilities(final ResolveState resolveState, final NodeState node) {
        node.forEachCapability(this.capabilitiesConflictHandler, (Action<? super Capability>)new Action<Capability>(){

            public void execute(Capability capability) {
                PotentialConflict c;
                ArrayList implicitProvidersForCapability = Collections.emptyList();
                for (ModuleResolveState state : resolveState.getModules()) {
                    if (!state.getId().getGroup().equals(capability.getGroup()) || !state.getId().getName().equals(capability.getName())) continue;
                    Collection<ComponentState> versions = state.getVersions();
                    implicitProvidersForCapability = Lists.newArrayListWithExpectedSize((int)versions.size());
                    for (ComponentState version : versions) {
                        List<NodeState> nodes = version.getNodes();
                        for (NodeState nodeState : nodes) {
                            if (node == nodeState || !nodeState.isSelected() || !this.doesNotDeclareExplicitCapability(nodeState)) continue;
                            implicitProvidersForCapability.add(nodeState);
                        }
                    }
                }
                if ((c = DependencyGraphBuilder.this.capabilitiesConflictHandler.registerCandidate(DefaultCapabilitiesConflictHandler.candidate(node, capability, implicitProvidersForCapability))).conflictExists()) {
                    c.withParticipatingModules(resolveState.getDeselectVersionAction());
                }
            }

            private boolean doesNotDeclareExplicitCapability(NodeState nodeState) {
                return nodeState.getMetadata().getCapabilities().getCapabilities().isEmpty();
            }
        });
    }

    private boolean resolveEdges(NodeState node, List<EdgeState> dependencies, Spec<EdgeState> dependencyFilter, boolean recomputeSelectors, ResolveState resolveState, Map<ModuleVersionIdentifier, ComponentIdentifier> componentIdentifierCache) {
        if (dependencies.isEmpty()) {
            return false;
        }
        if (this.performSelectionSerially(dependencies, dependencyFilter, resolveState, recomputeSelectors)) {
            this.maybeDownloadMetadataInParallel(node, componentIdentifierCache, dependencies, dependencyFilter);
            this.attachToTargetRevisionsSerially(dependencies, dependencyFilter);
            return true;
        }
        return false;
    }

    private boolean performSelectionSerially(List<EdgeState> dependencies, Spec<EdgeState> dependencyFilter, ResolveState resolveState, boolean recomputeSelectors) {
        boolean processed = false;
        for (EdgeState dependency : dependencies) {
            if (!dependencyFilter.isSatisfiedBy((Object)dependency)) continue;
            if (recomputeSelectors) {
                dependency.computeSelector();
            }
            SelectorState selector = dependency.getSelector();
            ModuleResolveState module = selector.getTargetModule();
            if (selector.canResolve() && module.getSelectors().size() > 0) {
                this.performSelection(resolveState, module);
            }
            if (dependency.isUsed()) {
                module.addUnattachedDependency(dependency);
            }
            processed = true;
        }
        return processed;
    }

    private void performSelection(ResolveState resolveState, ModuleResolveState module) {
        ComponentState currentSelection = module.getSelected();
        try {
            module.maybeUpdateSelection(this.conflictTracker);
        }
        catch (ModuleVersionResolveException e) {
            return;
        }
        if (currentSelection == null) {
            this.checkForModuleConflicts(resolveState, module);
        }
    }

    private void checkForModuleConflicts(ResolveState resolveState, ModuleResolveState module) {
        PotentialConflict c = this.moduleConflictHandler.registerCandidate(module);
        if (c.conflictExists()) {
            LOGGER.debug("Found new conflicting module {}", (Object)module);
            c.withParticipatingModules(resolveState.getDeselectVersionAction());
        }
    }

    private void maybeDownloadMetadataInParallel(NodeState node, Map<ModuleVersionIdentifier, ComponentIdentifier> componentIdentifierCache, List<EdgeState> dependencies, Spec<EdgeState> dependencyFilter) {
        List requiringDownload = null;
        for (EdgeState dependency : dependencies) {
            ComponentState targetComponent;
            if (!dependencyFilter.isSatisfiedBy((Object)dependency) || (targetComponent = dependency.getTargetComponent()) == null || !targetComponent.isSelected() || targetComponent.alreadyResolved() || this.metaDataResolver.isFetchingMetadataCheap(this.toComponentId(targetComponent.getId(), componentIdentifierCache))) continue;
            if (requiringDownload == null) {
                requiringDownload = Lists.newArrayList();
            }
            requiringDownload.add(targetComponent);
        }
        if (requiringDownload != null && requiringDownload.size() > 1) {
            ImmutableList toDownloadInParallel = ImmutableList.copyOf((Collection)requiringDownload);
            LOGGER.debug("Submitting {} metadata files to resolve in parallel for {}", (Object)toDownloadInParallel.size(), (Object)node);
            this.buildOperationExecutor.runAll(buildOperationQueue -> {
                for (ComponentState componentState : toDownloadInParallel) {
                    buildOperationQueue.add((BuildOperation)new DownloadMetadataOperation(componentState));
                }
            }, BuildOperationConstraint.UNCONSTRAINED);
        }
    }

    private ComponentIdentifier toComponentId(ModuleVersionIdentifier id, Map<ModuleVersionIdentifier, ComponentIdentifier> componentIdentifierCache) {
        ComponentIdentifier identifier = componentIdentifierCache.get(id);
        if (identifier == null) {
            identifier = DefaultModuleComponentIdentifier.newId(id);
            componentIdentifierCache.put(id, identifier);
        }
        return identifier;
    }

    private void attachToTargetRevisionsSerially(List<EdgeState> dependencies, Spec<EdgeState> dependencyFilter) {
        for (EdgeState dependency : dependencies) {
            if (!dependencyFilter.isSatisfiedBy((Object)dependency)) continue;
            dependency.attachToTargetConfigurations();
        }
    }

    private void validateGraph(ResolveState resolveState, boolean denyDynamicSelectors, boolean denyChangingModules) {
        for (ModuleResolveState module : resolveState.getModules()) {
            ComponentState selected = module.getSelected();
            if (selected != null) {
                if (selected.isRejected()) {
                    GradleException error = new GradleException(selected.getRejectedErrorMessage());
                    this.attachFailureToEdges(error, module.getIncomingEdges());
                    this.attachFailureToEdges(error, module.getUnattachedDependencies());
                    continue;
                }
                if (module.isVirtualPlatform()) {
                    this.attachMultipleForceOnPlatformFailureToEdges(module);
                } else if (selected.hasMoreThanOneSelectedNodeUsingVariantAwareResolution()) {
                    this.validateMultipleNodeSelection(module, selected);
                }
                if (denyDynamicSelectors) {
                    this.validateDynamicSelectors(selected);
                }
                if (!denyChangingModules) continue;
                this.validateChangingVersions(selected);
                continue;
            }
            if (!module.isVirtualPlatform()) continue;
            this.attachMultipleForceOnPlatformFailureToEdges(module);
        }
    }

    private static boolean isDynamic(SelectorState selector) {
        ResolvedVersionConstraint versionConstraint = selector.getVersionConstraint();
        if (versionConstraint != null) {
            return versionConstraint.isDynamic();
        }
        return false;
    }

    private void validateDynamicSelectors(ComponentState selected) {
        ImmutableList selectors = ImmutableList.copyOf(selected.getModule().getSelectors());
        if (!selectors.isEmpty()) {
            if (selectors.stream().allMatch(DependencyGraphBuilder::isDynamic)) {
                this.markDeniedDynamicVersions(selected);
            } else if (selectors.stream().anyMatch(DependencyGraphBuilder::isDynamic)) {
                this.checkIfDynamicVersionAllowed(selected, (List<SelectorState>)selectors);
            }
        }
    }

    private void checkIfDynamicVersionAllowed(ComponentState selected, List<SelectorState> selectors) {
        String version = selected.getId().getVersion();
        boolean accept = false;
        for (SelectorState selector : selectors) {
            ResolvedVersionConstraint versionConstraint = selector.getVersionConstraint();
            if (!versionConstraint.isDynamic()) {
                if (!versionConstraint.accepts(version)) continue;
                accept = true;
                continue;
            }
            if (versionConstraint.canBeStable()) continue;
            accept = false;
            break;
        }
        if (!accept) {
            this.markDeniedDynamicVersions(selected);
        }
    }

    private void markDeniedDynamicVersions(ComponentState cs) {
        for (NodeState node : cs.getNodes()) {
            Collection incomingEdges = node.getIncomingEdges();
            for (EdgeState incomingEdge : incomingEdges) {
                ComponentSelector selector = incomingEdge.getSelector().getSelector();
                incomingEdge.failWith((Throwable)((Object)new ModuleVersionResolveException(selector, (Factory<String>)((Factory)() -> String.format("Could not resolve %s: Resolution strategy disallows usage of dynamic versions", selector)))));
            }
        }
    }

    private void validateChangingVersions(ComponentState selected) {
        ComponentResolveMetadata metadata = selected.getMetadata();
        boolean moduleIsChanging = metadata != null && metadata.isChanging();
        for (NodeState node : selected.getNodes()) {
            Collection incomingEdges = node.getIncomingEdges();
            for (EdgeState incomingEdge : incomingEdges) {
                if (!moduleIsChanging && !incomingEdge.getDependencyMetadata().isChanging()) continue;
                ComponentSelector selector = incomingEdge.getSelector().getSelector();
                incomingEdge.failWith((Throwable)((Object)new ModuleVersionResolveException(selector, (Factory<String>)((Factory)() -> String.format("Could not resolve %s: Resolution strategy disallows usage of changing versions", selector)))));
            }
        }
    }

    private void validateMultipleNodeSelection(ModuleResolveState module, ComponentState selected) {
        Set selectedNodes = selected.getNodes().stream().filter(n -> n.isSelected() && !n.isAttachedToVirtualPlatform() && !n.hasShadowedCapability()).collect(Collectors.toSet());
        if (selectedNodes.size() < 2) {
            return;
        }
        Set combinations = Sets.combinations(selectedNodes, (int)2);
        HashSet incompatibleNodes = Sets.newHashSet();
        for (Set combination : combinations) {
            Iterator it = combination.iterator();
            NodeState first = (NodeState)it.next();
            NodeState second = (NodeState)it.next();
            this.assertCompatibleAttributes(first, second, incompatibleNodes);
        }
        if (!incompatibleNodes.isEmpty()) {
            IncompatibleVariantsSelectionException variantsSelectionException = new IncompatibleVariantsSelectionException(IncompatibleVariantsSelectionMessageBuilder.buildMessage(selected, incompatibleNodes));
            for (EdgeState edge : module.getIncomingEdges()) {
                edge.failWith((Throwable)((Object)variantsSelectionException));
            }
        }
    }

    private void assertCompatibleAttributes(NodeState first, NodeState second, Set<NodeState> incompatibleNodes) {
        ImmutableAttributes firstAttributes = first.getMetadata().getAttributes();
        ImmutableAttributes secondAttributes = second.getMetadata().getAttributes();
        ImmutableSet firstKeys = firstAttributes.keySet();
        ImmutableSet secondKeys = secondAttributes.keySet();
        for (Attribute attribute : Sets.intersection((Set)firstKeys, (Set)secondKeys)) {
            Object v2;
            Object v1;
            CompatibilityRule<Object> rule = this.attributesSchema.compatibilityRules(attribute);
            if (DependencyGraphBuilder.compatible(rule, v1 = firstAttributes.getAttribute(attribute), v2 = secondAttributes.getAttribute(attribute)) || DependencyGraphBuilder.compatible(rule, v2, v1)) continue;
            incompatibleNodes.add(first);
            incompatibleNodes.add(second);
        }
    }

    private static boolean compatible(CompatibilityRule<Object> rule, @Nullable Object v1, @Nullable Object v2) {
        if (Objects.equals(v1, v2)) {
            return true;
        }
        DefaultCompatibilityCheckResult<Object> result = new DefaultCompatibilityCheckResult<Object>(v1, v2);
        rule.execute(result);
        return result.hasResult() && result.isCompatible();
    }

    private void attachMultipleForceOnPlatformFailureToEdges(ModuleResolveState module) {
        ArrayList forcedEdges = null;
        boolean hasMultipleVersions = false;
        String currentVersion = module.maybeFindForcedPlatformVersion();
        Set<ModuleResolveState> participatingModules = module.getPlatformState().getParticipatingModules();
        for (ModuleResolveState participatingModule : participatingModules) {
            for (EdgeState incomingEdge : participatingModule.getIncomingEdges()) {
                ComponentSelector componentSelector;
                SelectorState selector = incomingEdge.getSelector();
                if (!DependencyGraphBuilder.isPlatformForcedEdge(selector) || !((componentSelector = selector.getSelector()) instanceof ModuleComponentSelector)) continue;
                ModuleComponentSelector mcs = (ModuleComponentSelector)componentSelector;
                if (incomingEdge.getFrom().getComponent().getModule().equals(module)) continue;
                if (forcedEdges == null) {
                    forcedEdges = Lists.newArrayList();
                }
                forcedEdges.add(incomingEdge);
                if (currentVersion == null) {
                    currentVersion = mcs.getVersion();
                    continue;
                }
                if (currentVersion.equals(mcs.getVersion())) continue;
                hasMultipleVersions = true;
            }
        }
        if (hasMultipleVersions) {
            this.attachFailureToEdges(new GradleException("Multiple forces on different versions for virtual platform " + module.getId()), forcedEdges);
        }
    }

    private static boolean isPlatformForcedEdge(SelectorState selector) {
        return selector.isForce() && !selector.isSoftForce();
    }

    private void attachFailureToEdges(GradleException error, Collection<EdgeState> incomingEdges) {
        for (EdgeState edge : incomingEdges) {
            edge.failWith((Throwable)error);
        }
    }

    private void assembleResult(ResolveState resolveState, DependencyGraphVisitor visitor) {
        visitor.start(resolveState.getRoot());
        for (DependencyGraphSelector dependencyGraphSelector : resolveState.getSelectors()) {
            visitor.visitSelector(dependencyGraphSelector);
        }
        for (NodeState nodeState : resolveState.getNodes()) {
            if (!nodeState.shouldIncludedInGraphResult()) continue;
            visitor.visitNode(nodeState);
        }
        LinkedList queue = Lists.newLinkedList();
        for (ModuleResolveState module : resolveState.getModules()) {
            if (module.getSelected() == null || module.isVirtualPlatform()) continue;
            queue.add(module.getSelected());
        }
        while (!queue.isEmpty()) {
            ComponentState componentState = (ComponentState)queue.peekFirst();
            if (componentState.getVisitState() == VisitState.NotSeen) {
                componentState.setVisitState(VisitState.Visiting);
                int pos = 0;
                for (NodeState node : componentState.getNodes()) {
                    if (!node.isSelected()) continue;
                    for (EdgeState edge : node.getIncomingEdges()) {
                        ComponentState owner = edge.getFrom().getOwner();
                        if (owner.getVisitState() != VisitState.NotSeen || owner.getModule().isVirtualPlatform()) continue;
                        queue.add(pos, owner);
                        ++pos;
                    }
                }
                if (pos != 0) continue;
                componentState.setVisitState(VisitState.Visited);
                queue.removeFirst();
                for (NodeState node : componentState.getNodes()) {
                    if (!node.isSelected()) continue;
                    visitor.visitEdges(node);
                }
                continue;
            }
            if (componentState.getVisitState() == VisitState.Visiting) {
                componentState.setVisitState(VisitState.Visited);
                queue.removeFirst();
                for (NodeState node : componentState.getNodes()) {
                    if (!node.isSelected()) continue;
                    visitor.visitEdges(node);
                }
                continue;
            }
            queue.removeFirst();
        }
        visitor.finish(resolveState.getRoot());
    }

    static enum VisitState {
        NotSeen,
        Visiting,
        Visited;

    }
}

