/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.normalization.java.impl;

import java.util.Set;
import org.gradle.internal.normalization.java.impl.AnnotationAnnotationValue;
import org.gradle.internal.normalization.java.impl.AnnotationMember;
import org.gradle.internal.normalization.java.impl.AnnotationValue;
import org.gradle.internal.normalization.java.impl.ArrayAnnotationValue;
import org.gradle.internal.normalization.java.impl.ClassMember;
import org.gradle.internal.normalization.java.impl.EnumAnnotationValue;
import org.gradle.internal.normalization.java.impl.FieldMember;
import org.gradle.internal.normalization.java.impl.InnerClassMember;
import org.gradle.internal.normalization.java.impl.MethodMember;
import org.gradle.internal.normalization.java.impl.ParameterAnnotationMember;
import org.gradle.internal.normalization.java.impl.SimpleAnnotationValue;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.ModuleVisitor;

public class ApiMemberWriter {
    private final ClassVisitor apiMemberAdapter;

    public ApiMemberWriter(ClassVisitor apiMemberAdapter) {
        this.apiMemberAdapter = apiMemberAdapter;
    }

    public ModuleVisitor writeModule(String name, int access, String version) {
        return this.apiMemberAdapter.visitModule(name, access, version);
    }

    public void writeClass(ClassMember classMember, Set<MethodMember> methods, Set<FieldMember> fields, Set<InnerClassMember> innerClasses) {
        this.apiMemberAdapter.visit(classMember.getVersion(), classMember.getAccess(), classMember.getName(), classMember.getSignature(), classMember.getSuperName(), classMember.getInterfaces());
        this.writeClassAnnotations(classMember.getAnnotations());
        for (MethodMember method : methods) {
            this.writeMethod(method);
        }
        for (FieldMember field : fields) {
            FieldVisitor fieldVisitor = this.apiMemberAdapter.visitField(field.getAccess(), field.getName(), field.getTypeDesc(), field.getSignature(), field.getValue());
            this.writeFieldAnnotations(fieldVisitor, field.getAnnotations());
            fieldVisitor.visitEnd();
        }
        for (InnerClassMember innerClass : innerClasses) {
            this.apiMemberAdapter.visitInnerClass(innerClass.getName(), innerClass.getOuterName(), innerClass.getInnerName(), innerClass.getAccess());
        }
        this.apiMemberAdapter.visitEnd();
    }

    protected void writeMethod(MethodMember method) {
        MethodVisitor mv = this.apiMemberAdapter.visitMethod(method.getAccess(), method.getName(), method.getTypeDesc(), method.getSignature(), method.getExceptions().toArray(new String[0]));
        this.writeMethodAnnotations(mv, method.getAnnotations());
        this.writeMethodAnnotations(mv, method.getParameterAnnotations());
        mv.visitEnd();
    }

    protected void writeClassAnnotations(Set<AnnotationMember> annotationMembers) {
        for (AnnotationMember annotation : annotationMembers) {
            AnnotationVisitor annotationVisitor = this.apiMemberAdapter.visitAnnotation(annotation.getName(), annotation.isVisible());
            this.writeAnnotationValues(annotation, annotationVisitor);
        }
    }

    private void writeMethodAnnotations(MethodVisitor mv, Set<AnnotationMember> annotationMembers) {
        for (AnnotationMember annotation : annotationMembers) {
            AnnotationVisitor annotationVisitor = annotation instanceof ParameterAnnotationMember ? mv.visitParameterAnnotation(((ParameterAnnotationMember)annotation).getParameter(), annotation.getName(), annotation.isVisible()) : mv.visitAnnotation(annotation.getName(), annotation.isVisible());
            this.writeAnnotationValues(annotation, annotationVisitor);
        }
    }

    private void writeFieldAnnotations(FieldVisitor fv, Set<AnnotationMember> annotationMembers) {
        for (AnnotationMember annotation : annotationMembers) {
            AnnotationVisitor annotationVisitor = fv.visitAnnotation(annotation.getName(), annotation.isVisible());
            this.writeAnnotationValues(annotation, annotationVisitor);
        }
    }

    private void writeAnnotationValues(AnnotationMember annotation, AnnotationVisitor annotationVisitor) {
        for (AnnotationValue annotationValue : annotation.getValues()) {
            this.writeAnnotationValue(annotationVisitor, annotationValue);
        }
        annotationVisitor.visitEnd();
    }

    private void writeAnnotationValue(AnnotationVisitor annotationVisitor, AnnotationValue<?> value) {
        String name = value.getName();
        if (value instanceof EnumAnnotationValue) {
            annotationVisitor.visitEnum(name, ((EnumAnnotationValue)value).getTypeDesc(), (String)value.getValue());
        } else if (value instanceof SimpleAnnotationValue) {
            annotationVisitor.visit(name, value.getValue());
        } else if (value instanceof ArrayAnnotationValue) {
            AnnotationValue[] values;
            AnnotationVisitor arrayVisitor = annotationVisitor.visitArray(name);
            for (AnnotationValue annotationValue : values = (AnnotationValue[])((ArrayAnnotationValue)value).getValue()) {
                this.writeAnnotationValue(arrayVisitor, annotationValue);
            }
            arrayVisitor.visitEnd();
        } else if (value instanceof AnnotationAnnotationValue) {
            AnnotationMember annotation = (AnnotationMember)((AnnotationAnnotationValue)value).getValue();
            AnnotationVisitor annVisitor = annotationVisitor.visitAnnotation(name, annotation.getName());
            this.writeAnnotationValues(annotation, annVisitor);
        }
    }
}

