/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.OrElseValueProducer;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;

class OrElseProvider<T>
extends AbstractMinimalProvider<T> {
    private final ProviderInternal<T> left;
    private final ProviderInternal<? extends T> right;

    public OrElseProvider(ProviderInternal<T> left, ProviderInternal<? extends T> right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public String toString() {
        return String.format("or(%s, %s)", this.left, this.right);
    }

    @Override
    @Nullable
    public Class<T> getType() {
        return this.left.getType();
    }

    @Override
    public ValueSupplier.ValueProducer getProducer() {
        return new OrElseValueProducer(this.left, this.right, this.right.getProducer());
    }

    @Override
    public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
        return this.left.calculatePresence(consumer) || this.right.calculatePresence(consumer);
    }

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends T> calculateExecutionTimeValue() {
        ValueSupplier.ExecutionTimeValue<T> leftValue = this.left.calculateExecutionTimeValue();
        if (leftValue.isFixedValue()) {
            return leftValue;
        }
        ValueSupplier.ExecutionTimeValue<T> rightValue = this.right.calculateExecutionTimeValue();
        if (leftValue.isMissing()) {
            return rightValue;
        }
        if (rightValue.isMissing()) {
            return leftValue;
        }
        return ValueSupplier.ExecutionTimeValue.changingValue(new OrElseProvider<T>(leftValue.getChangingValue(), rightValue.toProvider()));
    }

    @Override
    protected ValueSupplier.Value<? extends T> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        ValueSupplier.Value<T> leftValue = this.left.calculateValue(consumer);
        if (!leftValue.isMissing()) {
            return leftValue;
        }
        ValueSupplier.Value<T> rightValue = this.right.calculateValue(consumer);
        if (!rightValue.isMissing()) {
            return rightValue;
        }
        return leftValue.addPathsFrom(rightValue);
    }
}

