/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.codeStyle;

import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.Strings;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.MinusculeMatcher;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.NameUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.FList;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayCharSequence;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.text.NameUtilCore;

class MinusculeMatcherImpl
extends MinusculeMatcher {
    private final char[] myPattern;
    private final String myHardSeparators;
    private final NameUtil.MatchingCaseSensitivity myOptions;
    private final boolean myHasHumps;
    private final boolean myHasSeparators;
    private final boolean myHasDots;
    private final boolean[] isLowerCase;
    private final boolean[] isUpperCase;
    private final boolean[] isWordSeparator;
    private final char[] toUpperCase;
    private final char[] toLowerCase;
    private final char[] myMeaningfulCharacters;
    private final int myMinNameLength;

    MinusculeMatcherImpl(@NotNull String pattern, @NotNull NameUtil.MatchingCaseSensitivity options, @NotNull String hardSeparators) {
        if (pattern == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(0);
        }
        if (options == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(1);
        }
        if (hardSeparators == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(2);
        }
        this.myOptions = options;
        this.myPattern = Strings.trimEnd(pattern, "* ").toCharArray();
        this.myHardSeparators = hardSeparators;
        this.isLowerCase = new boolean[this.myPattern.length];
        this.isUpperCase = new boolean[this.myPattern.length];
        this.isWordSeparator = new boolean[this.myPattern.length];
        this.toUpperCase = new char[this.myPattern.length];
        this.toLowerCase = new char[this.myPattern.length];
        StringBuilder meaningful = new StringBuilder();
        for (int k = 0; k < this.myPattern.length; ++k) {
            char c = this.myPattern[k];
            this.isLowerCase[k] = Character.isLowerCase(c);
            this.isUpperCase[k] = Character.isUpperCase(c);
            this.isWordSeparator[k] = MinusculeMatcherImpl.isWordSeparator(c);
            this.toUpperCase[k] = Strings.toUpperCase(c);
            this.toLowerCase[k] = Strings.toLowerCase(c);
            if (this.isWildcard(k)) continue;
            meaningful.append(this.toLowerCase[k]);
            meaningful.append(this.toUpperCase[k]);
        }
        int i = 0;
        while (this.isWildcard(i)) {
            ++i;
        }
        this.myHasHumps = this.hasFlag(i + 1, this.isUpperCase) && this.hasFlag(i, this.isLowerCase);
        this.myHasSeparators = this.hasFlag(i, this.isWordSeparator);
        this.myHasDots = this.hasDots(i);
        this.myMeaningfulCharacters = meaningful.toString().toCharArray();
        this.myMinNameLength = this.myMeaningfulCharacters.length / 2;
    }

    private static boolean isWordSeparator(char c) {
        return Character.isWhitespace(c) || c == '_' || c == '-' || c == ':' || c == '+' || c == '.';
    }

    private static int nextWord(@NotNull String name, int start) {
        if (name == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(3);
        }
        if (start < name.length() && Character.isDigit(name.charAt(start))) {
            return start + 1;
        }
        return NameUtilCore.nextWord(name, start);
    }

    private boolean hasFlag(int start, boolean[] flags) {
        for (int i = start; i < this.myPattern.length; ++i) {
            if (!flags[i]) continue;
            return true;
        }
        return false;
    }

    private boolean hasDots(int start) {
        for (int i = start; i < this.myPattern.length; ++i) {
            if (this.myPattern[i] != '.') continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static FList<TextRange> prependRange(@NotNull FList<TextRange> ranges2, int from2, int length) {
        TextRange head;
        if (ranges2 == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(4);
        }
        if ((head = ranges2.getHead()) != null && head.getStartOffset() == from2 + length) {
            FList<TextRange> fList = ranges2.getTail().prepend(new TextRange(from2, head.getEndOffset()));
            if (fList == null) {
                MinusculeMatcherImpl.$$$reportNull$$$0(5);
            }
            return fList;
        }
        FList<TextRange> fList = ranges2.prepend(TextRange.from(from2, length));
        if (fList == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(6);
        }
        return fList;
    }

    @Override
    public int matchingDegree(@NotNull String name, boolean valueStartCaseMatch, @Nullable FList<? extends TextRange> fragments2) {
        if (name == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(7);
        }
        if (fragments2 == null) {
            return Integer.MIN_VALUE;
        }
        if (fragments2.isEmpty()) {
            return 0;
        }
        TextRange first = fragments2.getHead();
        boolean startMatch = first.getStartOffset() == 0;
        boolean valuedStartMatch = startMatch && valueStartCaseMatch;
        int matchingCase = 0;
        int p = -1;
        int skippedHumps = 0;
        int nextHumpStart = 0;
        boolean humpStartMatchedUpperCase = false;
        block0: for (TextRange textRange : fragments2) {
            for (int i = textRange.getStartOffset(); i < textRange.getEndOffset(); ++i) {
                boolean afterGap = i == textRange.getStartOffset() && first != textRange;
                boolean isHumpStart = false;
                while (nextHumpStart <= i) {
                    if (nextHumpStart == i) {
                        isHumpStart = true;
                    } else if (afterGap) {
                        ++skippedHumps;
                    }
                    nextHumpStart = MinusculeMatcherImpl.nextWord(name, nextHumpStart);
                }
                char c = name.charAt(i);
                p = Strings.indexOf(this.myPattern, c, p + 1, this.myPattern.length, false);
                if (p < 0) continue block0;
                if (isHumpStart) {
                    humpStartMatchedUpperCase = c == this.myPattern[p] && this.isUpperCase[p];
                }
                matchingCase += this.evaluateCaseMatching(valuedStartMatch, p, humpStartMatchedUpperCase, i, afterGap, isHumpStart, c);
            }
        }
        int startIndex = first.getStartOffset();
        boolean bl = Strings.indexOfAny(name, this.myHardSeparators, 0, startIndex) >= 0;
        boolean wordStart = startIndex == 0 || NameUtilCore.isWordStart(name, startIndex) && !NameUtilCore.isWordStart(name, startIndex - 1);
        boolean finalMatch = fragments2.get(fragments2.size() - 1).getEndOffset() == name.length();
        return (wordStart ? 1000 : 0) + matchingCase + -fragments2.size() + -skippedHumps * 10 + (bl ? 0 : 2) + (startMatch ? 1 : 0) + (finalMatch ? 1 : 0);
    }

    private int evaluateCaseMatching(boolean valuedStartMatch, int patternIndex, boolean humpStartMatchedUpperCase, int nameIndex, boolean afterGap, boolean isHumpStart, char nameChar) {
        if (afterGap && isHumpStart && this.isLowerCase[patternIndex]) {
            return -10;
        }
        if (nameChar == this.myPattern[patternIndex]) {
            if (this.isUpperCase[patternIndex]) {
                return 50;
            }
            if (nameIndex == 0 && valuedStartMatch) {
                return 150;
            }
            if (isHumpStart) {
                return 1;
            }
        } else {
            if (isHumpStart) {
                return -1;
            }
            if (this.isLowerCase[patternIndex] && humpStartMatchedUpperCase) {
                return -1;
            }
        }
        return 0;
    }

    @Override
    @NotNull
    public String getPattern() {
        return new String(this.myPattern);
    }

    @Override
    @Nullable
    public FList<TextRange> matchingFragments(@NotNull String name) {
        if (name == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(8);
        }
        if (name.length() < this.myMinNameLength) {
            return null;
        }
        if (this.myPattern.length > 100) {
            return this.matchBySubstring(name);
        }
        int length = name.length();
        int patternIndex = 0;
        boolean isAscii = true;
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (c >= '\u0080') {
                isAscii = false;
            }
            if (patternIndex >= this.myMeaningfulCharacters.length || c != this.myMeaningfulCharacters[patternIndex] && c != this.myMeaningfulCharacters[patternIndex + 1]) continue;
            patternIndex += 2;
        }
        if (patternIndex < this.myMinNameLength * 2) {
            return null;
        }
        return this.matchWildcards(name, 0, 0, isAscii);
    }

    @Nullable
    private FList<TextRange> matchBySubstring(@NotNull String name) {
        if (name == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(9);
        }
        boolean infix = this.isPatternChar(0, '*');
        char[] patternWithoutWildChar = MinusculeMatcherImpl.filterWildcard(this.myPattern);
        if (name.length() < patternWithoutWildChar.length) {
            return null;
        }
        if (infix) {
            int index2 = Strings.indexOfIgnoreCase((CharSequence)name, new CharArrayCharSequence(patternWithoutWildChar, 0, patternWithoutWildChar.length), 0);
            if (index2 >= 0) {
                return FList.emptyList().prepend(TextRange.from(index2, patternWithoutWildChar.length - 1));
            }
            return null;
        }
        if (CharArrayUtil.regionMatches(patternWithoutWildChar, 0, patternWithoutWildChar.length, (CharSequence)name)) {
            return FList.emptyList().prepend(new TextRange(0, patternWithoutWildChar.length));
        }
        return null;
    }

    private static char[] filterWildcard(char[] source) {
        char[] buffer = new char[source.length];
        int i = 0;
        for (char c : source) {
            if (c == '*') continue;
            buffer[i++] = c;
        }
        return Arrays.copyOf(buffer, i);
    }

    @Nullable
    private FList<TextRange> matchWildcards(@NotNull String name, int patternIndex, int nameIndex, boolean isAsciiName) {
        if (name == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(10);
        }
        if (nameIndex < 0) {
            return null;
        }
        if (!this.isWildcard(patternIndex)) {
            if (patternIndex == this.myPattern.length) {
                return FList.emptyList();
            }
            return this.matchFragment(name, patternIndex, nameIndex, isAsciiName);
        }
        while (this.isWildcard(++patternIndex)) {
        }
        if (patternIndex == this.myPattern.length) {
            if (this.isTrailingSpacePattern() && nameIndex != name.length() && (patternIndex < 2 || !MinusculeMatcherImpl.isUpperCaseOrDigit(this.myPattern[patternIndex - 2]))) {
                int spaceIndex = name.indexOf(32, nameIndex);
                if (spaceIndex >= 0) {
                    return FList.emptyList().prepend(TextRange.from(spaceIndex, 1));
                }
                return null;
            }
            return FList.emptyList();
        }
        return this.matchSkippingWords(name, patternIndex, this.findNextPatternCharOccurrence(name, nameIndex, patternIndex, isAsciiName), true, isAsciiName);
    }

    private boolean isTrailingSpacePattern() {
        return this.isPatternChar(this.myPattern.length - 1, ' ');
    }

    private static boolean isUpperCaseOrDigit(char p) {
        return Character.isUpperCase(p) || Character.isDigit(p);
    }

    @Nullable
    private FList<TextRange> matchSkippingWords(@NotNull String name, int patternIndex, int nameIndex, boolean allowSpecialChars, boolean isAsciiName) {
        if (name == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(11);
        }
        int maxFoundLength = 0;
        while (nameIndex >= 0) {
            int fragmentLength;
            int n = fragmentLength = this.seemsLikeFragmentStart(name, patternIndex, nameIndex) ? this.maxMatchingFragment(name, patternIndex, nameIndex) : 0;
            if (fragmentLength > maxFoundLength || nameIndex + fragmentLength == name.length() && this.isTrailingSpacePattern()) {
                FList<TextRange> ranges2;
                if (!this.isMiddleMatch(name, patternIndex, nameIndex)) {
                    maxFoundLength = fragmentLength;
                }
                if ((ranges2 = this.matchInsideFragment(name, patternIndex, nameIndex, isAsciiName, fragmentLength)) != null) {
                    return ranges2;
                }
            }
            int next = this.findNextPatternCharOccurrence(name, nameIndex + 1, patternIndex, isAsciiName);
            nameIndex = allowSpecialChars ? next : this.checkForSpecialChars(name, nameIndex + 1, next, patternIndex);
        }
        return null;
    }

    private int findNextPatternCharOccurrence(@NotNull String name, int startAt, int patternIndex, boolean isAsciiName) {
        if (name == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(12);
        }
        return !this.isPatternChar(patternIndex - 1, '*') && !this.isWordSeparator[patternIndex] ? this.indexOfWordStart(name, patternIndex, startAt, isAsciiName) : this.indexOfIgnoreCase(name, startAt, this.myPattern[patternIndex], patternIndex, isAsciiName);
    }

    private int checkForSpecialChars(String name, int start, int end, int patternIndex) {
        if (end < 0) {
            return -1;
        }
        if (!this.myHasSeparators && !this.myHasHumps && Strings.containsAnyChar(name, this.myHardSeparators, start, end)) {
            return -1;
        }
        if (this.myHasDots && !this.isPatternChar(patternIndex - 1, '.') && Strings.contains(name, start, end, '.')) {
            return -1;
        }
        return end;
    }

    private boolean seemsLikeFragmentStart(@NotNull String name, int patternIndex, int nextOccurrence) {
        if (name == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(13);
        }
        return !this.isUpperCase[patternIndex] || Character.isUpperCase(name.charAt(nextOccurrence)) || NameUtilCore.isWordStart(name, nextOccurrence) || !this.myHasHumps && this.myOptions != NameUtil.MatchingCaseSensitivity.ALL;
    }

    private boolean charEquals(char patternChar, int patternIndex, char c, boolean isIgnoreCase) {
        return patternChar == c || isIgnoreCase && (this.toLowerCase[patternIndex] == c || this.toUpperCase[patternIndex] == c);
    }

    @Nullable
    private FList<TextRange> matchFragment(@NotNull String name, int patternIndex, int nameIndex, boolean isAsciiName) {
        int fragmentLength;
        if (name == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(14);
        }
        return (fragmentLength = this.maxMatchingFragment(name, patternIndex, nameIndex)) == 0 ? null : this.matchInsideFragment(name, patternIndex, nameIndex, isAsciiName, fragmentLength);
    }

    private int maxMatchingFragment(@NotNull String name, int patternIndex, int nameIndex) {
        boolean ignoreCase;
        if (name == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(15);
        }
        if (!this.isFirstCharMatching(name, nameIndex, patternIndex)) {
            return 0;
        }
        int i = 1;
        boolean bl = ignoreCase = this.myOptions != NameUtil.MatchingCaseSensitivity.ALL;
        while (nameIndex + i < name.length() && patternIndex + i < this.myPattern.length) {
            char nameChar = name.charAt(nameIndex + i);
            if (!this.charEquals(this.myPattern[patternIndex + i], patternIndex + i, nameChar, ignoreCase)) {
                if (!this.isSkippingDigitBetweenPatternDigits(patternIndex + i, nameChar)) break;
                return 0;
            }
            ++i;
        }
        return i;
    }

    private boolean isSkippingDigitBetweenPatternDigits(int patternIndex, char nameChar) {
        return Character.isDigit(this.myPattern[patternIndex]) && Character.isDigit(this.myPattern[patternIndex - 1]) && Character.isDigit(nameChar);
    }

    @Nullable
    private FList<TextRange> matchInsideFragment(@NotNull String name, int patternIndex, int nameIndex, boolean isAsciiName, int fragmentLength) {
        int minFragment;
        FList<TextRange> camelHumpRanges;
        if (name == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(16);
        }
        if ((camelHumpRanges = this.improveCamelHumps(name, patternIndex, nameIndex, isAsciiName, fragmentLength, minFragment = this.isMiddleMatch(name, patternIndex, nameIndex) ? 3 : 1)) != null) {
            return camelHumpRanges;
        }
        return this.findLongestMatchingPrefix(name, patternIndex, nameIndex, isAsciiName, fragmentLength, minFragment);
    }

    private boolean isMiddleMatch(@NotNull String name, int patternIndex, int nameIndex) {
        if (name == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(17);
        }
        return this.isPatternChar(patternIndex - 1, '*') && !this.isWildcard(patternIndex + 1) && Character.isLetterOrDigit(name.charAt(nameIndex)) && !NameUtilCore.isWordStart(name, nameIndex);
    }

    @Nullable
    private FList<TextRange> findLongestMatchingPrefix(@NotNull String name, int patternIndex, int nameIndex, boolean isAsciiName, int fragmentLength, int minFragment) {
        if (name == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(18);
        }
        if (patternIndex + fragmentLength >= this.myPattern.length) {
            return FList.emptyList().prepend(TextRange.from(nameIndex, fragmentLength));
        }
        for (int i = fragmentLength; i >= minFragment || i > 0 && this.isWildcard(patternIndex + i); --i) {
            FList<TextRange> ranges2;
            if (this.isWildcard(patternIndex + i)) {
                ranges2 = this.matchWildcards(name, patternIndex + i, nameIndex + i, isAsciiName);
            } else {
                int nextOccurrence = this.findNextPatternCharOccurrence(name, nameIndex + i + 1, patternIndex + i, isAsciiName);
                ranges2 = (nextOccurrence = this.checkForSpecialChars(name, nameIndex + i, nextOccurrence, patternIndex + i)) >= 0 ? this.matchSkippingWords(name, patternIndex + i, nextOccurrence, false, isAsciiName) : null;
            }
            if (ranges2 == null) continue;
            return MinusculeMatcherImpl.prependRange(ranges2, nameIndex, i);
        }
        return null;
    }

    private FList<TextRange> improveCamelHumps(@NotNull String name, int patternIndex, int nameIndex, boolean isAsciiName, int maxFragment, int minFragment) {
        if (name == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(19);
        }
        for (int i = minFragment; i < maxFragment; ++i) {
            FList<TextRange> ranges2;
            if (!this.isUppercasePatternVsLowercaseNameChar(name, patternIndex + i, nameIndex + i) || (ranges2 = this.findUppercaseMatchFurther(name, patternIndex + i, nameIndex + i, isAsciiName)) == null) continue;
            return MinusculeMatcherImpl.prependRange(ranges2, nameIndex, i);
        }
        return null;
    }

    private boolean isUppercasePatternVsLowercaseNameChar(String name, int patternIndex, int nameIndex) {
        return this.isUpperCase[patternIndex] && this.myPattern[patternIndex] != name.charAt(nameIndex);
    }

    private FList<TextRange> findUppercaseMatchFurther(String name, int patternIndex, int nameIndex, boolean isAsciiName) {
        int nextWordStart = this.indexOfWordStart(name, patternIndex, nameIndex, isAsciiName);
        return this.matchWildcards(name, patternIndex, nextWordStart, isAsciiName);
    }

    private boolean isFirstCharMatching(@NotNull String name, int nameIndex, int patternIndex) {
        if (name == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(20);
        }
        if (nameIndex >= name.length()) {
            return false;
        }
        boolean ignoreCase = this.myOptions != NameUtil.MatchingCaseSensitivity.ALL;
        char patternChar = this.myPattern[patternIndex];
        if (!this.charEquals(patternChar, patternIndex, name.charAt(nameIndex), ignoreCase)) {
            return false;
        }
        return this.myOptions != NameUtil.MatchingCaseSensitivity.FIRST_LETTER || patternIndex != 0 && (patternIndex != 1 || !this.isWildcard(0)) || !MinusculeMatcherImpl.hasCase(patternChar) || Character.isUpperCase(patternChar) == Character.isUpperCase(name.charAt(0));
    }

    private static boolean hasCase(char patternChar) {
        return Character.isUpperCase(patternChar) || Character.isLowerCase(patternChar);
    }

    private boolean isWildcard(int patternIndex) {
        if (patternIndex >= 0 && patternIndex < this.myPattern.length) {
            char pc = this.myPattern[patternIndex];
            return pc == ' ' || pc == '*';
        }
        return false;
    }

    private boolean isPatternChar(int patternIndex, char c) {
        return patternIndex >= 0 && patternIndex < this.myPattern.length && this.myPattern[patternIndex] == c;
    }

    private int indexOfWordStart(@NotNull String name, int patternIndex, int startFrom, boolean isAsciiName) {
        boolean isSpecialSymbol;
        if (name == null) {
            MinusculeMatcherImpl.$$$reportNull$$$0(21);
        }
        char p = this.myPattern[patternIndex];
        if (startFrom >= name.length() || this.myHasHumps && this.isLowerCase[patternIndex] && (patternIndex <= 0 || !this.isWordSeparator[patternIndex - 1])) {
            return -1;
        }
        int i = startFrom;
        boolean bl = isSpecialSymbol = !Character.isLetterOrDigit(p);
        while ((i = this.indexOfIgnoreCase(name, i, p, patternIndex, isAsciiName)) >= 0) {
            if (isSpecialSymbol || NameUtilCore.isWordStart(name, i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int indexOfIgnoreCase(String name, int fromIndex, char p, int patternIndex, boolean isAsciiName) {
        if (isAsciiName && Strings.isAscii(p)) {
            char pUpper = this.toUpperCase[patternIndex];
            char pLower = this.toLowerCase[patternIndex];
            for (int i = fromIndex; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (c != p && MinusculeMatcherImpl.toUpperAscii(c) != pUpper && MinusculeMatcherImpl.toLowerAscii(c) != pLower) continue;
                return i;
            }
            return -1;
        }
        return Strings.indexOfIgnoreCase(name, p, fromIndex);
    }

    private static char toUpperAscii(char c) {
        if (c >= 'a' && c <= 'z') {
            return (char)(c + -32);
        }
        return c;
    }

    private static char toLowerAscii(char c) {
        if (c >= 'A' && c <= 'Z') {
            return (char)(c - -32);
        }
        return c;
    }

    @NonNls
    public String toString() {
        return "MinusculeMatcherImpl{myPattern=" + new String(this.myPattern) + ", myOptions=" + (Object)((Object)this.myOptions) + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hardSeparators";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/codeStyle/MinusculeMatcherImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/codeStyle/MinusculeMatcherImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "prependRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "nextWord";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prependRange";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "matchingDegree";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "matchingFragments";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "matchBySubstring";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "matchWildcards";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "matchSkippingWords";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findNextPatternCharOccurrence";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "seemsLikeFragmentStart";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "matchFragment";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "maxMatchingFragment";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "matchInsideFragment";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isMiddleMatch";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findLongestMatchingPrefix";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "improveCamelHumps";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isFirstCharMatching";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "indexOfWordStart";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

