/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.install.internal;

import java.io.File;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.cache.FileLock;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.install.internal.AdoptOpenJdkRemoteBinary;
import org.gradle.jvm.toolchain.install.internal.JavaToolchainProvisioningService;
import org.gradle.jvm.toolchain.install.internal.JdkCacheDirectory;

public class DefaultJavaToolchainProvisioningService
implements JavaToolchainProvisioningService {
    public static final String AUTO_DOWNLOAD = "org.gradle.java.installations.auto-download";
    private final AdoptOpenJdkRemoteBinary openJdkBinary;
    private final JdkCacheDirectory cacheDirProvider;
    private final Provider<Boolean> downloadEnabled;
    private final BuildOperationExecutor buildOperationExecutor;
    private static final Object PROVISIONING_PROCESS_LOCK = new Object();

    @Inject
    public DefaultJavaToolchainProvisioningService(AdoptOpenJdkRemoteBinary openJdkBinary, JdkCacheDirectory cacheDirProvider, ProviderFactory factory, BuildOperationExecutor executor) {
        this.openJdkBinary = openJdkBinary;
        this.cacheDirProvider = cacheDirProvider;
        this.downloadEnabled = factory.gradleProperty(AUTO_DOWNLOAD).map(Boolean::parseBoolean);
        this.buildOperationExecutor = executor;
    }

    @Override
    public Optional<File> tryInstall(JavaToolchainSpec spec) {
        if (!this.isAutoDownloadEnabled() || !this.openJdkBinary.canProvideMatchingJdk(spec)) {
            return Optional.empty();
        }
        return this.provisionInstallation(spec);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<File> provisionInstallation(JavaToolchainSpec spec) {
        Object object = PROVISIONING_PROCESS_LOCK;
        synchronized (object) {
            String destinationFilename = this.openJdkBinary.toFilename(spec);
            File destinationFile = this.cacheDirProvider.getDownloadLocation(destinationFilename);
            try (FileLock fileLock = this.cacheDirProvider.acquireWriteLock(destinationFile, "Downloading toolchain");){
                Optional optional = this.wrapInOperation("Provisioning toolchain " + destinationFile.getName(), () -> this.provisionJdk(spec, destinationFile));
                return optional;
            }
        }
    }

    private Optional<File> provisionJdk(JavaToolchainSpec spec, File destinationFile) {
        Optional<File> jdkArchive = destinationFile.exists() ? Optional.of(destinationFile) : this.openJdkBinary.download(spec, destinationFile);
        return this.wrapInOperation("Unpacking toolchain archive", () -> jdkArchive.map(this.cacheDirProvider::provisionFromArchive));
    }

    private boolean isAutoDownloadEnabled() {
        return (Boolean)this.downloadEnabled.getOrElse((Object)true);
    }

    private <T> T wrapInOperation(String displayName, Callable<T> provisioningStep) {
        return (T)this.buildOperationExecutor.call(new ToolchainProvisioningBuildOperation<T>(displayName, provisioningStep));
    }

    private static class ToolchainProvisioningBuildOperation<T>
    implements CallableBuildOperation<T> {
        private final String displayName;
        private final Callable<T> provisioningStep;

        public ToolchainProvisioningBuildOperation(String displayName, Callable<T> provisioningStep) {
            this.displayName = displayName;
            this.provisioningStep = provisioningStep;
        }

        public T call(BuildOperationContext context) throws Exception {
            return this.provisioningStep.call();
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)this.displayName).progressDisplayName(this.displayName);
        }
    }

    @Contextual
    private static class MissingToolchainException
    extends GradleException {
        public MissingToolchainException(JavaToolchainSpec spec, @Nullable Throwable cause) {
            super("Unable to download toolchain matching these requirements: " + spec.getDisplayName(), cause);
        }
    }
}

