/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.ModuleDependencyCapabilitiesHandler;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DependencyVariant;
import org.gradle.internal.Actions;

public class DefaultMinimalDependencyVariant
extends DefaultExternalModuleDependency
implements MinimalExternalModuleDependency,
DependencyVariant {
    private final MinimalExternalModuleDependency delegate;
    private final Action<? super AttributeContainer> attributesMutator;
    private final Action<? super ModuleDependencyCapabilitiesHandler> capabilitiesMutator;
    private final String classifier;
    private final String artifactType;

    public DefaultMinimalDependencyVariant(MinimalExternalModuleDependency delegate, @Nullable Action<? super AttributeContainer> attributesMutator, @Nullable Action<? super ModuleDependencyCapabilitiesHandler> capabilitiesMutator, @Nullable String classifier, @Nullable String artifactType) {
        super(delegate.getModule(), new DefaultMutableVersionConstraint(delegate.getVersionConstraint()));
        this.delegate = delegate;
        boolean delegateIsVariant = delegate instanceof DefaultMinimalDependencyVariant;
        Action<? super AttributeContainer> action = delegateIsVariant ? Actions.composite((Action[])new Action[]{((DefaultMinimalDependencyVariant)delegate).attributesMutator, attributesMutator == null ? Actions.doNothing() : attributesMutator}) : (this.attributesMutator = attributesMutator);
        Action<? super ModuleDependencyCapabilitiesHandler> action2 = delegateIsVariant ? Actions.composite((Action[])new Action[]{((DefaultMinimalDependencyVariant)delegate).capabilitiesMutator, capabilitiesMutator == null ? Actions.doNothing() : capabilitiesMutator}) : (this.capabilitiesMutator = capabilitiesMutator);
        if (classifier == null && delegateIsVariant) {
            classifier = ((DefaultMinimalDependencyVariant)delegate).getClassifier();
        }
        if (artifactType == null && delegateIsVariant) {
            artifactType = ((DefaultMinimalDependencyVariant)delegate).getArtifactType();
        }
        this.classifier = classifier;
        this.artifactType = artifactType;
    }

    public void because(String reason) {
        this.validateMutation();
    }

    protected void validateMutation() {
        throw new UnsupportedOperationException("Minimal dependencies are immutable.");
    }

    protected void validateMutation(Object currentValue, Object newValue) {
        this.validateMutation();
    }

    @Override
    public void mutateAttributes(AttributeContainer attributes) {
        if (this.attributesMutator != null) {
            this.attributesMutator.execute((Object)attributes);
        }
    }

    @Override
    public void mutateCapabilities(ModuleDependencyCapabilitiesHandler capabilitiesHandler) {
        if (this.capabilitiesMutator != null) {
            this.capabilitiesMutator.execute((Object)capabilitiesHandler);
        }
    }

    @Override
    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    @Nullable
    public String getArtifactType() {
        return this.artifactType;
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }
}

