/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.utils.KotlinPaths;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/utils/KotlinPathsFromBaseDirectory;", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "basePath", "Ljava/io/File;", "(Ljava/io/File;)V", "getBasePath", "()Ljava/io/File;", "homePath", "getHomePath", "libPath", "getLibPath", "jar", "Lorg/jetbrains/kotlin/utils/KotlinPaths$Jar;", "sourcesJar", "util"})
public class KotlinPathsFromBaseDirectory
implements KotlinPaths {
    @NotNull
    private final File basePath;

    public KotlinPathsFromBaseDirectory(@NotNull File basePath) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.basePath = basePath;
    }

    @NotNull
    public final File getBasePath() {
        return this.basePath;
    }

    @Override
    @NotNull
    public File getHomePath() {
        throw new IllegalStateException("No home path defined");
    }

    @Override
    @NotNull
    public File getLibPath() {
        return this.basePath;
    }

    @Override
    @NotNull
    public File jar(@NotNull KotlinPaths.Jar jar) {
        Intrinsics.checkNotNullParameter((Object)((Object)jar), (String)"jar");
        return FilesKt.resolve((File)this.basePath, (String)(jar.getBaseName() + ".jar"));
    }

    @Override
    @Nullable
    public File sourcesJar(@NotNull KotlinPaths.Jar jar) {
        Intrinsics.checkNotNullParameter((Object)((Object)jar), (String)"jar");
        return FilesKt.resolve((File)this.basePath, (String)(jar.getBaseName() + "-sources.jar"));
    }

    @Override
    @NotNull
    public File getStdlibPath() {
        return KotlinPaths.DefaultImpls.getStdlibPath(this);
    }

    @Override
    @NotNull
    public File getReflectPath() {
        return KotlinPaths.DefaultImpls.getReflectPath(this);
    }

    @Override
    @NotNull
    public File getScriptRuntimePath() {
        return KotlinPaths.DefaultImpls.getScriptRuntimePath(this);
    }

    @Override
    @NotNull
    public File getKotlinTestPath() {
        return KotlinPaths.DefaultImpls.getKotlinTestPath(this);
    }

    @Override
    @NotNull
    public File getStdlibSourcesPath() {
        return KotlinPaths.DefaultImpls.getStdlibSourcesPath(this);
    }

    @Override
    @NotNull
    public File getJsStdLibJarPath() {
        return KotlinPaths.DefaultImpls.getJsStdLibJarPath(this);
    }

    @Override
    @NotNull
    public File getJsStdLibSrcJarPath() {
        return KotlinPaths.DefaultImpls.getJsStdLibSrcJarPath(this);
    }

    @Override
    @NotNull
    public File getJsKotlinTestJarPath() {
        return KotlinPaths.DefaultImpls.getJsKotlinTestJarPath(this);
    }

    @Override
    @NotNull
    public File getAllOpenPluginJarPath() {
        return KotlinPaths.DefaultImpls.getAllOpenPluginJarPath(this);
    }

    @Override
    @NotNull
    public File getNoArgPluginJarPath() {
        return KotlinPaths.DefaultImpls.getNoArgPluginJarPath(this);
    }

    @Override
    @NotNull
    public File getLombokPluginJarPath() {
        return KotlinPaths.DefaultImpls.getLombokPluginJarPath(this);
    }

    @Override
    @NotNull
    public File getSamWithReceiverJarPath() {
        return KotlinPaths.DefaultImpls.getSamWithReceiverJarPath(this);
    }

    @Override
    @NotNull
    public File getTrove4jJarPath() {
        return KotlinPaths.DefaultImpls.getTrove4jJarPath(this);
    }

    @Override
    @NotNull
    public List<File> getCompilerClasspath() {
        return KotlinPaths.DefaultImpls.getCompilerClasspath(this);
    }

    @Override
    @NotNull
    public File getCompilerPath() {
        return KotlinPaths.DefaultImpls.getCompilerPath(this);
    }

    @Override
    @NotNull
    public List<File> classPath(@NotNull Sequence<? extends KotlinPaths.Jar> jars) {
        return KotlinPaths.DefaultImpls.classPath((KotlinPaths)this, jars);
    }

    @Override
    @NotNull
    public List<File> classPath(@NotNull KotlinPaths.ClassPaths base, KotlinPaths.Jar ... additionalJars) {
        return KotlinPaths.DefaultImpls.classPath((KotlinPaths)this, base, additionalJars);
    }

    @Override
    @NotNull
    public List<File> classPath(KotlinPaths.Jar ... jars) {
        return KotlinPaths.DefaultImpls.classPath((KotlinPaths)this, jars);
    }
}

