/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.artifact;

import java.io.File;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.internal.artifact.ArchiveTaskBasedMavenArtifact;
import org.gradle.api.publish.maven.internal.artifact.FileBasedMavenArtifact;
import org.gradle.api.publish.maven.internal.artifact.PublishArtifactBasedMavenArtifact;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.MapNotationConverter;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;

public class MavenArtifactNotationParserFactory
implements Factory<NotationParser<Object, MavenArtifact>> {
    private final Instantiator instantiator;
    private final FileResolver fileResolver;
    private final TaskDependencyFactory taskDependencyFactory;

    public MavenArtifactNotationParserFactory(Instantiator instantiator, FileResolver fileResolver, TaskDependencyFactory taskDependencyFactory) {
        this.instantiator = instantiator;
        this.fileResolver = fileResolver;
        this.taskDependencyFactory = taskDependencyFactory;
    }

    public NotationParser<Object, MavenArtifact> create() {
        FileNotationConverter fileNotationConverter = new FileNotationConverter(this.fileResolver);
        ArchiveTaskNotationConverter archiveTaskNotationConverter = new ArchiveTaskNotationConverter();
        PublishArtifactNotationConverter publishArtifactNotationConverter = new PublishArtifactNotationConverter();
        ProviderNotationConverter providerNotationConverter = new ProviderNotationConverter();
        NotationParser sourceNotationParser = NotationParserBuilder.toType(MavenArtifact.class).fromType(Provider.class, (NotationConverter)Cast.uncheckedCast((Object)providerNotationConverter)).fromType(AbstractArchiveTask.class, (NotationConverter)archiveTaskNotationConverter).fromType(PublishArtifact.class, (NotationConverter)publishArtifactNotationConverter).converter((NotationConverter)fileNotationConverter).toComposite();
        MavenArtifactMapNotationConverter mavenArtifactMapNotationConverter = new MavenArtifactMapNotationConverter(sourceNotationParser);
        return NotationParserBuilder.toType(MavenArtifact.class).fromType(AbstractArchiveTask.class, (NotationConverter)archiveTaskNotationConverter).fromType(PublishArtifact.class, (NotationConverter)publishArtifactNotationConverter).fromType(Provider.class, (NotationConverter)Cast.uncheckedCast((Object)providerNotationConverter)).converter((NotationConverter)mavenArtifactMapNotationConverter).converter((NotationConverter)fileNotationConverter).toComposite();
    }

    private static class MavenArtifactMapNotationConverter
    extends MapNotationConverter<MavenArtifact> {
        private final NotationParser<Object, MavenArtifact> sourceNotationParser;

        private MavenArtifactMapNotationConverter(NotationParser<Object, MavenArtifact> sourceNotationParser) {
            this.sourceNotationParser = sourceNotationParser;
        }

        protected MavenArtifact parseMap(@MapKey(value="source") Object source) {
            return (MavenArtifact)this.sourceNotationParser.parseNotation(source);
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Maps containing a 'source' entry").example("[source: '/path/to/file', extension: 'zip']");
        }
    }

    private class FileNotationConverter
    implements NotationConverter<Object, MavenArtifact> {
        private final NotationParser<Object, File> fileResolverNotationParser;

        private FileNotationConverter(FileResolver fileResolver) {
            this.fileResolverNotationParser = fileResolver.asNotationParser();
        }

        public void convert(Object notation, NotationConvertResult<? super MavenArtifact> result) throws TypeConversionException {
            File file = (File)this.fileResolverNotationParser.parseNotation(notation);
            MavenArtifact mavenArtifact = (MavenArtifact)MavenArtifactNotationParserFactory.this.instantiator.newInstance(FileBasedMavenArtifact.class, new Object[]{file, MavenArtifactNotationParserFactory.this.taskDependencyFactory});
            if (notation instanceof TaskDependencyContainer) {
                TaskDependencyContainer taskDependencyContainer = notation instanceof Provider ? context -> context.add(notation) : (TaskDependencyContainer)notation;
                mavenArtifact.builtBy(new Object[]{taskDependencyContainer});
            }
            result.converted((Object)mavenArtifact);
        }

        public void describe(DiagnosticsVisitor visitor) {
            this.fileResolverNotationParser.describe(visitor);
        }
    }

    private class ProviderNotationConverter
    implements NotationConverter<Provider<?>, MavenArtifact> {
        private ProviderNotationConverter() {
        }

        public void convert(Provider<?> publishArtifact, NotationConvertResult<? super MavenArtifact> result) throws TypeConversionException {
            MavenArtifact artifact = (MavenArtifact)MavenArtifactNotationParserFactory.this.instantiator.newInstance(PublishArtifactBasedMavenArtifact.class, new Object[]{new LazyPublishArtifact(publishArtifact, MavenArtifactNotationParserFactory.this.fileResolver, MavenArtifactNotationParserFactory.this.taskDependencyFactory), MavenArtifactNotationParserFactory.this.taskDependencyFactory});
            result.converted((Object)artifact);
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Instances of Provider");
        }
    }

    private class PublishArtifactNotationConverter
    implements NotationConverter<PublishArtifact, MavenArtifact> {
        private PublishArtifactNotationConverter() {
        }

        public void convert(PublishArtifact publishArtifact, NotationConvertResult<? super MavenArtifact> result) throws TypeConversionException {
            MavenArtifact artifact = (MavenArtifact)MavenArtifactNotationParserFactory.this.instantiator.newInstance(PublishArtifactBasedMavenArtifact.class, new Object[]{publishArtifact, MavenArtifactNotationParserFactory.this.taskDependencyFactory});
            result.converted((Object)artifact);
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Instances of PublishArtifact");
        }
    }

    private class ArchiveTaskNotationConverter
    implements NotationConverter<AbstractArchiveTask, MavenArtifact> {
        private ArchiveTaskNotationConverter() {
        }

        public void convert(AbstractArchiveTask archiveTask, NotationConvertResult<? super MavenArtifact> result) throws TypeConversionException {
            MavenArtifact artifact = (MavenArtifact)MavenArtifactNotationParserFactory.this.instantiator.newInstance(ArchiveTaskBasedMavenArtifact.class, new Object[]{archiveTask, MavenArtifactNotationParserFactory.this.taskDependencyFactory});
            result.converted((Object)artifact);
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Instances of AbstractArchiveTask").example("jar");
        }
    }
}

