/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import java.util.List;
import java.util.TreeMap;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.internal.component.AmbiguousConfigurationSelectionException;
import org.gradle.internal.component.LegacyConfigurationsSupplier;
import org.gradle.internal.component.StyledDescriber;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.exceptions.StyledException;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.TreeFormatter;

public class NoMatchingConfigurationSelectionException
extends StyledException {
    public NoMatchingConfigurationSelectionException(AttributeDescriber describer, AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, ComponentGraphResolveMetadata targetComponent, boolean variantAware) {
        super(NoMatchingConfigurationSelectionException.generateMessage(new StyledDescriber(describer), fromConfigurationAttributes, attributeMatcher, targetComponent, variantAware));
    }

    private static String generateMessage(AttributeDescriber describer, AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, ComponentGraphResolveMetadata targetComponent, boolean variantAware) {
        TreeMap<String, VariantGraphResolveMetadata> variants = new TreeMap<String, VariantGraphResolveMetadata>();
        Optional<List<? extends VariantGraphResolveMetadata>> variantsForGraphTraversal = targetComponent.getVariantsForGraphTraversal();
        List variantsParticipatingInSelection = (List)variantsForGraphTraversal.or((Supplier)new LegacyConfigurationsSupplier(targetComponent));
        for (VariantGraphResolveMetadata variant : variantsParticipatingInSelection) {
            variants.put(variant.getName(), variant);
        }
        TreeFormatter formatter = new TreeFormatter();
        String targetVariantText = NoMatchingConfigurationSelectionException.style((StyledTextOutput.Style)StyledTextOutput.Style.Info, (String)targetComponent.getId().getDisplayName());
        if (fromConfigurationAttributes.isEmpty()) {
            formatter.node("Unable to find a matching " + (variantAware ? "variant" : "configuration") + " of " + targetVariantText);
        } else {
            formatter.node("No matching " + (variantAware ? "variant" : "configuration") + " of " + targetVariantText + " was found. The consumer was configured to find " + describer.describeAttributeSet(fromConfigurationAttributes.asMap()) + " but:");
        }
        formatter.startChildren();
        if (variants.isEmpty()) {
            formatter.node("None of the " + (variantAware ? "variants" : "consumable configurations") + " have attributes.");
        } else {
            for (VariantGraphResolveMetadata variant : variants.values()) {
                AmbiguousConfigurationSelectionException.formatConfiguration(formatter, targetComponent, fromConfigurationAttributes, attributeMatcher, variant, variantAware, false, describer);
            }
        }
        formatter.endChildren();
        return formatter.toString();
    }
}

