/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.serialization.codecs;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.LocalFileDependencyBackedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.transform.TransformedExternalArtifactSet;
import org.gradle.api.internal.artifacts.transform.TransformedProjectArtifactSet;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.configurationcache.serialization.codecs.FixedFileArtifactSpec;
import org.gradle.internal.DisplayName;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J.\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006!"}, d2={"Lorg/gradle/configurationcache/serialization/codecs/CollectingArtifactVisitor;", "Lorg/gradle/api/internal/artifacts/ivyservice/resolveengine/artifact/ArtifactVisitor;", "()V", "artifacts", "", "Lorg/gradle/api/internal/artifacts/ivyservice/resolveengine/artifact/ResolvableArtifact;", "elements", "", "", "getElements", "()Ljava/util/List;", "failures", "", "getFailures", "endVisitCollection", "", "source", "Lorg/gradle/api/internal/file/FileCollectionInternal$Source;", "prepareForVisit", "Lorg/gradle/api/internal/file/FileCollectionStructureVisitor$VisitType;", "requireArtifactFiles", "", "visitArtifact", "variantName", "Lorg/gradle/internal/DisplayName;", "variantAttributes", "Lorg/gradle/api/attributes/AttributeContainer;", "capabilities", "", "Lorg/gradle/api/capabilities/Capability;", "artifact", "visitFailure", "failure", "configuration-cache"})
final class CollectingArtifactVisitor
implements ArtifactVisitor {
    @NotNull
    private final List<Object> elements = new ArrayList();
    @NotNull
    private final List<Throwable> failures = new ArrayList();
    @NotNull
    private final Set<ResolvableArtifact> artifacts = new LinkedHashSet();

    @NotNull
    public final List<Object> getElements() {
        return this.elements;
    }

    @NotNull
    public final List<Throwable> getFailures() {
        return this.failures;
    }

    @NotNull
    public FileCollectionStructureVisitor.VisitType prepareForVisit(@NotNull FileCollectionInternal.Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return source instanceof TransformedProjectArtifactSet || source instanceof LocalFileDependencyBackedArtifactSet || source instanceof TransformedExternalArtifactSet ? FileCollectionStructureVisitor.VisitType.NoContents : FileCollectionStructureVisitor.VisitType.Visit;
    }

    public boolean requireArtifactFiles() {
        return true;
    }

    public void visitFailure(@NotNull Throwable failure) {
        Intrinsics.checkNotNullParameter((Object)failure, (String)"failure");
        this.failures.add(failure);
    }

    public void visitArtifact(@NotNull DisplayName variantName, @NotNull AttributeContainer variantAttributes, @NotNull List<? extends Capability> capabilities, @NotNull ResolvableArtifact artifact) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)variantAttributes, (String)"variantAttributes");
        Intrinsics.checkNotNullParameter(capabilities, (String)"capabilities");
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        if (this.artifacts.add(artifact)) {
            ComponentArtifactIdentifier componentArtifactIdentifier = artifact.getId();
            Intrinsics.checkNotNullExpressionValue((Object)componentArtifactIdentifier, (String)"artifact.id");
            File file = artifact.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"artifact.file");
            this.elements.add(new FixedFileArtifactSpec(componentArtifactIdentifier, variantAttributes, capabilities, variantName, file));
        }
    }

    public void endVisitCollection(@NotNull FileCollectionInternal.Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (source instanceof TransformedProjectArtifactSet) {
            this.elements.add(source);
        } else if (source instanceof LocalFileDependencyBackedArtifactSet) {
            this.elements.add(source);
        } else if (source instanceof TransformedExternalArtifactSet) {
            this.elements.add(source);
        }
    }
}

