/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.quality.CheckstyleReports;
import org.gradle.api.plugins.quality.internal.CheckstyleAction;
import org.gradle.api.plugins.quality.internal.CheckstyleActionParameters;
import org.gradle.api.plugins.quality.internal.CheckstyleReportsImpl;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.VerificationTask;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.CurrentJvmToolchainSpec;
import org.gradle.util.internal.ClosureBackedAction;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public abstract class Checkstyle
extends SourceTask
implements VerificationTask,
Reporting<CheckstyleReports> {
    private FileCollection checkstyleClasspath;
    private FileCollection classpath;
    private TextResource config;
    private Map<String, Object> configProperties = new LinkedHashMap<String, Object>();
    private final CheckstyleReports reports;
    private boolean ignoreFailures;
    private int maxErrors;
    private int maxWarnings = Integer.MAX_VALUE;
    private boolean showViolations = true;
    private final DirectoryProperty configDirectory = this.getObjectFactory().directoryProperty();
    private final Property<JavaLauncher> javaLauncher;
    private final Property<String> minHeapSize;
    private final Property<String> maxHeapSize;
    private final Property<Boolean> enableExternalDtdLoad;

    public Checkstyle() {
        this.reports = (CheckstyleReports)this.getObjectFactory().newInstance(CheckstyleReportsImpl.class, new Object[]{this});
        this.minHeapSize = this.getObjectFactory().property(String.class);
        this.maxHeapSize = this.getObjectFactory().property(String.class);
        this.enableExternalDtdLoad = this.getObjectFactory().property(Boolean.class).convention((Object)false);
        this.javaLauncher = Checkstyle.configureFromCurrentJvmLauncher(this.getToolchainService(), this.getObjectFactory());
    }

    private static Property<JavaLauncher> configureFromCurrentJvmLauncher(JavaToolchainService toolchainService, ObjectFactory objectFactory) {
        Provider currentJvmLauncherProvider = toolchainService.launcherFor((JavaToolchainSpec)new CurrentJvmToolchainSpec(objectFactory));
        return objectFactory.property(JavaLauncher.class).convention(currentJvmLauncherProvider);
    }

    @Internal
    public File getConfigFile() {
        return this.getConfig() == null ? null : this.getConfig().asFile();
    }

    public void setConfigFile(File configFile) {
        this.setConfig(this.getProject().getResources().getText().fromFile((Object)configFile));
    }

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected JavaToolchainService getToolchainService() {
        throw new UnsupportedOperationException();
    }

    @Inject
    public WorkerExecutor getWorkerExecutor() {
        throw new UnsupportedOperationException();
    }

    public CheckstyleReports reports(@DelegatesTo(value=CheckstyleReports.class, strategy=1) Closure closure) {
        return this.reports((Action)new ClosureBackedAction(closure));
    }

    public CheckstyleReports reports(Action<? super CheckstyleReports> configureAction) {
        configureAction.execute((Object)this.reports);
        return this.reports;
    }

    @Nested
    public Property<JavaLauncher> getJavaLauncher() {
        return this.javaLauncher;
    }

    @TaskAction
    public void run() {
        this.runWithProcessIsolation();
    }

    private void runWithProcessIsolation() {
        WorkQueue workQueue = this.getWorkerExecutor().processIsolation(spec -> {
            spec.getForkOptions().setMinHeapSize((String)this.minHeapSize.getOrNull());
            spec.getForkOptions().setMaxHeapSize((String)this.maxHeapSize.getOrNull());
            spec.getForkOptions().setExecutable(((JavaLauncher)this.javaLauncher.get()).getExecutablePath().getAsFile().getAbsolutePath());
            spec.getForkOptions().getSystemProperties().put("checkstyle.enableExternalDtdLoad", this.getEnableExternalDtdLoad().get());
            spec.getClasspath().from(new Object[]{this.getCheckstyleClasspath()});
        });
        workQueue.submit(CheckstyleAction.class, this::setupParameters);
    }

    private void setupParameters(CheckstyleActionParameters parameters) {
        parameters.getConfig().set(this.getConfigFile());
        parameters.getMaxErrors().set((Object)this.getMaxErrors());
        parameters.getMaxWarnings().set((Object)this.getMaxWarnings());
        parameters.getIgnoreFailures().set((Object)this.getIgnoreFailures());
        parameters.getConfigDirectory().set((Provider)this.getConfigDirectory());
        parameters.getShowViolations().set((Object)this.isShowViolations());
        parameters.getSource().setFrom((Iterable)this.getSource());
        parameters.getIsHtmlRequired().set((Provider)this.getReports().getHtml().getRequired());
        parameters.getIsXmlRequired().set((Provider)this.getReports().getXml().getRequired());
        parameters.getXmlOuputLocation().set((Provider)this.getReports().getXml().getOutputLocation());
        parameters.getHtmlOuputLocation().set((Provider)this.getReports().getHtml().getOutputLocation());
        parameters.getTemporaryDir().set(this.getTemporaryDir());
        parameters.getConfigProperties().set(this.getConfigProperties());
        TextResource stylesheetString = this.getReports().getHtml().getStylesheet();
        if (stylesheetString != null) {
            parameters.getStylesheetString().set((Object)stylesheetString.asString());
        }
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    @Classpath
    public FileCollection getCheckstyleClasspath() {
        return this.checkstyleClasspath;
    }

    public void setCheckstyleClasspath(FileCollection checkstyleClasspath) {
        this.checkstyleClasspath = checkstyleClasspath;
    }

    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @Nested
    public TextResource getConfig() {
        return this.config;
    }

    public void setConfig(TextResource config) {
        this.config = config;
    }

    @Nullable
    @Optional
    @Input
    public Map<String, Object> getConfigProperties() {
        return this.configProperties;
    }

    public void setConfigProperties(@Nullable Map<String, Object> configProperties) {
        this.configProperties = configProperties;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public DirectoryProperty getConfigDirectory() {
        return this.configDirectory;
    }

    @Nested
    public final CheckstyleReports getReports() {
        return this.reports;
    }

    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    @Internal
    public boolean isIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    @Input
    public int getMaxErrors() {
        return this.maxErrors;
    }

    public void setMaxErrors(int maxErrors) {
        this.maxErrors = maxErrors;
    }

    @Input
    public int getMaxWarnings() {
        return this.maxWarnings;
    }

    public void setMaxWarnings(int maxWarnings) {
        this.maxWarnings = maxWarnings;
    }

    @Console
    public boolean isShowViolations() {
        return this.showViolations;
    }

    public void setShowViolations(boolean showViolations) {
        this.showViolations = showViolations;
    }

    @Optional
    @Input
    public Property<String> getMinHeapSize() {
        return this.minHeapSize;
    }

    @Optional
    @Input
    public Property<String> getMaxHeapSize() {
        return this.maxHeapSize;
    }

    @Incubating
    @Input
    public Property<Boolean> getEnableExternalDtdLoad() {
        return this.enableExternalDtdLoad;
    }
}

