/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.resolve.dfa.UtilKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConePropertyAsOperator;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirConventionFunctionCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkPropertyAsOperator", "callExpression", "receiver", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "checkers"})
public final class FirConventionFunctionCallChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirConventionFunctionCallChecker INSTANCE = new FirConventionFunctionCallChecker();

    private FirConventionFunctionCallChecker() {
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.checkPropertyAsOperator(expression2, expression2.getDispatchReceiver(), context, reporter);
        this.checkPropertyAsOperator(expression2, expression2.getExtensionReceiver(), context, reporter);
        Object object = expression2.getCalleeReference();
        FirErrorNamedReference firErrorNamedReference = object instanceof FirErrorNamedReference ? (FirErrorNamedReference)object : null;
        if (firErrorNamedReference == null) {
            return;
        }
        FirErrorNamedReference calleeReference = firErrorNamedReference;
        ConeDiagnostic coneDiagnostic = calleeReference.getDiagnostic();
        ConeUnresolvedNameError coneUnresolvedNameError = coneDiagnostic instanceof ConeUnresolvedNameError ? (ConeUnresolvedNameError)coneDiagnostic : null;
        if (coneUnresolvedNameError == null) {
            return;
        }
        ConeUnresolvedNameError diagnostic = coneUnresolvedNameError;
        KtSourceElement ktSourceElement = expression2.getCalleeReference().getSource();
        if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.ArrayAccessNameReference.INSTANCE)) {
            object = diagnostic.getName();
            if (Intrinsics.areEqual((Object)object, (Object)OperatorNameConventions.GET)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)calleeReference.getSource(), FirErrors.INSTANCE.getNO_GET_METHOD(), (DiagnosticContext)context, null, 8, null);
            } else if (Intrinsics.areEqual((Object)object, (Object)OperatorNameConventions.SET)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)calleeReference.getSource(), FirErrors.INSTANCE.getNO_SET_METHOD(), (DiagnosticContext)context, null, 8, null);
            }
        }
    }

    private final void checkPropertyAsOperator(FirFunctionCall callExpression, FirExpression receiver, CheckerContext context, DiagnosticReporter reporter) {
        Object v2;
        block4: {
            KtSourceElementKind sourceKind;
            KtSourceElement ktSourceElement = callExpression.getSource();
            KtSourceElementKind ktSourceElementKind = sourceKind = ktSourceElement != null ? ktSourceElement.getKind() : null;
            if (!(sourceKind instanceof KtRealSourceElementKind || sourceKind instanceof KtFakeSourceElementKind.GeneratedComparisonExpression || sourceKind instanceof KtFakeSourceElementKind.DesugaredCompoundAssignment)) {
                return;
            }
            FirExpression unwrapped = UtilKt.unwrapSmartcastExpression(receiver);
            if (!(unwrapped instanceof FirPropertyAccessExpression)) {
                return;
            }
            Iterable $this$firstIsInstanceOrNull$iv = ((FirPropertyAccessExpression)unwrapped).getNonFatalDiagnostics();
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof ConePropertyAsOperator)) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        ConePropertyAsOperator conePropertyAsOperator = v2;
        if (conePropertyAsOperator == null) {
            return;
        }
        ConePropertyAsOperator diagnostic = conePropertyAsOperator;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)callExpression.getCalleeReference().getSource(), FirErrors.INSTANCE.getPROPERTY_AS_OPERATOR(), (Object)diagnostic.getSymbol(), (DiagnosticContext)context, null, 16, null);
    }
}

