/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import org.gradle.cache.GlobalCacheLocations;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;

public class SplitFileHasher
implements FileHasher {
    private final FileHasher globalHasher;
    private final FileHasher localHasher;
    private final GlobalCacheLocations globalCacheLocations;

    public SplitFileHasher(FileHasher globalHasher, FileHasher localHasher, GlobalCacheLocations globalCacheLocations) {
        this.globalHasher = globalHasher;
        this.localHasher = localHasher;
        this.globalCacheLocations = globalCacheLocations;
    }

    public HashCode hash(File file) {
        if (this.globalCacheLocations.isInsideGlobalCache(file.getPath())) {
            return this.globalHasher.hash(file);
        }
        return this.localHasher.hash(file);
    }

    public HashCode hash(File file, long length, long lastModified) {
        if (this.globalCacheLocations.isInsideGlobalCache(file.getPath())) {
            return this.globalHasher.hash(file, length, lastModified);
        }
        return this.localHasher.hash(file, length, lastModified);
    }
}

