/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import javax.inject.Inject;
import org.gradle.api.internal.file.FileFactory;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmMetadataDetector;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.JavaCompilerFactory;
import org.gradle.jvm.toolchain.internal.JavaToolchain;
import org.gradle.jvm.toolchain.internal.JavaToolchainInput;
import org.gradle.jvm.toolchain.internal.JavaToolchainInstantiationResult;
import org.gradle.jvm.toolchain.internal.ToolchainToolFactory;

public class JavaToolchainFactory {
    private final JavaCompilerFactory compilerFactory;
    private final ToolchainToolFactory toolFactory;
    private final FileFactory fileFactory;
    private final JvmMetadataDetector detector;
    private final BuildOperationProgressEventEmitter eventEmitter;

    @Inject
    public JavaToolchainFactory(JvmMetadataDetector detector, JavaCompilerFactory compilerFactory, ToolchainToolFactory toolFactory, FileFactory fileFactory, BuildOperationProgressEventEmitter eventEmitter) {
        this.detector = detector;
        this.compilerFactory = compilerFactory;
        this.toolFactory = toolFactory;
        this.fileFactory = fileFactory;
        this.eventEmitter = eventEmitter;
    }

    public JavaToolchainInstantiationResult newInstance(InstallationLocation javaHome, JavaToolchainInput input, boolean isFallbackToolchain) {
        JvmInstallationMetadata metadata = this.detector.getMetadata(javaHome);
        if (metadata.isValidInstallation()) {
            JavaToolchain toolchain = new JavaToolchain(metadata, this.compilerFactory, this.toolFactory, this.fileFactory, input, isFallbackToolchain, this.eventEmitter);
            return new JavaToolchainInstantiationResult(javaHome, metadata, toolchain);
        }
        return new JavaToolchainInstantiationResult(javaHome, metadata);
    }
}

