/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.properties.annotations;

import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.Named;
import org.gradle.api.provider.Provider;
import org.gradle.internal.properties.annotations.PropertyMetadata;
import org.gradle.internal.properties.annotations.TypeMetadata;
import org.gradle.internal.properties.annotations.TypeMetadataStore;
import org.gradle.internal.properties.annotations.TypeMetadataWalker;

abstract class AbstractTypeMetadataWalker<T>
implements TypeMetadataWalker<T> {
    private final TypeMetadataStore typeMetadataStore;
    private final Class<? extends Annotation> nestedAnnotation;
    private final Supplier<Map<T, String>> nestedNodeToQualifiedNameMapFactory;

    private AbstractTypeMetadataWalker(TypeMetadataStore typeMetadataStore, Class<? extends Annotation> nestedAnnotation, Supplier<Map<T, String>> nestedNodeToQualifiedNameMapFactory) {
        this.typeMetadataStore = typeMetadataStore;
        this.nestedAnnotation = nestedAnnotation;
        this.nestedNodeToQualifiedNameMapFactory = nestedNodeToQualifiedNameMapFactory;
    }

    @Override
    public void walk(T root, TypeMetadataWalker.TypeMetadataVisitor<T> visitor) {
        Class<?> nodeType = this.resolveType(root);
        TypeMetadata typeMetadata = this.typeMetadataStore.getTypeMetadata(nodeType);
        visitor.visitRoot(typeMetadata, root);
        this.walkChildren(root, typeMetadata, null, visitor, this.nestedNodeToQualifiedNameMapFactory.get());
    }

    private void walk(T node, String qualifiedName, PropertyMetadata propertyMetadata, TypeMetadataWalker.TypeMetadataVisitor<T> visitor, Map<T, String> nestedNodesWalkedOnPath) {
        Class<?> nodeType = this.resolveType(node);
        TypeMetadata typeMetadata = this.typeMetadataStore.getTypeMetadata(nodeType);
        if (Provider.class.isAssignableFrom(nodeType)) {
            this.handleProvider(node, child -> this.walk(child, qualifiedName, propertyMetadata, visitor, nestedNodesWalkedOnPath));
        } else if (Map.class.isAssignableFrom(nodeType) && !typeMetadata.hasAnnotatedProperties()) {
            this.handleMap(node, (name, child) -> this.walk(child, AbstractTypeMetadataWalker.getQualifiedName(qualifiedName, name), propertyMetadata, visitor, nestedNodesWalkedOnPath));
        } else if (Iterable.class.isAssignableFrom(nodeType) && !typeMetadata.hasAnnotatedProperties()) {
            this.handleIterable(node, (name, child) -> this.walk(child, AbstractTypeMetadataWalker.getQualifiedName(qualifiedName, name), propertyMetadata, visitor, nestedNodesWalkedOnPath));
        } else {
            this.handleNested(node, typeMetadata, qualifiedName, propertyMetadata, visitor, nestedNodesWalkedOnPath);
        }
    }

    private void walkChildren(T node, TypeMetadata typeMetadata, @Nullable String parentQualifiedName, TypeMetadataWalker.TypeMetadataVisitor<T> visitor, Map<T, String> nestedNodesOnPath) {
        typeMetadata.getPropertiesMetadata().forEach(propertyMetadata -> {
            String childQualifiedName = AbstractTypeMetadataWalker.getQualifiedName(parentQualifiedName, propertyMetadata.getPropertyName());
            if (propertyMetadata.getPropertyType() == this.nestedAnnotation) {
                Optional<Object> childOptional = this.getChild(node, (PropertyMetadata)propertyMetadata);
                childOptional.ifPresent(child -> this.walk((T)child, childQualifiedName, (PropertyMetadata)propertyMetadata, visitor, nestedNodesOnPath));
            } else {
                visitor.visitLeaf(childQualifiedName, (PropertyMetadata)propertyMetadata, () -> this.getChild(node, (PropertyMetadata)propertyMetadata).orElse(null));
            }
        });
    }

    private void handleNested(T node, TypeMetadata typeMetadata, String qualifiedName, PropertyMetadata propertyMetadata, TypeMetadataWalker.TypeMetadataVisitor<T> visitor, Map<T, String> nestedNodesOnPath) {
        String firstOccurrenceQualifiedName = nestedNodesOnPath.putIfAbsent(node, qualifiedName);
        if (firstOccurrenceQualifiedName != null) {
            this.onNestedNodeCycle(firstOccurrenceQualifiedName, qualifiedName);
            return;
        }
        visitor.visitNested(typeMetadata, qualifiedName, propertyMetadata, node);
        this.walkChildren(node, typeMetadata, qualifiedName, visitor, nestedNodesOnPath);
        nestedNodesOnPath.remove(node);
    }

    protected abstract void onNestedNodeCycle(@Nullable String var1, String var2);

    protected abstract void handleProvider(T var1, Consumer<T> var2);

    protected abstract void handleMap(T var1, BiConsumer<String, T> var2);

    protected abstract void handleIterable(T var1, BiConsumer<String, T> var2);

    protected abstract Class<?> resolveType(T var1);

    protected abstract Optional<T> getChild(T var1, PropertyMetadata var2);

    private static String getQualifiedName(@Nullable String parentPropertyName, String childPropertyName) {
        return parentPropertyName == null ? childPropertyName : parentPropertyName + "." + childPropertyName;
    }

    static class StaticTypeMetadataWalker
    extends AbstractTypeMetadataWalker<TypeToken<?>> {
        public StaticTypeMetadataWalker(TypeMetadataStore typeMetadataStore, Class<? extends Annotation> nestedAnnotation) {
            super(typeMetadataStore, nestedAnnotation, HashMap::new);
        }

        @Override
        protected Class<?> resolveType(TypeToken<?> type) {
            return type.getRawType();
        }

        @Override
        protected void onNestedNodeCycle(@Nullable String firstOccurrenceQualifiedName, String secondOccurrenceQualifiedName) {
        }

        @Override
        protected void handleProvider(TypeToken<?> node, Consumer<TypeToken<?>> handler) {
            handler.accept(StaticTypeMetadataWalker.extractNestedType(node, Provider.class, 0));
        }

        @Override
        protected void handleMap(TypeToken<?> node, BiConsumer<String, TypeToken<?>> handler) {
            handler.accept("<key>", StaticTypeMetadataWalker.extractNestedType(node, Map.class, 1));
        }

        @Override
        protected void handleIterable(TypeToken<?> node, BiConsumer<String, TypeToken<?>> handler) {
            TypeToken<?> nestedType = StaticTypeMetadataWalker.extractNestedType(node, Iterable.class, 0);
            handler.accept(StaticTypeMetadataWalker.determinePropertyName(nestedType), nestedType);
        }

        @Override
        protected Optional<TypeToken<?>> getChild(TypeToken<?> parent, PropertyMetadata property) {
            return Optional.of(TypeToken.of((Type)property.getGetterMethod().getGenericReturnType()));
        }

        private static String determinePropertyName(TypeToken<?> nestedType) {
            return Named.class.isAssignableFrom(nestedType.getRawType()) ? "<name>" : "*";
        }

        private static <T> TypeToken<?> extractNestedType(TypeToken<T> beanType, Class<? super T> parameterizedSuperClass, int typeParameterIndex) {
            ParameterizedType type = (ParameterizedType)beanType.getSupertype(parameterizedSuperClass).getType();
            return TypeToken.of((Type)type.getActualTypeArguments()[typeParameterIndex]);
        }
    }

    static class InstanceTypeMetadataWalker
    extends AbstractTypeMetadataWalker<Object> {
        public InstanceTypeMetadataWalker(TypeMetadataStore typeMetadataStore, Class<? extends Annotation> nestedAnnotation) {
            super(typeMetadataStore, nestedAnnotation, IdentityHashMap::new);
        }

        @Override
        protected Class<?> resolveType(Object value) {
            return value.getClass();
        }

        @Override
        protected void onNestedNodeCycle(@Nullable String firstOccurrenceQualifiedName, String secondOccurrenceQualifiedName) {
            throw new IllegalStateException(String.format("Cycles between nested beans are not allowed. Cycle detected between: '%s' and '%s'.", firstOccurrenceQualifiedName, secondOccurrenceQualifiedName));
        }

        @Override
        protected void handleProvider(Object node, Consumer<Object> handler) {
            handler.accept(((Provider)node).get());
        }

        @Override
        protected void handleMap(Object node, BiConsumer<String, Object> handler) {
            ((Map)node).forEach(handler);
        }

        @Override
        protected void handleIterable(Object node, BiConsumer<String, Object> handler) {
            int counter = 1;
            for (Object o : (Iterable)node) {
                handler.accept("$" + counter++, o);
            }
        }

        @Override
        protected Optional<Object> getChild(Object parent, PropertyMetadata property) {
            try {
                return Optional.ofNullable(property.getGetterMethod().invoke(parent, new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

