/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.properties.bean;

import java.util.Map;
import org.gradle.internal.properties.annotations.TypeMetadata;
import org.gradle.internal.properties.annotations.TypeMetadataStore;
import org.gradle.internal.properties.bean.ImplementationResolver;
import org.gradle.internal.properties.bean.IterableRuntimeBeanNode;
import org.gradle.internal.properties.bean.MapRuntimeBeanNode;
import org.gradle.internal.properties.bean.NestedRuntimeBeanNode;
import org.gradle.internal.properties.bean.RootRuntimeBeanNode;
import org.gradle.internal.properties.bean.RuntimeBeanNode;
import org.gradle.internal.snapshot.impl.ImplementationValue;

public class RuntimeBeanNodeFactory {
    private final TypeMetadataStore metadataStore;
    private final ImplementationResolver implementationResolver;

    public RuntimeBeanNodeFactory(TypeMetadataStore metadataStore, ImplementationResolver implementationResolver) {
        this.metadataStore = metadataStore;
        this.implementationResolver = implementationResolver;
    }

    public RuntimeBeanNode<?> createRoot(Object bean) {
        return new RootRuntimeBeanNode(bean, this.metadataStore.getTypeMetadata(bean.getClass()));
    }

    public RuntimeBeanNode<?> create(RuntimeBeanNode parentNode, String propertyName, Object bean) {
        parentNode.checkCycles(propertyName, bean);
        TypeMetadata typeMetadata = this.metadataStore.getTypeMetadata(bean.getClass());
        if (!typeMetadata.hasAnnotatedProperties()) {
            if (bean instanceof Map) {
                return new MapRuntimeBeanNode(parentNode, propertyName, (Map)bean);
            }
            if (bean instanceof Iterable) {
                return new IterableRuntimeBeanNode(parentNode, propertyName, (Iterable)bean);
            }
        }
        ImplementationValue implementation = this.implementationResolver.resolveImplementation(bean);
        return new NestedRuntimeBeanNode(parentNode, propertyName, bean, implementation, typeMetadata);
    }
}

