/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.transform.ExecuteScheduledTransformationStepBuildOperationDetails;
import org.gradle.api.internal.artifacts.transform.TransformationNode;
import org.gradle.execution.plan.Node;
import org.gradle.internal.build.event.BuildEventSubscriptions;
import org.gradle.internal.build.event.types.DefaultOperationDescriptor;
import org.gradle.internal.build.event.types.DefaultOperationFinishedProgressEvent;
import org.gradle.internal.build.event.types.DefaultOperationStartedProgressEvent;
import org.gradle.internal.build.event.types.DefaultTransformDescriptor;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.internal.protocol.events.InternalOperationDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalOperationFinishedProgressEvent;
import org.gradle.tooling.internal.protocol.events.InternalOperationStartedProgressEvent;
import org.gradle.tooling.internal.provider.runner.BuildOperationMapper;
import org.gradle.tooling.internal.provider.runner.ClientForwardingBuildOperationListener;
import org.gradle.tooling.internal.provider.runner.OperationDependenciesResolver;
import org.gradle.tooling.internal.provider.runner.OperationDependencyLookup;

class TransformOperationMapper
implements BuildOperationMapper<ExecuteScheduledTransformationStepBuildOperationDetails, DefaultTransformDescriptor>,
OperationDependencyLookup {
    private final Map<TransformationNode, DefaultTransformDescriptor> descriptors = new ConcurrentHashMap<TransformationNode, DefaultTransformDescriptor>();
    private final OperationDependenciesResolver operationDependenciesResolver;

    TransformOperationMapper(OperationDependenciesResolver operationDependenciesResolver) {
        this.operationDependenciesResolver = operationDependenciesResolver;
    }

    @Override
    public boolean isEnabled(BuildEventSubscriptions subscriptions) {
        return subscriptions.isRequested(OperationType.TRANSFORM);
    }

    @Override
    public Class<ExecuteScheduledTransformationStepBuildOperationDetails> getDetailsType() {
        return ExecuteScheduledTransformationStepBuildOperationDetails.class;
    }

    @Override
    public InternalOperationDescriptor lookupExistingOperationDescriptor(Node node) {
        if (node instanceof TransformationNode) {
            return (InternalOperationDescriptor)this.descriptors.get(node);
        }
        return null;
    }

    @Override
    public DefaultTransformDescriptor createDescriptor(ExecuteScheduledTransformationStepBuildOperationDetails details, BuildOperationDescriptor buildOperation, @Nullable OperationIdentifier parent) {
        OperationIdentifier id = buildOperation.getId();
        String displayName = buildOperation.getDisplayName();
        String transformerName = details.getTransformerName();
        String subjectName = details.getSubjectName();
        Set<InternalOperationDescriptor> dependencies = this.operationDependenciesResolver.resolveDependencies((Node)details.getTransformationNode());
        DefaultTransformDescriptor descriptor = new DefaultTransformDescriptor(id, displayName, parent, transformerName, subjectName, dependencies);
        this.descriptors.put(details.getTransformationNode(), descriptor);
        return descriptor;
    }

    @Override
    public InternalOperationStartedProgressEvent createStartedEvent(DefaultTransformDescriptor descriptor, ExecuteScheduledTransformationStepBuildOperationDetails executeScheduledTransformationStepBuildOperationDetails, OperationStartEvent startEvent) {
        return new DefaultOperationStartedProgressEvent(startEvent.getStartTime(), (DefaultOperationDescriptor)descriptor);
    }

    @Override
    public InternalOperationFinishedProgressEvent createFinishedEvent(DefaultTransformDescriptor descriptor, ExecuteScheduledTransformationStepBuildOperationDetails executeScheduledTransformationStepBuildOperationDetails, OperationFinishEvent finishEvent) {
        return new DefaultOperationFinishedProgressEvent(finishEvent.getEndTime(), (DefaultOperationDescriptor)descriptor, ClientForwardingBuildOperationListener.toOperationResult(finishEvent));
    }
}

